/*
 * Decompiled with CFR 0.152.
 */
package nex.village;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import lex.LibEx;
import lex.config.Config;
import lex.util.FileHelper;
import lex.village.Trade;
import nex.NetherEx;
import nex.village.Pigtificate;

public class PigtificateTradeManager {
    public static void preInit() {
        FileHelper.copyDirectoryToDirectory((URL)NetherEx.class.getResource("/assets/nex/trade_configs"), (File)new File(LibEx.CONFIG_DIRECTORY, "NetherEx/Trades"));
    }

    public static void setupDefaultTrades() {
        NetherEx.LOGGER.info("Setting up default trades.");
        PigtificateTradeManager.parseTradeConfigs(new File(LibEx.CONFIG_DIRECTORY, "NetherEx/Trades/nex"));
    }

    public static void setupCustomTrades() {
        NetherEx.LOGGER.info("Setting up custom trades.");
        PigtificateTradeManager.parseTradeConfigs(new File(LibEx.CONFIG_DIRECTORY, "NetherEx/Trades/custom"));
    }

    private static void parseTradeConfigs(File directory) {
        if (!directory.exists()) {
            directory.mkdirs();
        }
        Path directoryPath = directory.toPath();
        try {
            Iterator pathIter = Files.walk(directoryPath, new FileVisitOption[0]).iterator();
            while (pathIter.hasNext()) {
                Path configPath = (Path)pathIter.next();
                File configFile = configPath.toFile();
                if (FileHelper.getFileExtension((File)configFile).equals("json")) {
                    PigtificateTradeManager.createTrade(new Config(configFile, false));
                    continue;
                }
                if (configFile.isDirectory()) continue;
                NetherEx.LOGGER.warn("Skipping file located at {}, as it is not a json file.", (Object)configPath.toString());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void createTrade(Config config) {
        Pigtificate.Career career = (Pigtificate.Career)config.getEnum("career", Pigtificate.Career.class);
        if (career != null) {
            List tradeConfigs = config.getDataBranches("trades", new ArrayList());
            for (Config tradeConfig : tradeConfigs) {
                career.addTrade(new Trade(tradeConfig));
            }
        }
    }

    public static void resetTrades() {
        for (Pigtificate.Career career : Pigtificate.Career.values()) {
            career.removeAllTrades();
        }
    }
}

