/*
 * Decompiled with CFR 0.152.
 */
package nex.handler;

import java.io.File;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Optional;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import nex.NetherEx;

@Config.LangKey(value="config.nex:title")
@Config(modid="nex", name="NetherEx/nex", category="nex")
public class ConfigHandler {
    @Config.Name(value="client")
    @Config.LangKey(value="config.nex:client")
    public static ClientConfig clientConfig = new ClientConfig();
    @Config.Name(value="compatibility")
    @Config.LangKey(value="config.nex:compatibility")
    public static CompatibilityConfig compatibilityConfig = new CompatibilityConfig();
    @Config.Name(value="dimension")
    @Config.LangKey(value="config.nex:dimension")
    public static DimensionConfig dimensionConfig = new DimensionConfig();
    @Config.Name(value="block")
    @Config.LangKey(value="config.nex:block")
    public static BlockConfig blockConfig = new BlockConfig();
    @Config.Name(value="potion_effect")
    @Config.LangKey(value="config.nex:potionEffect")
    public static PotionEffectConfig potionEffectConfig = new PotionEffectConfig();
    @Config.Name(value="entity")
    @Config.LangKey(value="config.nex:entity")
    public static EntityConfig entityConfig = new EntityConfig();
    @Config.Name(value="biome")
    @Config.LangKey(value="config.nex:biome")
    public static BiomeConfig biomeConfig = new BiomeConfig();
    private static Configuration config;

    public static void preInit() {
        config = ConfigHandler.getConfig();
        if (config != null) {
            ConfigCategory soulSandCategory = config.getCategory("nex.block.soul_sand");
            soulSandCategory.remove((Object)"doesNetherwartUseNewGrowthSystem");
            soulSandCategory.remove((Object)"doesRequireIchorInsteadOfLava");
            config.getCategory("nex.block.nether_portal").remove((Object)"allowPigmanSpawning");
            config.renameProperty("nex.block.thornstalk", "blacklist", "mobBlacklist");
            config.renameProperty("nex.block.hyphae", "doesSpread", "shouldSpread");
            config.renameProperty("nex.potion_effect.freeze", "blacklist", "mobBlacklist");
            config.renameProperty("nex.potion_effect.freeze", "chanceOfThawing", "thawRarity");
            config.renameProperty("nex.potion_effect.spore", "blacklist", "mobBlacklist");
            config.renameProperty("nex.potion_effect.spore", "chanceOfSporeSpawning", "sporeSpawnRarity");
            config.renameProperty("nex.potion_effect.lost", "chanceOfGhastlingSpawning", "ghastlingSpawnRarity");
            config.renameProperty("nex.entity.ember", "chanceOfSettingPlayerOnFire", "setPlayerOnFireRarity");
            config.renameProperty("nex.entity.nethermite", "chanceOfSpawning", "spawnRarity");
            config.renameProperty("nex.entity.nethermite", "whitelist", "blockWhitelist");
            config.renameProperty("nex.entity.spore_creeper", "chanceOfSporeSpawning", "sporeSpawnRarity");
            config.renameProperty("nex.entity.spore", "creeperSpawns", "creeperSpawnAmount");
            config.renameProperty("nex.entity.ghast_queen", "ghastlingSpawns", "ghastlingSpawnAmount");
            config.renameProperty("nex.biome.arctic_abyss", "chanceOfFreezing", "mobFreezeRarity");
            config.save();
        }
    }

    private static Configuration getConfig() {
        if (config == null) {
            try {
                MethodHandle CONFIGS_GETTER = MethodHandles.lookup().unreflectGetter(ReflectionHelper.findField(ConfigManager.class, (String[])new String[]{"CONFIGS", null}));
                String fileName = "nex.cfg";
                Map configsMap = CONFIGS_GETTER.invokeExact();
                Optional<Map.Entry> entryOptional = configsMap.entrySet().stream().filter(entry -> fileName.equals(new File((String)entry.getKey()).getName())).findFirst();
                entryOptional.ifPresent(configEntry -> {
                    config = (Configuration)configEntry.getValue();
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return config;
    }

    @Mod.EventBusSubscriber(modid="nex")
    public static class ConfigSyncHandler {
        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("nex")) {
                ConfigManager.sync((String)"nex", (Config.Type)Config.Type.INSTANCE);
                NetherEx.LOGGER.info("Configuration has been saved.");
            }
        }
    }

    public static class BiomeConfig {
        @Config.Name(value="hell")
        @Config.LangKey(value="config.nex:biome.hell")
        public Hell hell = new Hell();
        @Config.Name(value="ruthless_sands")
        @Config.LangKey(value="config.nex:biome.ruthlessSands")
        public RuthlessSands ruthlessSands = new RuthlessSands();
        @Config.Name(value="fungi_forest")
        @Config.LangKey(value="config.nex:biome.fungiForest")
        public FungiForest fungiForest = new FungiForest();
        @Config.Name(value="torrid_wasteland")
        @Config.LangKey(value="config.nex:biome.torridWasteland")
        public TorridWasteland torridWasteland = new TorridWasteland();
        @Config.Name(value="arctic_abyss")
        @Config.LangKey(value="config.nex:biome.arcticAbyss")
        public ArcticAbyss arcticAbyss = new ArcticAbyss();

        public class ArcticAbyss {
            @Config.LangKey(value="config.nex:biome.arcticAbyss.canPlayersFreeze")
            @Config.Comment(value={"Whether or not players can freeze in the Arctic Abyss"})
            public boolean canPlayersFreeze = false;
            @Config.LangKey(value="config.nex:biome.arcticAbyss.mobFreezeRarity")
            @Config.Comment(value={"The higher the number, the rarer it is for mobs to freeze in the Arctic Abyss biome", "The lower the number, the more common it is for mobs to freeze in the Arctic Abyss biome"})
            @Config.RangeInt(min=1)
            public int mobFreezeRarity = 512;
        }

        public class TorridWasteland {
        }

        public class FungiForest {
        }

        public class RuthlessSands {
        }

        public class Hell {
        }
    }

    public static class EntityConfig {
        @Config.Name(value="ember")
        @Config.LangKey(value="config.nex:entity.ember")
        public Ember ember = new Ember();
        @Config.Name(value="nethermite")
        @Config.LangKey(value="config.nex:entity.nethermite")
        public Nethermite nethermite = new Nethermite();
        @Config.Name(value="spinout")
        @Config.LangKey(value="config.nex:entity.spinout")
        public Spinout spinout = new Spinout();
        @Config.Name(value="spore_creeper")
        @Config.LangKey(value="config.nex:entity.sporeCreeper")
        public SporeCreeper sporeCreeper = new SporeCreeper();
        @Config.Name(value="spore")
        @Config.LangKey(value="config.nex:entity.spore")
        public Spore spore = new Spore();
        @Config.Name(value="brute")
        @Config.LangKey(value="config.nex:entity.brute")
        public Brute brute = new Brute();
        @Config.Name(value="ghast")
        @Config.LangKey(value="config.nex:entity.ghast")
        public Ghast ghast = new Ghast();
        @Config.Name(value="ghast_queen")
        @Config.LangKey(value="config.nex:entity.ghastQueen")
        public GhastQueen ghastQueen = new GhastQueen();
        @Config.Name(value="wither_skeleton")
        @Config.LangKey(value="config.nex:entity.witherSkeleton")
        public WitherSkeleton witherSkeleton = new WitherSkeleton();

        public class WitherSkeleton {
            @Config.LangKey(value="config.nex:entity.witherSkeleton.boneDropRarity")
            @Config.Comment(value={"The lower the number, the more common it is for a Bone to drop", "The higher the number, the rarer it is for a Bone drop", "If set to 0, Bones do not drop"})
            @Config.RangeInt(min=0)
            public int boneDropRarity = 4;
        }

        public class GhastQueen {
            @Config.LangKey(value="config.nex:entity.ghastQueen.ghastlingSpawnCooldown")
            @Config.Comment(value={"The lower the number, the less cooldown the Ghast Queen has after spawning Ghastlings", "The higher the number, the more cooldown the Ghast Queen has after spawning Ghastlings"})
            @Config.RangeInt(min=1)
            public int ghastlingSpawnCooldown = 10;
            @Config.LangKey(value="config.nex:entity.ghastQueen.ghastlingSpawnAmount")
            @Config.Comment(value={"The lower the number, the less Ghastling spawn", "The higher the number, the more Ghastling spawn"})
            @Config.RangeInt(min=1)
            public int ghastlingSpawnAmount = 4;
        }

        public class Ghast {
            @Config.LangKey(value="config.nex:entity.ghast.meatDropRarity")
            @Config.Comment(value={"The lower the number, the more common it is for Ghast Meat to drop", "The higher the number, the rarer it is for Ghast Meat to drop", "If set to 0, Ghast Meat does not drop"})
            @Config.RangeInt(min=0)
            public int meatDropRarity = 1;
        }

        public class Brute {
            @Config.LangKey(value="config.nex:entity.brute.chargeCooldown")
            @Config.Comment(value={"The lower the number, the less cooldown the Brute has after charging", "The higher the number, the more cooldown the Brute has after charging"})
            @Config.RangeInt(min=1)
            public int chargeCooldown = 2;
        }

        public class Spore {
            @Config.LangKey(value="config.nex:entity.spore.growthTime")
            @Config.Comment(value={"The lower the number, the less it takes a Spore to grow", "The higher the number, the more time it takes for a Spore to grow"})
            @Config.RangeInt(min=1)
            public int growthTime = 60;
            @Config.LangKey(value="config.nex:entity.spore.creeperSpawnAmount")
            @Config.Comment(value={"The lower the number, the less Spore Creepers spawn from a Spore", "The higher the number, the more Spore Creepers spawn from a Spore"})
            @Config.RangeInt(min=1)
            public int creeperSpawnAmount = 3;
        }

        public class SporeCreeper {
            @Config.LangKey(value="config.nex:entity.sporeCreeper.sporeSpawnRarity")
            @Config.Comment(value={"The higher the number, the rarer it is for a Spore Creeper to spawn a Spore on death", "The lower the number, the more common it is for a Spore Creeper to spawn a Spore on death"})
            @Config.RangeInt(min=1)
            public int sporeSpawnRarity = 12;
        }

        public class Spinout {
            @Config.LangKey(value="config.nex:entity.spinout.spinTime")
            @Config.Comment(value={"The lower the number, the less time a Spinout spins", "The higher the number, the more time a Spinout spins"})
            @Config.RangeInt(min=1)
            public int spinTime = 6;
            @Config.LangKey(value="config.nex:entity.spinout.spinCooldown")
            @Config.Comment(value={"The lower the number, the less time a Spinout goes without spinning", "The higher the number, the more time a Spinout goes without spinning"})
            @Config.RangeInt(min=1)
            public int spinCooldown = 2;
        }

        public class Nethermite {
            @Config.LangKey(value="config.nex:entity.nethermite.spawnRarity")
            @Config.Comment(value={"The higher the number, the rarer it is for a Nethermite to spawn", "The lower the number, the more common it is for a Nethermite to spawn", "If set to 0, Nethermites won't spawn"})
            @Config.RangeInt(min=0)
            public int spawnRarity = 64;
            @Config.LangKey(value="config.nex:entity.nethermite.blockWhitelist")
            @Config.Comment(value={"Blocks the Nethermite will spawn from"})
            public String[] blockWhitelist = new String[]{"minecraft:quartz_ore", "nex:ore_quartz", "nex:ore_amethyst", "nex:ore_rime", "tconstruct:ore", "nethermetals:nether_coal_ore", "nethermetals:nether_redstone_ore", "nethermetals:nether_diamond_ore", "nethermetals:nether_emerald_ore", "nethermetals:nether_gold_ore", "nethermetals:nether_iron_ore", "nethermetals:nether_lapis_ore", "nethermetals:nether_antimony_ore", "nethermetals:nether_bismuth_ore", "nethermetals:nether_copper_ore", "nethermetals:nether_lead_ore", "nethermetals:nether_mercury_ore", "nethermetals:nether_nickel_ore", "nethermetals:nether_platnium_ore", "nethermetals:nether_silver_ore", "nethermetals:nether_tin_ore", "nethermetals:nether_zinc_ore", "nethermetals:nether_aluminum_ore", "nethermetals:nether_cadmium_ore", "nethermetals:nether_chromium_ore", "nethermetals:nether_iridium_ore", "nethermetals:nether_magnesium_ore", "nethermetals:nether_magnanese_ore", "nethermetals:nether_osmium_ore", "nethermetals:nether_plutonium_ore", "nethermetals:nether_rutile_ore", "nethermetals:nether_tantalum_ore", "nethermetals:nether_titanium_ore", "nethermetals:nether_tungsten_ore", "nethermetals:nether_uramium_ore", "nethermetals:nether_zirconium_ore"};
        }

        public class Ember {
            @Config.LangKey(value="config.nex:entity.ember.setPlayerOnFireRarity")
            @Config.Comment(value={"The higher the number, the rarer it is to set a player on fire", "The lower the number, the more common it is to set a player on fire", "If set to 0, Embers won't set Players on fire"})
            @Config.RangeInt(min=0)
            public int setPlayerOnFireRarity = 2;
        }
    }

    public static class PotionEffectConfig {
        @Config.Name(value="freeze")
        @Config.LangKey(value="config.nex:potionEffect.freeze")
        public Freeze freeze = new Freeze();
        @Config.Name(value="spore")
        @Config.LangKey(value="config.nex:potionEffect.spore")
        public Spore spore = new Spore();
        @Config.Name(value="lost")
        @Config.LangKey(value="config.nex:potionEffect.lost")
        public Lost lost = new Lost();

        public class Lost {
            @Config.LangKey(value="config.nex:potionEffect.lost.ghastlingSpawnRarity")
            @Config.Comment(value={"The higher the number, the rarer it is to spawn a Ghastling", "The lower the number, the more common it is to spawn a Ghastling"})
            @Config.RangeInt(min=1)
            public int ghastlingSpawnRarity = 256;
        }

        public class Spore {
            @Config.LangKey(value="config.nex:potionEffect.spore.sporeSpawnRarity")
            @Config.Comment(value={"The higher the number, the rarer it is to spawn a Spore", "The lower the number, the more common it is to spawn a Spore"})
            @Config.RangeInt(min=1)
            public int sporeSpawnRarity = 128;
            @Config.LangKey(value="config.nex:potionEffect.spore.mobBlacklist")
            @Config.Comment(value={"Mobs that shouldn't spawn Spores"})
            public String[] mobBlacklist = new String[]{"nex:spore_creeper", "nex:spore", "nex:mogus"};
        }

        public class Freeze {
            @Config.LangKey(value="config.nex:potionEffect.freeze.thawRarity")
            @Config.Comment(value={"The higher the number, the rarer it is to thaw", "The lower the number, the more common it is to thaw"})
            @Config.RangeInt(min=1)
            public int thawRarity = 1024;
            @Config.LangKey(value="config.nex:potionEffect.freeze.mobBlacklist")
            @Config.Comment(value={"Mobs that won't freeze"})
            public String[] mobBlacklist = new String[]{"minecraft:blaze", "minecraft:ghast", "minecraft:wither_skeleton", "minecraft:polar_bear", "nex:wight", "nex:ember", "nex:spinout", "nex:bone_spider", "nex:brute"};
        }
    }

    public static class BlockConfig {
        @Config.Name(value="nether_portal")
        @Config.LangKey(value="config.nex:block.netherPortal")
        public NetherPortal netherPortal = new NetherPortal();
        @Config.Name(value="netherrack")
        @Config.LangKey(value="config.nex:block.netherrack")
        public Netherrack netherrack = new Netherrack();
        @Config.Name(value="soul_sand")
        @Config.LangKey(value="config.nex:block.soulSand")
        public SoulSand soulSand = new SoulSand();
        @Config.Name(value="nether_wart")
        @Config.LangKey(value="config.nex:block.netherWart")
        public NetherWart netherWart = new NetherWart();
        @Config.Name(value="magma")
        @Config.LangKey(value="config.nex:block.magma")
        public Magma magma = new Magma();
        @Config.Name(value="rime")
        @Config.LangKey(value="config.nex:block.rime")
        public Rime rime = new Rime();
        @Config.Name(value="thornstalk")
        @Config.LangKey(value="config.nex:block.thornstalk")
        public Thornstalk thornstalk = new Thornstalk();
        @Config.Name(value="hyphae")
        @Config.LangKey(value="config.nex:block.hyphae")
        public Hyphae hyphae = new Hyphae();

        public class Hyphae {
            @Config.LangKey(value="config.nex:block.hyphae.shouldSpread")
            public boolean shouldSpread = false;
        }

        public class Thornstalk {
            @Config.LangKey(value="config.nex:block.thornstalk.canDestroyItems")
            public boolean canDestroyItems = false;
            @Config.LangKey(value="config.nex:block.thornstalk.mobBlacklist")
            @Config.Comment(value={"Mobs Thornstalk won't hurt"})
            public String[] mobBlacklist = new String[]{"minecraft:wither_skeleton", "minecraft:zombie_pigman", "nex:spinout"};
        }

        public class Rime {
            @Config.LangKey(value="config.nex:block.rime.canFreezeWater")
            public boolean canFreezeWater = true;
            @Config.LangKey(value="config.nex:block.rime.canFreezeLava")
            public boolean canFreezeLava = true;
            @Config.LangKey(value="config.nex:block.rime.canFreezeMobs")
            public boolean canFreezeMobs = true;
        }

        public class Magma {
            @Config.LangKey(value="config.nex:block.magma.turnIntoLavaWhenBroken")
            public boolean turnIntoLavaWhenBroken = false;
        }

        public class NetherWart {
            @Config.LangKey(value="config.nex:block.netherWart.growLikeCrops")
            public boolean growLikeCrops = true;
            @Config.RequiresMcRestart
            @Config.RangeInt(min=0)
            @Config.Comment(value={"The higher the number, the slower Nether Wart grows", "The lower the number, the faster Nether Wart grows", "If set to 0, Nether Wart growth will default to Vanilla speed"})
            @Config.LangKey(value="config.nex:block.netherWart.growthTickSpeed")
            public int growthTickSpeed = 0;
        }

        public class SoulSand {
            @Config.LangKey(value="config.nex:block.soulSand.allowAllHoesToTill")
            public boolean allowAllHoesToTill = false;
            @Config.LangKey(value="config.nex:block.soulSand.useLavaInsteadOfIchorToMoisten")
            public boolean useLavaInsteadOfIchorToMoisten = false;
        }

        public class Netherrack {
            @Config.LangKey(value="config.nex:block.netherrack.allowAllShovelsToFlatten")
            public boolean allowAllShovelsToFlatten = false;
        }

        public class NetherPortal {
            @Config.RangeInt(min=0)
            @Config.LangKey(value="config.nex:block.netherPortal.pigmanSpawnRarity")
            @Config.Comment(value={"The higher the number, the rarer it is for Pigman to spawn", "The lower the number, the more common it is for Pigman to spawn", "If set to 0, Pigman won't spawn"})
            public int pigmanSpawnRarity = 2000;
        }
    }

    public static class DimensionConfig {
        @Config.Name(value="nether")
        @Config.LangKey(value="config.nex:dimension.nether")
        public Nether nether = new Nether();

        public class Nether {
            @Config.RequiresMcRestart
            @Config.LangKey(value="config.nex:dimension.nether.overrideNether")
            public boolean overrideNether = true;
            @Config.LangKey(value="config.nex:dimension.nether.generateSoulSand")
            public boolean generateSoulSand = false;
            @Config.LangKey(value="config.nex:dimension.nether.generateGravel")
            public boolean generateGravel = false;
            @Config.LangKey(value="config.nex:dimension.nether.isLavaInfinite")
            public boolean isLavaInfinite = false;
        }
    }

    public static class CompatibilityConfig {
        @Config.Name(value="biomesoplenty")
        @Config.LangKey(value="config.nex:compatibility.biomesOPlenty")
        public BiomesOPlenty biomesOPlenty = new BiomesOPlenty();

        public class BiomesOPlenty {
            @Config.LangKey(value="config.nex:compatibility.biomesOPlenty.enableCompat")
            public boolean enableCompat = true;
        }
    }

    public static class ClientConfig {
        @Config.Name(value="visual")
        @Config.LangKey(value="config.nex:client.visual")
        public Visual visual = new Visual();

        public class Visual {
            @Config.LangKey(value="config.nex:client.visual.disableNetherFog")
            public boolean disableNetherFog = true;
        }
    }
}

