/*
 * Decompiled with CFR 0.152.
 */
package nex.entity.monster;

import java.util.Collection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nex.entity.ai.EntityAISporeCreeperSwell;
import nex.init.NetherExItems;
import nex.init.NetherExLootTables;
import nex.init.NetherExSoundEvents;
import nex.world.ExplosionSpore;

public class EntitySporeCreeper
extends EntityMob {
    private static final DataParameter<Integer> STATE = EntityDataManager.func_187226_a(EntitySporeCreeper.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> IGNITED = EntityDataManager.func_187226_a(EntitySporeCreeper.class, (DataSerializer)DataSerializers.field_187198_h);
    private int lastIgnitionTime;
    private int timeSinceIgnited;
    private int fuseTime = 30;
    private int explosionRadius = 2;

    public EntitySporeCreeper(World world) {
        super(world);
        this.field_70178_ae = true;
        this.func_70105_a(0.6f, 1.7f);
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return NetherExSoundEvents.SPORE_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return NetherExSoundEvents.SPORE_DEATH;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISporeCreeperSwell(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPigZombie.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    public int func_82143_as() {
        return this.func_70638_az() == null ? 3 : 3 + (int)(this.func_110143_aJ() - 1.0f);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        super.func_180430_e(distance, damageMultiplier);
        this.timeSinceIgnited = (int)((float)this.timeSinceIgnited + distance * 1.5f);
        if (this.timeSinceIgnited > this.fuseTime - 5) {
            this.timeSinceIgnited = this.fuseTime - 5;
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STATE, (Object)-1);
        this.field_70180_af.func_187214_a(IGNITED, (Object)false);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74777_a("Fuse", (short)this.fuseTime);
        compound.func_74774_a("ExplosionRadius", (byte)this.explosionRadius);
        compound.func_74757_a("ignited", this.hasIgnited());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("Fuse", 99)) {
            this.fuseTime = compound.func_74765_d("Fuse");
        }
        if (compound.func_150297_b("ExplosionRadius", 99)) {
            this.explosionRadius = compound.func_74771_c("ExplosionRadius");
        }
        if (compound.func_74767_n("ignited")) {
            this.ignite();
        }
    }

    public void func_70071_h_() {
        if (this.func_70089_S()) {
            int i;
            this.lastIgnitionTime = this.timeSinceIgnited;
            if (this.hasIgnited()) {
                this.setCreeperState(1);
            }
            if ((i = this.getCreeperState()) > 0 && this.timeSinceIgnited == 0) {
                this.func_184185_a(NetherExSoundEvents.SPORE_WARN, 1.0f, 0.5f);
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= this.fuseTime) {
                this.timeSinceIgnited = this.fuseTime;
                this.explode();
            }
        }
        super.func_70071_h_();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76346_g() != null && source.func_76346_g() instanceof EntityLivingBase && ((EntityLivingBase)source.func_76346_g()).func_184614_ca().func_77973_b() == NetherExItems.GOLDEN_WITHER_BONE_SWORD) {
            amount *= 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entityIn) {
        return true;
    }

    protected ResourceLocation func_184647_J() {
        return NetherExLootTables.SPORE_CREEPER;
    }

    @SideOnly(value=Side.CLIENT)
    public float getFlashIntensity(float partialTicks) {
        return ((float)this.lastIgnitionTime + (float)(this.timeSinceIgnited - this.lastIgnitionTime) * partialTicks) / (float)(this.fuseTime - 2);
    }

    public int getCreeperState() {
        return (Integer)this.field_70180_af.func_187225_a(STATE);
    }

    public void setCreeperState(int state) {
        this.field_70180_af.func_187227_b(STATE, (Object)state);
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == Items.field_151033_d) {
            this.field_70170_p.func_184148_a(player, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187649_bu, this.func_184176_by(), 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
            player.func_184609_a(hand);
            if (!this.field_70170_p.field_72995_K) {
                this.ignite();
                stack.func_77972_a(1, (EntityLivingBase)player);
                return true;
            }
        }
        return super.func_184645_a(player, hand);
    }

    private void explode() {
        this.field_70729_aU = true;
        ExplosionSpore explosion = new ExplosionSpore(this.field_70170_p, (Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.explosionRadius, true, this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
        explosion.func_77278_a();
        explosion.func_77279_a(true);
        this.func_70106_y();
        this.spawnLingeringCloud();
    }

    private void spawnLingeringCloud() {
        Collection effects = this.func_70651_bq();
        if (!effects.isEmpty()) {
            EntityAreaEffectCloud cloud = new EntityAreaEffectCloud(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
            cloud.func_184483_a(2.5f);
            cloud.func_184495_b(-0.5f);
            cloud.func_184485_d(10);
            cloud.func_184486_b(cloud.func_184489_o() / 2);
            cloud.func_184487_c(-cloud.func_184490_j() / (float)cloud.func_184489_o());
            for (PotionEffect effect : effects) {
                cloud.func_184496_a(new PotionEffect(effect));
            }
            this.field_70170_p.func_72838_d((Entity)cloud);
        }
    }

    private boolean hasIgnited() {
        return (Boolean)this.field_70180_af.func_187225_a(IGNITED);
    }

    private void ignite() {
        this.field_70180_af.func_187227_b(IGNITED, (Object)true);
    }
}

