/*
 * Decompiled with CFR 0.152.
 */
package nex.entity.monster;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityJumpHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nex.handler.ConfigHandler;
import nex.init.NetherExLootTables;
import nex.init.NetherExSoundEvents;

public class EntityEmber
extends EntityMob {
    private int jumpCounter;
    private int jumpDuration;
    private int moveDuration;
    private boolean wasOnGround;

    public EntityEmber(World world) {
        super(world);
        this.field_70178_ae = true;
        this.field_70767_i = new JumpHelper(this);
        this.field_70765_h = new MoveHelper(this);
        this.func_70105_a(0.35f, 0.65f);
        this.setMovementSpeed(0.0);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.LAVA, 1.0f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 1.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return NetherExSoundEvents.EMBER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return NetherExSoundEvents.EMBER_DEATH;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.45f));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, false));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.35);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.5);
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
        if (this.jumpCounter != this.jumpDuration) {
            ++this.jumpCounter;
        } else if (this.jumpDuration != 0) {
            this.jumpCounter = 0;
            this.jumpDuration = 0;
            this.func_70637_d(false);
        }
    }

    public void func_70619_bc() {
        if (this.func_70026_G()) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        if (this.moveDuration > 0) {
            --this.moveDuration;
        }
        if (this.field_70122_E) {
            JumpHelper helper;
            if (!this.wasOnGround) {
                this.func_70637_d(false);
                this.checkLandingDelay();
            }
            if (!(helper = (JumpHelper)this.field_70767_i).getIsJumping()) {
                if (this.field_70765_h.func_75640_a() && this.moveDuration == 0) {
                    Path path = this.field_70699_by.func_75505_d();
                    Vec3d movePos = new Vec3d(this.field_70765_h.func_179917_d(), this.field_70765_h.func_179919_e(), this.field_70765_h.func_179918_f());
                    if (path != null && path.func_75873_e() < path.func_75874_d()) {
                        movePos = path.func_75878_a((Entity)this);
                    }
                    this.calculateRotationYaw(movePos.field_72450_a, movePos.field_72449_c);
                    this.startJumping();
                }
            } else if (!helper.canJump()) {
                this.enableJumpControl();
            }
        }
        this.wasOnGround = this.field_70122_E;
    }

    public boolean func_70652_k(Entity entity) {
        if (ConfigHandler.entityConfig.ember.setPlayerOnFireRarity > 0 && this.field_70146_Z.nextInt(ConfigHandler.entityConfig.ember.setPlayerOnFireRarity) == 0) {
            entity.func_70015_d(4);
        }
        return super.func_70652_k(entity);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected float func_175134_bD() {
        if (!(this.field_70123_F || this.field_70765_h.func_75640_a() && !(this.field_70765_h.func_179919_e() <= this.field_70163_u + 0.5))) {
            Path path = this.field_70699_by.func_75505_d();
            if (path != null && path.func_75873_e() < path.func_75874_d()) {
                Vec3d pos = path.func_75878_a((Entity)this);
                if (pos.field_72448_b > this.field_70163_u + 0.5) {
                    return 0.5f;
                }
            }
            return this.field_70765_h.func_75638_b() <= 0.6 ? 0.2f : 0.3f;
        }
        return 0.5f;
    }

    protected void func_70664_aZ() {
        double motionSq;
        super.func_70664_aZ();
        double speed = this.field_70765_h.func_75638_b();
        if (speed > 0.0 && (motionSq = this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y) < 0.010000000000000002) {
            this.func_191958_b(0.0f, 0.0f, 1.0f, 0.1f);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)1);
        }
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    public boolean func_70058_J() {
        return this.field_70170_p.func_72917_a(this.func_174813_aQ(), (Entity)this) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty();
    }

    protected ResourceLocation func_184647_J() {
        return NetherExLootTables.EMBER;
    }

    public void setMovementSpeed(double newSpeed) {
        this.func_70661_as().func_75489_a(newSpeed);
        this.field_70765_h.func_75642_a(this.field_70765_h.func_179917_d(), this.field_70765_h.func_179919_e(), this.field_70765_h.func_179918_f(), newSpeed);
    }

    private void startJumping() {
        this.func_70637_d(true);
        this.jumpDuration = 10;
        this.jumpCounter = 0;
    }

    private void calculateRotationYaw(double x, double z) {
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)(z - this.field_70161_v), (double)(x - this.field_70165_t)) * 57.29577951308232) - 90.0f;
    }

    private void enableJumpControl() {
        ((JumpHelper)this.field_70767_i).setCanJump(true);
    }

    private void disableJumpControl() {
        ((JumpHelper)this.field_70767_i).setCanJump(false);
    }

    private void updateMoveTypeDuration() {
        this.moveDuration = this.field_70765_h.func_75638_b() < 2.2 ? 10 : 1;
    }

    private void checkLandingDelay() {
        this.updateMoveTypeDuration();
        this.disableJumpControl();
    }

    static class MoveHelper
    extends EntityMoveHelper {
        private final EntityEmber ember;
        private double jumpSpeed;

        public MoveHelper(EntityEmber ember) {
            super((EntityLiving)ember);
            this.ember = ember;
        }

        public void func_75641_c() {
            if (this.ember.field_70122_E && !this.ember.field_70703_bu && !((JumpHelper)this.ember.field_70767_i).getIsJumping()) {
                this.ember.setMovementSpeed(0.0);
            } else if (this.func_75640_a()) {
                this.ember.setMovementSpeed(this.jumpSpeed);
            }
            super.func_75641_c();
        }

        public void func_75642_a(double x, double y, double z, double speedIn) {
            if (this.ember.func_70090_H()) {
                speedIn = 1.5;
            }
            super.func_75642_a(x, y, z, speedIn);
            if (speedIn > 0.0) {
                this.jumpSpeed = speedIn;
            }
        }
    }

    public class JumpHelper
    extends EntityJumpHelper {
        private final EntityEmber ember;
        private boolean canJump;

        public JumpHelper(EntityEmber ember) {
            super((EntityLiving)ember);
            this.ember = ember;
        }

        public boolean getIsJumping() {
            return this.field_75662_b;
        }

        public boolean canJump() {
            return this.canJump;
        }

        public void setCanJump(boolean canJumpIn) {
            this.canJump = canJumpIn;
        }

        public void func_75661_b() {
            if (this.field_75662_b) {
                this.ember.startJumping();
                this.field_75662_b = false;
            }
        }
    }
}

