/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.utils;

import com.google.common.collect.BiMap;
import com.google.common.collect.Multimap;
import com.zeitheron.hammercore.utils.FinalFieldHelper;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IntIdentityHashBiMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraft.util.registry.RegistrySimple;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ForgeRegistryUtils {
    public static final Logger LOGGER = LogManager.getLogger();

    public static <V extends IForgeRegistryEntry<V>> V deleteEntry(IForgeRegistry<V> registry, ResourceLocation path) {
        if (!ForgeRegistry.class.isAssignableFrom(registry.getClass())) {
            return null;
        }
        try {
            BiMap ids = null;
            BiMap names = null;
            Multimap overrides = null;
            BiMap ownersReverse = null;
            Map aliases = null;
            Map slaves = null;
            Field f = ForgeRegistry.class.getDeclaredField("ids");
            f.setAccessible(true);
            ids = (BiMap)f.get(registry);
            f = ForgeRegistry.class.getDeclaredField("aliases");
            f.setAccessible(true);
            aliases = (Map)f.get(registry);
            f = ForgeRegistry.class.getDeclaredField("names");
            f.setAccessible(true);
            names = (BiMap)f.get(registry);
            f = ForgeRegistry.class.getDeclaredField("overrides");
            f.setAccessible(true);
            overrides = (Multimap)f.get(registry);
            f = ForgeRegistry.class.getDeclaredField("owners");
            f.setAccessible(true);
            ownersReverse = ((BiMap)f.get(registry)).inverse();
            f = ForgeRegistry.class.getDeclaredField("slaves");
            f.setAccessible(true);
            slaves = (Map)f.get(registry);
            IForgeRegistryEntry prev = (IForgeRegistryEntry)names.remove((Object)path);
            ResourceLocation alias = (ResourceLocation)aliases.remove(path);
            Collection ovs = overrides.removeAll((Object)path);
            Object overrideOwner = ownersReverse.remove((Object)prev);
            int id = (Integer)ids.inverse().remove((Object)prev);
            LOGGER.info("Removed entry \"" + path + "\" from registry of " + registry.getRegistrySuperType().getName() + ". Info: Alias - \"" + alias + "\"; Overrides removed: " + ovs.size() + "; ID: " + id + "; OverrideOwner: " + overrideOwner + "; Registry Slaves: " + slaves.keySet());
            if (prev instanceof Block) {
                GameData.getBlockItemMap().remove((Object)prev);
                LOGGER.info("Removed Block-to-Item mapping for Block " + prev.getRegistryName());
            } else if (prev instanceof Item) {
                GameData.getBlockItemMap().inverse().remove((Object)prev);
                LOGGER.info("Removed Block-to-Item mapping for Block " + prev.getRegistryName());
            }
            return (V)prev;
        }
        catch (Throwable err) {
            err.printStackTrace();
            return null;
        }
    }

    public static RegistryNamespaced<ResourceLocation, Class<? extends TileEntity>> getTileEntityRegistry() {
        RegistryNamespaced registry = null;
        Field f = TileEntity.class.getDeclaredFields()[1];
        f.setAccessible(true);
        try {
            registry = (RegistryNamespaced)f.get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        return registry;
    }

    public static void overrideTileEntity(String id, Class<? extends TileEntity> type) {
        RegistryNamespaced<ResourceLocation, Class<? extends TileEntity>> registry = ForgeRegistryUtils.getTileEntityRegistry();
        ForgeRegistryUtils.removeKey(registry, new ResourceLocation(id));
        registry.func_82595_a((Object)new ResourceLocation(id), type);
    }

    public static <K, V> V removeKey(RegistryNamespaced<K, V> registry, K key) {
        Object val = registry.func_82594_a(key);
        IntIdentityHashBiMap ids = null;
        Map inverseObjectRegistry = null;
        Map registryObjects = null;
        try {
            Field f = RegistryNamespaced.class.getDeclaredFields()[0];
            f.setAccessible(true);
            IntIdentityHashBiMap idsf = ids = (IntIdentityHashBiMap)f.get(registry);
            IntIdentityHashBiMap ids2 = new IntIdentityHashBiMap(256);
            ids.forEach(va -> {
                if (va != val) {
                    ids2.func_186814_a(va, idsf.func_186815_a(va));
                }
            });
            FinalFieldHelper.setFinalField(f, registry, ids2);
            f = RegistryNamespaced.class.getDeclaredFields()[1];
            f.setAccessible(true);
            inverseObjectRegistry = (Map)f.get(registry);
            inverseObjectRegistry.remove(val);
            f = RegistrySimple.class.getDeclaredFields()[1];
            f.setAccessible(true);
            registryObjects = (Map)f.get(registry);
            registryObjects.remove(key);
            f = RegistrySimple.class.getDeclaredFields()[2];
            f.setAccessible(true);
            f.set(registry, null);
            LOGGER.warn("WARNING: Removed \"" + val + "\" from registry \"" + registry + "\"");
            return (V)val;
        }
        catch (Throwable err) {
            err.printStackTrace();
            return null;
        }
    }
}

