/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.utils;

public class DynamicObject<OBJ> {
    private OBJ obj;

    public DynamicObject(Class<OBJ> type) {
        this.reset(type);
    }

    public DynamicObject(OBJ obj) {
        if (obj != null) {
            this.reset(obj.getClass());
        }
        this.obj = obj;
    }

    private void reset(Class<? extends OBJ> type) {
        this.obj = null;
        if (String.class.isAssignableFrom(type)) {
            this.obj = "";
        }
        if (Byte.class.isAssignableFrom(type)) {
            this.obj = (byte)0;
        }
        if (Short.class.isAssignableFrom(type)) {
            this.obj = (short)0;
        }
        if (Integer.class.isAssignableFrom(type)) {
            this.obj = 0;
        }
        if (Long.class.isAssignableFrom(type)) {
            this.obj = 0L;
        }
        if (Float.class.isAssignableFrom(type)) {
            this.obj = Float.valueOf(0.0f);
        }
        if (Double.class.isAssignableFrom(type)) {
            this.obj = 0.0;
        }
        if (Boolean.class.isAssignableFrom(type)) {
            this.obj = false;
        }
    }

    public OBJ get() {
        return this.obj;
    }

    public void set(OBJ obj) {
        this.obj = obj;
    }
}

