/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.internal.variables;

import com.zeitheron.hammercore.internal.variables.IVariable;
import com.zeitheron.hammercore.net.HCNet;
import com.zeitheron.hammercore.net.internal.PacketUpdateDirtyVariables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;

public class VariableManager {
    static final List<IVariable> VARIABLES = new ArrayList<IVariable>();

    private VariableManager() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static <T> IVariable<T> getVariable(String id) {
        for (int i = 0; i < VARIABLES.size(); ++i) {
            if (!VARIABLES.get(i).getId().equals(id)) continue;
            return VARIABLES.get(i);
        }
        return null;
    }

    public static void registerVariable(IVariable var) {
        if (VARIABLES.contains(var) || VariableManager.getVariable(var.getId()) != null) {
            return;
        }
        VARIABLES.add(var);
    }

    static void updateManager() {
        HashMap<String, IVariable> dirty = null;
        for (int i = 0; i < VARIABLES.size(); ++i) {
            IVariable var = VARIABLES.get(i);
            if (!var.hasChanged()) continue;
            if (dirty == null) {
                dirty = new HashMap<String, IVariable>();
            }
            dirty.put(var.getId(), var);
            var.setNotChanged();
        }
        if (dirty != null) {
            HCNet.INSTANCE.sendToAll(new PacketUpdateDirtyVariables(dirty));
        }
    }

    public static void sendVarsTo(EntityPlayerMP mp) {
        HashMap<String, IVariable> dirty = null;
        for (int i = 0; i < VARIABLES.size(); ++i) {
            IVariable var = VARIABLES.get(i);
            if (dirty == null) {
                dirty = new HashMap<String, IVariable>();
            }
            dirty.put(var.getId(), var);
            var.setNotChanged();
        }
        if (dirty != null) {
            HCNet.INSTANCE.sendTo(new PacketUpdateDirtyVariables(dirty), mp);
        }
    }
}

