/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.danknull.init;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import p455w0rd.danknull.init.ModLogger;
import p455w0rd.danknull.util.NonNullListSerializable;

public class ModConfig {
    public static Configuration CONFIG;
    public static final String CLIENT_CAT = "General";
    public static final String SERVER_CAT = "Server Rules";
    public static final boolean DEBUG_RESET = false;
    public static final String CONST_CREATIVE_BLACKLIST = "CreativeBlacklist";
    public static final String CONST_CREATIVE_WHITELIST = "CreativeWhitelist";
    public static final String CONST_OREDICT_BLACKLIST = "OreDictBlacklist";
    public static final String CONST_OREDICT_WHITELIST = "OreDictWhitelist";
    public static final String CONST_DISABLE_OREDICT = "DisableOreDictMode";

    public static void init() {
        if (CONFIG == null) {
            File configFile = new File("config/DankNull.cfg");
            CONFIG = new Configuration(configFile);
            CONFIG.load();
        }
        Options.callItDevNull = CONFIG.getBoolean("CallItDevNull", CLIENT_CAT, false, "Call it a /dev/null in-game ");
        Options.superShine = CONFIG.getBoolean("SuperShine", CLIENT_CAT, false, "Make items ultra shiny!");
        Options.creativeBlacklist = CONFIG.getString(CONST_CREATIVE_BLACKLIST, SERVER_CAT, "", "A semicolon separated list of items that are not allowed to be placed into the creative /dank/null\nFormat: modid:name:meta (meta optional: modid:name is acceptable) - Example: minecraft:diamond;minecraft:coal:1").trim();
        Options.creativeWhitelist = CONFIG.getString(CONST_CREATIVE_WHITELIST, SERVER_CAT, "", "A semicolon separated list of items that are allowed to be placed into the creative /dank/null\nSame format as Blacklist and whitelist superceeds blacklist.\nIf whitelist is non-empty, then ONLY whitelisted items can be added to the Creative /dank/null").trim();
        Options.oreBlacklist = CONFIG.getString(CONST_OREDICT_BLACKLIST, SERVER_CAT, "", "A semicolon separated list of Ore Dictionary entries (strings) which WILL NOT be allowed to be used with /dank/null's Ore Dictionary functionality.");
        Options.oreWhitelist = CONFIG.getString(CONST_OREDICT_WHITELIST, SERVER_CAT, "", "A semicolon separated list of Ore Dictionary entries (strings) which WILL BE allowed to be used with /dank/null's Ore Dictionary functionality. Whitelist superceeds blacklist.\nIf whitelist is non-empty, then ONLY Ore Dictionary items matching the entries will\nbe able to take advantage of /dank/null's Ore Dictionary functionality.");
        Options.disableOreDictMode = CONFIG.getBoolean(CONST_DISABLE_OREDICT, SERVER_CAT, false, "If set to true, then Ore Dictionary Mode will not be available (overrides Ore Dictionary White/Black lists)");
        if (CONFIG.hasChanged()) {
            CONFIG.save();
        }
    }

    public static class Options {
        public static boolean callItDevNull = false;
        public static boolean superShine = false;
        public static String creativeBlacklist = "";
        public static String creativeWhitelist = "";
        public static String oreBlacklist = "";
        public static String oreWhitelist = "";
        private static NonNullListSerializable<ItemStack> creativeItemBlacklist = null;
        private static NonNullListSerializable<ItemStack> creativeItemWhitelist = null;
        private static ArrayList<String> oreStringBlacklist = Lists.newArrayList();
        private static ArrayList<String> oreStringWhitelist = Lists.newArrayList();
        public static Boolean disableOreDictMode = false;

        public static List<String> getOreBlacklist() {
            String[] tmpList = null;
            if (oreStringBlacklist.isEmpty() && !oreBlacklist.isEmpty() && Options.getOreWhitelist().size() == 0) {
                tmpList = oreBlacklist.split(";");
            }
            if (tmpList != null) {
                for (String string : tmpList) {
                    if (!OreDictionary.doesOreNameExist((String)string)) continue;
                    oreStringBlacklist.add(string);
                }
            }
            return oreStringBlacklist;
        }

        public static List<String> getOreWhitelist() {
            String[] tmpList = null;
            if (oreStringWhitelist.isEmpty() && !oreWhitelist.isEmpty()) {
                tmpList = oreWhitelist.split(";");
            }
            if (tmpList != null) {
                for (String string : tmpList) {
                    if (!OreDictionary.doesOreNameExist((String)string)) continue;
                    oreStringWhitelist.add(string);
                }
            }
            return oreStringWhitelist;
        }

        public static NonNullListSerializable<ItemStack> getCreativeBlacklistedItems() throws Exception {
            if (creativeItemBlacklist == null && Options.getCreativeWhitelistedItems().isEmpty()) {
                creativeItemBlacklist = (NonNullListSerializable)NonNullListSerializable.func_191196_a();
                if (!creativeBlacklist.isEmpty()) {
                    ArrayList itemStringList = Lists.newArrayList((Object[])creativeBlacklist.split(";"));
                    for (String itemString : itemStringList) {
                        Item item;
                        String[] params = itemString.split(":");
                        int numColons = params.length - 1;
                        if (numColons > 2 || numColons <= 0) {
                            throw new Exception(new Throwable("Invalid format for item blacklisting, check config/DankNull.cfg for an example"));
                        }
                        if (numColons == 1) {
                            item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(params[0], params[1]));
                            if (item == null) {
                                ModLogger.warn("Item \"" + params[0] + ":" + params[1] + "\" not found");
                                continue;
                            }
                            creativeItemBlacklist.add(new ItemStack(item));
                            continue;
                        }
                        if (numColons != 2) continue;
                        item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(params[0], params[1]));
                        if (item == null) {
                            ModLogger.warn("Item \"" + params[0] + ":" + params[1] + "\" not found");
                            continue;
                        }
                        int meta = -1;
                        try {
                            meta = Integer.parseInt(params[2]);
                        }
                        catch (NumberFormatException e) {
                            meta = -1;
                        }
                        if (meta < 0) {
                            ModLogger.warn("Invalid metadata for item \"" + params[0] + ":" + params[1] + "\" (" + params[2] + ")");
                            continue;
                        }
                        creativeItemWhitelist.add(new ItemStack(item, 1, meta));
                    }
                }
            }
            return creativeItemBlacklist;
        }

        public static NonNullListSerializable<ItemStack> getCreativeWhitelistedItems() throws Exception {
            if (creativeItemWhitelist == null) {
                creativeItemWhitelist = (NonNullListSerializable)NonNullListSerializable.func_191196_a();
                if (!creativeWhitelist.isEmpty()) {
                    ArrayList itemStringList = Lists.newArrayList((Object[])creativeWhitelist.split(";"));
                    for (String itemString : itemStringList) {
                        Item item;
                        String[] params = itemString.split(":");
                        int numColons = params.length - 1;
                        if (numColons > 2 || numColons <= 0) {
                            throw new Exception(new Throwable("Invalid format for item whitelisting, check config/DankNull.cfg for an example"));
                        }
                        if (numColons == 1) {
                            item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(params[0], params[1]));
                            if (item == null) {
                                ModLogger.warn("Item \"" + params[0] + ":" + params[1] + "\" not found");
                                continue;
                            }
                            creativeItemWhitelist.add(new ItemStack(item));
                            continue;
                        }
                        if (numColons != 2) continue;
                        item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(params[0], params[1]));
                        if (item == null) {
                            ModLogger.warn("Item \"" + params[0] + ":" + params[1] + "\" not found");
                            continue;
                        }
                        int meta = -1;
                        try {
                            meta = Integer.parseInt(params[2]);
                        }
                        catch (NumberFormatException e) {
                            meta = -1;
                        }
                        if (meta < 0) {
                            ModLogger.warn("Invalid metadata for item \"" + params[0] + ":" + params[1] + "\" (" + params[2] + ")");
                            continue;
                        }
                        creativeItemWhitelist.add(new ItemStack(item, 1, meta));
                    }
                }
            }
            return creativeItemWhitelist;
        }
    }
}

