/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialai.config;

import com.google.common.base.Optional;
import fathertoast.specialai.config.Config;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class TargetBlock {
    public final Block BLOCK;
    private final List<State> MATCHERS = new ArrayList<State>();

    public static IBlockState parseStateForMatch(String targetState) {
        TargetBlock targetBlock = new TargetBlock(targetState);
        if (targetBlock.BLOCK != Blocks.field_150350_a) {
            if (targetBlock.MATCHERS.isEmpty()) {
                return targetBlock.BLOCK.func_176223_P();
            }
            return targetBlock.MATCHERS.get(0).asMatching(targetBlock.BLOCK.func_176223_P());
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public static TargetMap newTargetDefinition(String line) {
        String[] fragmentedStates = line.split(",");
        ArrayList<String> repairedStates = new ArrayList<String>();
        for (int i = 0; i < fragmentedStates.length; ++i) {
            String fragment = fragmentedStates[i].trim();
            if (!fragment.endsWith("]") && fragment.contains("[")) {
                boolean completed = false;
                StringBuilder rebuilder = new StringBuilder(fragment);
                ++i;
                while (i < fragmentedStates.length) {
                    String subfragment = fragmentedStates[i].trim();
                    rebuilder.append(",").append(subfragment);
                    if (subfragment.endsWith("]")) {
                        completed = true;
                        break;
                    }
                    ++i;
                }
                fragment = rebuilder.toString();
                if (!completed) {
                    Config.log.warn("Reached end of line while parsing block state '{}' from single-line target ({})", (Object)fragment, (Object)line);
                    continue;
                }
            }
            if (fragment.isEmpty()) continue;
            repairedStates.add(fragment);
        }
        return TargetBlock.newTargetDefinition(repairedStates.toArray(new String[0]));
    }

    public static TargetMap newTargetDefinition(String[] targetableBlockStates) {
        TargetMap targetDefinition = new TargetMap();
        for (String targetState : targetableBlockStates) {
            if (targetState.endsWith("*")) {
                TargetBlock.addAllModBlocks(targetDefinition, targetState.substring(0, targetState.length() - 1));
                continue;
            }
            TargetBlock targetBlock = new TargetBlock(targetState);
            if (targetBlock.BLOCK == Blocks.field_150350_a) continue;
            targetDefinition.mergeFrom(targetBlock);
        }
        return targetDefinition;
    }

    static Block getStringAsBlock(String id) {
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(id));
        if (block == Blocks.field_150350_a) {
            try {
                block = Block.func_149729_e((int)Integer.parseInt(id));
                if (block != Blocks.field_150350_a) {
                    Config.log.warn("Usage of numerical block id! ({})", (Object)id);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (block == Blocks.field_150350_a) {
            Config.log.error("Missing or invalid block! ({})", (Object)id);
        }
        return block;
    }

    private static void addAllModBlocks(TargetMap targetDefinition, String namespace) {
        try {
            for (ResourceLocation blockId : Block.field_149771_c.func_148742_b()) {
                if (!blockId.toString().startsWith(namespace)) continue;
                TargetBlock targetBlock = new TargetBlock((Block)Block.field_149771_c.func_82594_a((Object)blockId));
                if (targetBlock.BLOCK == null || targetBlock.BLOCK == Blocks.field_150350_a) continue;
                targetDefinition.mergeFrom(targetBlock);
            }
        }
        catch (Exception ex) {
            Config.log.error("Caught exception while adding namespace! ({}*)", (Object)namespace);
        }
    }

    public TargetBlock(Block block) {
        this.BLOCK = block;
    }

    public TargetBlock(IBlockState block) {
        this(block.func_177230_c());
        StateBuilder state = new StateBuilder();
        for (IProperty property : block.func_177227_a()) {
            state.add(property, block.func_177229_b(property));
        }
        if (!state.isEmpty()) {
            this.MATCHERS.add(state.toTargetState());
        }
    }

    public TargetBlock(String line) {
        String[] pair = line.split("\\[", 2);
        this.BLOCK = TargetBlock.getStringAsBlock(pair[0]);
        if (this.BLOCK == Blocks.field_150350_a || pair.length < 2) {
            return;
        }
        if (!pair[1].endsWith("]")) {
            Config.log.warn("Ignoring properties for broken target blockstate definition '{}' (no end bracket found)", (Object)line);
            return;
        }
        State state = State.parseState(pair[1].substring(0, pair[1].length() - 1), this.BLOCK);
        if (!state.PROPERTIES_TO_MATCH.isEmpty()) {
            this.MATCHERS.add(state);
        }
    }

    public String toString() {
        String registryName = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.BLOCK)).toString();
        if (this.MATCHERS.isEmpty()) {
            return registryName;
        }
        StringBuilder str = new StringBuilder();
        for (State state : this.MATCHERS) {
            str.append(registryName).append("[").append(state.toString()).append("],");
        }
        return str.substring(0, str.length() - 1);
    }

    public int hashCode() {
        return Block.func_149682_b((Block)this.BLOCK);
    }

    public boolean matches(IBlockState block) {
        if (this.MATCHERS.isEmpty()) {
            return true;
        }
        for (State state : this.MATCHERS) {
            if (!state.matches(block)) continue;
            return true;
        }
        return false;
    }

    void mergeFrom(TargetBlock other) {
        if (this.MATCHERS.isEmpty()) {
            Config.log.warn("Ignoring attempt to add redundant blockstate to config with blockstate wildcard '{}'", (Object)other);
        } else if (other.MATCHERS.isEmpty()) {
            Config.log.warn("Adding blockstate wildcard to config with redundant blockstate(s) '{}'", (Object)this);
            this.MATCHERS.clear();
        } else {
            this.MATCHERS.addAll(other.MATCHERS);
        }
    }

    public static final class TargetMap {
        private final Map<Block, TargetBlock> UNDERLYING_MAP = new HashMap<Block, TargetBlock>();

        public boolean isEmpty() {
            return this.UNDERLYING_MAP.isEmpty();
        }

        public boolean matches(IBlockState block) {
            TargetBlock target = this.UNDERLYING_MAP.get(block.func_177230_c());
            return target != null && target.matches(block);
        }

        public List<Block> getSortedBlocks() {
            ArrayList<Block> list = new ArrayList<Block>(this.UNDERLYING_MAP.keySet());
            list.sort(Comparator.comparing(IForgeRegistryEntry.Impl::getRegistryName));
            return list;
        }

        void mergeFrom(TargetBlock other) {
            TargetBlock current = this.UNDERLYING_MAP.get(other.BLOCK);
            if (current == null) {
                this.UNDERLYING_MAP.put(other.BLOCK, other);
            } else {
                current.mergeFrom(other);
            }
        }

        public String toString() {
            if (this.UNDERLYING_MAP.isEmpty()) {
                return "";
            }
            StringBuilder str = new StringBuilder();
            for (TargetBlock target : this.UNDERLYING_MAP.values()) {
                str.append(target.toString()).append(",");
            }
            return str.substring(0, str.length() - 1);
        }
    }

    public static final class StateBuilder {
        private final Block BLOCK;
        private final Map<IProperty<? extends Comparable<?>>, Comparable<?>> propertiesToMatch = new HashMap();

        public StateBuilder(Block block) {
            this.BLOCK = block;
        }

        private StateBuilder() {
            this.BLOCK = null;
        }

        public boolean isEmpty() {
            return this.propertiesToMatch.isEmpty();
        }

        public boolean contains(IProperty<? extends Comparable<?>> property) {
            return this.propertiesToMatch.containsKey(property);
        }

        public StateBuilder add(IProperty<? extends Comparable<?>> property, Comparable<?> value) {
            this.propertiesToMatch.put(property, value);
            return this;
        }

        public TargetBlock toTargetBlock() {
            TargetBlock target = new TargetBlock(this.BLOCK);
            if (!this.isEmpty()) {
                target.MATCHERS.add(this.toTargetState());
            }
            return target;
        }

        private State toTargetState() {
            return new State(new ArrayList(this.propertiesToMatch.entrySet()));
        }
    }

    private static final class State {
        final List<Map.Entry<IProperty<?>, Comparable<?>>> PROPERTIES_TO_MATCH;

        State(List<Map.Entry<IProperty<?>, Comparable<?>>> properties) {
            this.PROPERTIES_TO_MATCH = properties;
        }

        boolean matches(IBlockState block) {
            for (Map.Entry<IProperty<?>, Comparable<?>> entry : this.PROPERTIES_TO_MATCH) {
                if (!this.notEqual(block.func_177229_b(entry.getKey()), entry.getValue())) continue;
                return false;
            }
            return true;
        }

        IBlockState asMatching(IBlockState block) {
            if (this.PROPERTIES_TO_MATCH.isEmpty()) {
                return block;
            }
            for (Map.Entry<IProperty<?>, Comparable<?>> entry : this.PROPERTIES_TO_MATCH) {
                block = this.withProperty(block, entry.getKey(), entry.getValue());
            }
            return block;
        }

        public String toString() {
            if (this.PROPERTIES_TO_MATCH.isEmpty()) {
                return "";
            }
            StringBuilder str = new StringBuilder();
            for (Map.Entry<IProperty<?>, Comparable<?>> entry : this.PROPERTIES_TO_MATCH) {
                str.append(entry.getKey().func_177701_a()).append("=").append(this.getPropertyName(entry.getKey(), entry.getValue())).append(",");
            }
            return str.substring(0, str.length() - 1);
        }

        <T extends Comparable<T>> IBlockState withProperty(IBlockState block, IProperty<T> property, Comparable<?> value) {
            return block.func_177226_a(property, value);
        }

        <T extends Comparable<T>> boolean notEqual(T stateValue, Comparable<?> targetValue) {
            return !stateValue.equals(targetValue);
        }

        <T extends Comparable<T>> String getPropertyName(IProperty<T> property, Comparable<?> value) {
            return property.func_177702_a(value);
        }

        static State parseState(String stateString, Block block) {
            String[] properties;
            if (stateString.isEmpty()) {
                return new State(Collections.emptyList());
            }
            BlockStateContainer stateContainer = block.func_176194_O();
            StateBuilder builder = new StateBuilder();
            for (String combinedEntry : properties = stateString.split(",")) {
                String[] entry = combinedEntry.split("=", 2);
                if (entry.length != 2) {
                    Config.log.warn("Invalid block property entry '{}' - format must follow 'property=value'", (Object)combinedEntry);
                    continue;
                }
                if (entry[1].equals("*")) continue;
                IProperty property = stateContainer.func_185920_a(entry[0]);
                if (property == null) {
                    Config.log.warn("Invalid block property key '{}' for block '{}'", (Object)entry[0], (Object)block.getRegistryName());
                    continue;
                }
                Optional value = property.func_185929_b(entry[1]);
                if (value == null || !value.isPresent()) {
                    Config.log.warn("Invalid block property value '{}' for property key '{}' and block '{}'", (Object)entry[1], (Object)entry[0], (Object)block.getRegistryName());
                    continue;
                }
                builder.add(property, (Comparable)value.get());
            }
            return builder.toTargetState();
        }
    }
}

