/*
 * Decompiled with CFR 0.152.
 */
package exterminatorjeff.undergroundbiomes.core;

import exterminatorjeff.undergroundbiomes.api.API;
import exterminatorjeff.undergroundbiomes.client.UBCreativeTab;
import exterminatorjeff.undergroundbiomes.client.UBOreModelLoader;
import exterminatorjeff.undergroundbiomes.client.UBStateMappers;
import exterminatorjeff.undergroundbiomes.common.block.UBOre;
import exterminatorjeff.undergroundbiomes.config.UBConfig;
import exterminatorjeff.undergroundbiomes.core.CommonProxy;
import exterminatorjeff.undergroundbiomes.intermod.OresRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.item.Item;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public final class ClientProxy
extends CommonProxy {
    @Override
    public void preInit(FMLPreInitializationEvent e) {
        super.preInit(e);
        MinecraftForge.EVENT_BUS.register((Object)OresRegistry.INSTANCE);
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new UBOreModelLoader());
    }

    @Override
    public void init(FMLInitializationEvent e) {
        super.init(e);
        this.colorizeOres();
        UBCreativeTab.UB_BLOCKS_TAB.setTabIconItem((Item)API.IGNEOUS_STONE.getItemBlock());
        UBCreativeTab.UB_ITEMS_TAB.setTabIconItem(API.LIGNITE_COAL.getItem());
        UBCreativeTab.UB_ORES_TAB.setTabIconItem(OresRegistry.INSTANCE.getUBOresTabIcon());
    }

    @Override
    public void postInit(FMLPostInitializationEvent e) {
        super.postInit(e);
    }

    @Override
    public void registerModels(ModelRegistryEvent event) {
        this.registerBlocksModels();
        this.registerItemsModels();
        OresRegistry.INSTANCE.registerOreModels();
    }

    private final void registerBlocksModels() {
        API.IGNEOUS_STONE.registerModel();
        API.IGNEOUS_MONSTER_STONE.registerModel();
        API.IGNEOUS_COBBLE.registerModel();
        API.IGNEOUS_BRICK.registerModel();
        API.IGNEOUS_MOSSY_COBBLE.registerModel();
        API.IGNEOUS_OVERGROWN.registerModel();
        API.IGNEOUS_OVERGROWN_SNOWED.registerModel();
        API.METAMORPHIC_STONE.registerModel();
        API.METAMORPHIC_MONSTER_STONE.registerModel();
        API.METAMORPHIC_COBBLE.registerModel();
        API.METAMORPHIC_BRICK.registerModel();
        API.METAMORPHIC_OVERGROWN.registerModel();
        API.METAMORPHIC_OVERGROWN_SNOWED.registerModel();
        API.METAMORPHIC_MOSSY_COBBLE.registerModel();
        API.IGNEOUS_MOSSY_COBBLE.registerModel();
        API.SEDIMENTARY_STONE.registerModel();
        API.SEDIMENTARY_MONSTER_STONE.registerModel();
        API.SEDIMENTARY_OVERGROWN.registerModel();
        API.SEDIMENTARY_OVERGROWN_SNOWED.registerModel();
        API.SEDIMENTARY_MOSSY_COBBLE.registerModel();
        API.IGNEOUS_GRAVEL.registerModel();
        API.METAMORPHIC_GRAVEL.registerModel();
        API.SEDIMENTARY_GRAVEL.registerModel();
        API.IGNEOUS_SAND.registerModel();
        API.METAMORPHIC_SAND.registerModel();
        API.SEDIMENTARY_SAND.registerModel();
        if (Loader.isModLoaded((String)"quark")) {
            API.IGNEOUS_SPELEOTHEM.registerModel();
            API.METAMORPHIC_SPELEOTHEM.registerModel();
            API.SEDIMENTARY_SPELEOTHEM.registerModel();
        }
        if (!UBConfig.SPECIFIC.alternativeSlabTextures()) {
            API.IGNEOUS_STONE_SLAB.registerModel(UBStateMappers.UBSLAB_STATE_MAPPER);
            API.METAMORPHIC_STONE_SLAB.registerModel(UBStateMappers.UBSLAB_STATE_MAPPER);
        } else {
            API.IGNEOUS_STONE_SLAB.registerModel();
            API.METAMORPHIC_STONE_SLAB.registerModel();
        }
        API.SEDIMENTARY_STONE_SLAB.registerModel();
        API.IGNEOUS_COBBLE_SLAB.registerModel();
        API.METAMORPHIC_COBBLE_SLAB.registerModel();
        API.IGNEOUS_BRICK_SLAB.registerModel();
        API.METAMORPHIC_BRICK_SLAB.registerModel();
        API.IGNEOUS_STONE_BUTTON.registerModel(UBStateMappers.UBBUTTON_STATE_MAPPER);
        API.IGNEOUS_COBBLE_BUTTON.registerModel(UBStateMappers.UBBUTTON_STATE_MAPPER);
        API.IGNEOUS_BRICK_BUTTON.registerModel(UBStateMappers.UBBUTTON_STATE_MAPPER);
        API.METAMORPHIC_STONE_BUTTON.registerModel(UBStateMappers.UBBUTTON_STATE_MAPPER);
        API.METAMORPHIC_COBBLE_BUTTON.registerModel(UBStateMappers.UBBUTTON_STATE_MAPPER);
        API.METAMORPHIC_BRICK_BUTTON.registerModel(UBStateMappers.UBBUTTON_STATE_MAPPER);
        API.SEDIMENTARY_STONE_BUTTON.registerModel(UBStateMappers.UBBUTTON_STATE_MAPPER);
        API.IGNEOUS_STONE_WALL.registerModel();
        API.IGNEOUS_COBBLE_WALL.registerModel();
        API.IGNEOUS_BRICK_WALL.registerModel();
        API.METAMORPHIC_STONE_WALL.registerModel();
        API.METAMORPHIC_COBBLE_WALL.registerModel();
        API.METAMORPHIC_BRICK_WALL.registerModel();
        API.SEDIMENTARY_STONE_WALL.registerModel();
        API.IGNEOUS_STONE_STAIRS.registerModel(UBStateMappers.UBSTAIRS_STATE_MAPPER);
        API.IGNEOUS_COBBLE_STAIRS.registerModel(UBStateMappers.UBSTAIRS_STATE_MAPPER);
        API.IGNEOUS_BRICK_STAIRS.registerModel(UBStateMappers.UBSTAIRS_STATE_MAPPER);
        API.METAMORPHIC_STONE_STAIRS.registerModel(UBStateMappers.UBSTAIRS_STATE_MAPPER);
        API.METAMORPHIC_COBBLE_STAIRS.registerModel(UBStateMappers.UBSTAIRS_STATE_MAPPER);
        API.METAMORPHIC_BRICK_STAIRS.registerModel(UBStateMappers.UBSTAIRS_STATE_MAPPER);
        API.SEDIMENTARY_STONE_STAIRS.registerModel(UBStateMappers.UBSTAIRS_STATE_MAPPER);
    }

    private final void registerItemsModels() {
        API.LIGNITE_COAL.registerModel();
        API.FOSSIL_PIECE.registerModel();
    }

    public void colorizeOres() {
        BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
        ItemColors itemColors = Minecraft.func_71410_x().getItemColors();
        for (UBOre ore : API.REGISTERED_ORES) {
            if (ore.config.getColor() == null) continue;
            int color = Integer.decode(ore.config.getColor());
            blockColors.func_186722_a((state, worldIn, pos, tintIndex) -> color, new Block[]{ore});
            itemColors.func_186730_a((stack, tintIndex) -> color, new Item[]{Item.func_150898_a((Block)ore)});
        }
        blockColors.func_186722_a(new IBlockColor(){

            public int func_186720_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
                return worldIn != null && pos != null ? BiomeColorHelper.func_180286_a((IBlockAccess)worldIn, (BlockPos)pos) : ColorizerGrass.func_77480_a((double)0.5, (double)1.0);
            }
        }, new Block[]{API.IGNEOUS_OVERGROWN.getBlock()});
        blockColors.func_186722_a(new IBlockColor(){

            public int func_186720_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
                return worldIn != null && pos != null ? BiomeColorHelper.func_180286_a((IBlockAccess)worldIn, (BlockPos)pos) : ColorizerGrass.func_77480_a((double)0.5, (double)1.0);
            }
        }, new Block[]{API.METAMORPHIC_OVERGROWN.getBlock()});
        blockColors.func_186722_a(new IBlockColor(){

            public int func_186720_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
                return worldIn != null && pos != null ? BiomeColorHelper.func_180286_a((IBlockAccess)worldIn, (BlockPos)pos) : ColorizerGrass.func_77480_a((double)0.5, (double)1.0);
            }
        }, new Block[]{API.SEDIMENTARY_OVERGROWN.getBlock()});
    }
}

