/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile;

import hellfirepvp.astralsorcery.common.auxiliary.StorageNetworkHandler;
import hellfirepvp.astralsorcery.common.tile.base.TileEntityTick;
import hellfirepvp.astralsorcery.common.tile.storage.IStorageNetworkTile;
import hellfirepvp.astralsorcery.common.tile.storage.StorageCache;
import hellfirepvp.astralsorcery.common.tile.storage.StorageKey;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class TileStorageCore
extends TileEntityTick
implements IStorageNetworkTile<TileStorageCore> {
    private StorageCache storageCache = new StorageCache();
    private UUID ownerUUID;

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.getOwnerUUID() == null) {
            return;
        }
    }

    @Override
    public void receiveMappingChange(StorageNetworkHandler.MappingChange newMapping) {
    }

    public void onLoad() {
        super.onLoad();
        StorageNetworkHandler.getHandler(this.func_145831_w()).addCore(this);
    }

    public void func_145843_s() {
        super.func_145843_s();
        StorageNetworkHandler.getHandler(this.func_145831_w()).removeCore(this);
    }

    @Override
    protected void onFirstTick() {
    }

    @Override
    public TileStorageCore getAssociatedCore() {
        return this;
    }

    @Override
    public World getNetworkWorld() {
        return this.func_145831_w();
    }

    @Override
    public BlockPos getLocationPos() {
        return this.func_174877_v();
    }

    @Nullable
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public void setOwnerUUID(@Nullable UUID ownerUUID) {
        this.ownerUUID = ownerUUID;
    }

    public boolean extractFromStorage(IItemHandler inv, StorageKey key, boolean simulate) {
        return this.storageCache.attemptTransferInto(key, inv, simulate);
    }

    public boolean insertIntoStorage(ItemStack stack) {
        return !stack.func_190926_b() && this.storageCache.add(stack);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        if (this.ownerUUID != null) {
            compound.func_186854_a("ownerUUID", this.ownerUUID);
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.ownerUUID = compound.func_186855_b("ownerUUID") ? compound.func_186857_a("ownerUUID") : null;
    }

    @Override
    public void readSaveNBT(NBTTagCompound compound) {
        super.readSaveNBT(compound);
        StorageCache cache = new StorageCache();
        cache.readFromNBT(compound.func_74775_l("storage"));
        this.storageCache = cache;
    }

    @Override
    public void writeSaveNBT(NBTTagCompound compound) {
        super.writeSaveNBT(compound);
        NBTHelper.setAsSubTag(compound, "storage", this.storageCache::writeToNBT);
    }
}

