/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.reader.impl;

import hellfirepvp.astralsorcery.common.constellation.perk.PlayerAttributeMap;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.AttributeTypeLimiter;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.PerkAttributeModifier;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.PerkAttributeType;
import hellfirepvp.astralsorcery.common.constellation.perk.reader.AttributeReader;
import hellfirepvp.astralsorcery.common.constellation.perk.reader.PerkStatistic;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.event.AttributeEvent;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FlatAttributeReader
extends AttributeReader {
    protected final PerkAttributeType attribute;
    protected final float defaultValue;
    private boolean formatAsDecimal = false;

    public FlatAttributeReader(PerkAttributeType attribute, float defaultValue) {
        this.attribute = attribute;
        this.defaultValue = defaultValue;
    }

    public <T extends FlatAttributeReader> T formatAsDecimal() {
        this.formatAsDecimal = true;
        return (T)this;
    }

    @Override
    public double getDefaultValue(PlayerAttributeMap statMap, EntityPlayer player, Side side) {
        return this.defaultValue;
    }

    @Override
    public double getModifierValueForMode(PlayerAttributeMap statMap, EntityPlayer player, Side side, PerkAttributeModifier.Mode mode) {
        return statMap.getModifier(player, ResearchManager.getProgress(player, side), this.attribute.getTypeString(), mode);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public PerkStatistic getStatistics(PlayerAttributeMap statMap, EntityPlayer player) {
        Float limit = AttributeTypeLimiter.INSTANCE.getMaxLimit(this.attribute);
        String limitStr = limit == null ? "" : I18n.func_135052_a((String)"perk.reader.limit.default", (Object[])new Object[]{MathHelper.func_76141_d((float)limit.floatValue())});
        double value = statMap.modifyValue(player, ResearchManager.getProgress(player, Side.CLIENT), this.attribute.getTypeString(), (float)this.getDefaultValue(statMap, player, Side.CLIENT));
        String postProcess = "";
        double post = AttributeEvent.postProcessModded(player, this.attribute, value);
        if (Math.abs(value - post) > 1.0E-4 && (limit == null || Math.abs(post - (double)limit.floatValue()) > 1.0E-4)) {
            if (Math.abs(post) >= 1.0E-4) {
                postProcess = I18n.func_135052_a((String)"perk.reader.postprocess.default", (Object[])new Object[]{this.formatForDisplay(post)});
            }
            value = post;
        }
        return new PerkStatistic(this.attribute, this.formatForDisplay(value), limitStr, postProcess);
    }

    protected String formatForDisplay(double value) {
        String valueStr = this.formatAsDecimal ? FlatAttributeReader.formatDecimal(value) : String.valueOf(MathHelper.func_76128_c((double)value));
        return (value >= 0.0 ? "+" : "") + valueStr;
    }
}

