/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.effect.aoe;

import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.effect.controller.orbital.OrbitalEffectController;
import hellfirepvp.astralsorcery.client.effect.controller.orbital.OrbitalPropertiesRitualArmara;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.effect.CEffectEntityCollect;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffectProperties;
import hellfirepvp.astralsorcery.common.entities.EntityTechnicalAmbient;
import hellfirepvp.astralsorcery.common.event.listener.EventHandlerEntity;
import hellfirepvp.astralsorcery.common.item.crystal.base.ItemTunedCrystalBase;
import hellfirepvp.astralsorcery.common.lib.Constellations;
import hellfirepvp.astralsorcery.common.registry.RegistryPotions;
import hellfirepvp.astralsorcery.common.tile.TileRitualPedestal;
import hellfirepvp.astralsorcery.common.util.ILocatable;
import hellfirepvp.astralsorcery.common.util.data.TickTokenizedMap;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.data.WorldBlockPos;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CEffectArmara
extends CEffectEntityCollect<EntityMob> {
    public static boolean enabled = true;
    public static double potencyMultiplier = 1.0;
    public static int protectionRange = 32;
    private int rememberedTimeout = 0;
    public static int potionAmplifier = 0;

    public CEffectArmara(@Nullable ILocatable origin) {
        super(origin, Constellations.armara, "armara", protectionRange, EntityMob.class, entity -> !entity.field_70128_L && !(entity instanceof EntityTechnicalAmbient));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void playClientEffect(World world, BlockPos pos, TileRitualPedestal pedestal, float percEffectVisibility, boolean extendedEffects) {
        List projectiles;
        ItemStack socket;
        if (pedestal.getTicksExisted() % 20 == 0) {
            OrbitalPropertiesRitualArmara luc = new OrbitalPropertiesRitualArmara();
            OrbitalEffectController ctrl = EffectHandler.getInstance().orbital(luc, luc, luc);
            ctrl.setOffset(new Vector3(pos).add(0.5, 0.5, 0.5));
            ctrl.setOrbitRadius(0.8 + (double)rand.nextFloat() * 0.7);
            ctrl.setOrbitAxis(Vector3.RotAxis.Y_AXIS);
            ctrl.setTicksPerRotation(20 + rand.nextInt(20));
        }
        if (!(socket = pedestal.getCatalystCache()).func_190926_b() && socket.func_77973_b() instanceof ItemTunedCrystalBase) {
            IMinorConstellation trait = ItemTunedCrystalBase.getTrait(socket);
            ConstellationEffectProperties prop = this.provideProperties(0);
            prop.modify(trait);
            if (prop.isCorrupted()) {
                return;
            }
        }
        if (!(projectiles = world.func_72872_a(Entity.class, new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_186670_a(pos).func_186662_g((double)protectionRange))).isEmpty()) {
            for (Entity e : projectiles) {
                if (e.field_70128_L || e instanceof EntityTechnicalAmbient || !(e instanceof IProjectile)) continue;
                double xRatio = (double)pos.func_177958_n() + 0.5 - e.field_70165_t;
                double zRatio = (double)pos.func_177952_p() + 0.5 - e.field_70161_v;
                float f = MathHelper.func_76133_a((double)(xRatio * xRatio + zRatio * zRatio));
                e.field_70159_w /= 2.0;
                e.field_70179_y /= 2.0;
                e.field_70159_w -= xRatio / (double)f * 0.4;
                e.field_70179_y -= zRatio / (double)f * 0.4;
                ((IProjectile)e).func_70186_c(e.field_70159_w, e.field_70181_x, e.field_70179_y, 1.0f, 0.0f);
            }
        }
    }

    @Override
    public boolean playEffect(World world, BlockPos pos, float percStrength, ConstellationEffectProperties modified, @Nullable IMinorConstellation possibleTraitEffect) {
        List projectiles;
        if (!enabled) {
            return false;
        }
        if ((percStrength = (float)((double)percStrength * potencyMultiplier)) < 1.0f && world.field_73012_v.nextFloat() > percStrength) {
            return false;
        }
        int toAdd = 1 + rand.nextInt(3);
        WorldBlockPos at = new WorldBlockPos(world, pos);
        TickTokenizedMap.SimpleTickToken token = (TickTokenizedMap.SimpleTickToken)EventHandlerEntity.spawnDenyRegions.get((Object)at);
        if (token != null) {
            int next = token.getRemainingTimeout() + toAdd;
            if (next > 400) {
                next = 400;
            }
            token.setTimeout(next);
            this.rememberedTimeout = next;
        } else {
            this.rememberedTimeout = Math.min(400, this.rememberedTimeout + toAdd);
            EventHandlerEntity.spawnDenyRegions.put(at, new TickTokenizedMap.SimpleTickToken<Double>(Double.valueOf(protectionRange), this.rememberedTimeout));
        }
        EntityPlayer owner = this.getOwningPlayerInWorld(world, pos);
        boolean foundEntity = false;
        if (!modified.isCorrupted() && !(projectiles = world.func_72872_a(Entity.class, new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_186670_a(pos).func_186662_g((double)protectionRange))).isEmpty()) {
            for (Entity e : projectiles) {
                if (e.field_70128_L || e instanceof EntityTechnicalAmbient) continue;
                if (e instanceof IProjectile) {
                    double xRatio = (double)pos.func_177958_n() + 0.5 - e.field_70165_t;
                    double zRatio = (double)pos.func_177952_p() + 0.5 - e.field_70161_v;
                    float f = MathHelper.func_76133_a((double)(xRatio * xRatio + zRatio * zRatio));
                    e.field_70159_w /= 2.0;
                    e.field_70179_y /= 2.0;
                    e.field_70159_w -= xRatio / (double)f * 0.4;
                    e.field_70179_y -= zRatio / (double)f * 0.4;
                    ((IProjectile)e).func_70186_c(e.field_70159_w, e.field_70181_x, e.field_70179_y, 1.0f, 0.0f);
                } else if (e instanceof EntityMob) {
                    ((EntityLivingBase)e).func_70653_a((Entity)(owner == null ? e : owner), 0.4f, (double)pos.func_177958_n() + 0.5 - e.field_70165_t, (double)pos.func_177952_p() + 0.5 - e.field_70161_v);
                }
                foundEntity = true;
            }
        }
        List entities = world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_186670_a(pos).func_186662_g((double)protectionRange));
        for (EntityLivingBase entity : entities) {
            if (entity.field_70128_L || !(entity instanceof EntityMob) && !(entity instanceof EntityPlayer)) continue;
            if (modified.isCorrupted()) {
                if (entity instanceof EntityPlayer) continue;
                entity.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 100, potionAmplifier + 4));
                entity.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 100, potionAmplifier + 4));
                entity.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 100, potionAmplifier + 2));
                entity.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 100, potionAmplifier + 4));
                entity.func_70690_d(new PotionEffect(MobEffects.field_76427_o, 100, potionAmplifier + 4));
                entity.func_70690_d(new PotionEffect(MobEffects.field_76422_e, 100, potionAmplifier + 4));
                entity.func_70690_d(new PotionEffect((Potion)RegistryPotions.potionDropModifier, 40000, 6));
            } else {
                entity.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 30, potionAmplifier));
                if (entity instanceof EntityPlayer) {
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76444_x, 30, potionAmplifier));
                }
            }
            foundEntity = true;
        }
        return foundEntity;
    }

    @Override
    public ConstellationEffectProperties provideProperties(int mirrorCount) {
        return new ConstellationEffectProperties(protectionRange);
    }

    @Override
    public void readFromNBT(NBTTagCompound cmp) {
        super.readFromNBT(cmp);
        this.rememberedTimeout = cmp.func_74762_e("rememberedTimeout");
    }

    @Override
    public void writeToNBT(NBTTagCompound cmp) {
        super.writeToNBT(cmp);
        cmp.func_74768_a("rememberedTimeout", this.rememberedTimeout);
    }

    @Override
    public void loadFromConfig(Configuration cfg) {
        protectionRange = cfg.getInt(this.getKey() + "Range", this.getConfigurationSection(), 32, 1, 128, "Defines the radius (in blocks) in which the ritual will stop mob spawning and projectiles.");
        enabled = cfg.getBoolean(this.getKey() + "Enabled", this.getConfigurationSection(), true, "Set to false to disable this ConstellationEffect.");
        potionAmplifier = cfg.getInt(this.getKey() + "ResistanceAmplifier", this.getConfigurationSection(), 0, 0, Short.MAX_VALUE, "Set the amplifier for the resistance potion effect.");
        potencyMultiplier = cfg.getFloat(this.getKey() + "PotencyMultiplier", this.getConfigurationSection(), 1.0f, 0.01f, 100.0f, "Set the potency multiplier for this ritual effect. Will affect all ritual effects and their efficiency.");
    }
}

