/*
 * Decompiled with CFR 0.152.
 */
package be.ephys.cookiecore.config;

import be.ephys.cookiecore.config.Config;
import be.ephys.cookiecore.core.CookieCore;
import java.lang.reflect.Field;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.StringUtils;

public class ConfigSynchronizer {
    private final ModMetadata modMeta;
    private final Configuration configHandler;

    public static void synchronizeConfig(FMLPreInitializationEvent event) {
        new ConfigSynchronizer(event);
    }

    public static void synchronizeConfig(FMLPreInitializationEvent event, Configuration configHandler) {
        new ConfigSynchronizer(event, configHandler);
    }

    private ConfigSynchronizer(FMLPreInitializationEvent event) {
        this(event, ConfigSynchronizer.buildConfigHandler(event));
        if (this.configHandler.hasChanged()) {
            this.configHandler.save();
        }
    }

    private ConfigSynchronizer(FMLPreInitializationEvent event, Configuration configHandler) {
        this.modMeta = event.getModMetadata();
        this.configHandler = configHandler;
        Set configAsm = event.getAsmData().getAll(Config.class.getCanonicalName());
        CookieCore.getLogger().info("Syncing config fields from mod " + this.modMeta.modId + " (" + this.modMeta.name + ")");
        for (ASMDataTable.ASMData asmData : configAsm) {
            if (!ConfigSynchronizer.isFromMod(asmData, event.getModMetadata().modId)) continue;
            try {
                Class<?> annotatedClass = Class.forName(asmData.getClassName());
                String fieldName = asmData.getObjectName();
                Field field = annotatedClass.getField(fieldName);
                Config configMeta = field.getAnnotation(Config.class);
                ConfigSynchronizer.syncConfigField(field, configMeta, configHandler);
            }
            catch (ClassNotFoundException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onConfigChange(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (!event.getModID().equals(this.modMeta.modId)) {
            return;
        }
    }

    private static void syncConfigField(Field field, Config configMeta, Configuration configHandler) {
        try {
            String category;
            field.setAccessible(true);
            Object defaultValue = field.get(null);
            String fieldName = configMeta.name();
            if (fieldName.equals("")) {
                fieldName = field.getName();
            }
            if ((category = configMeta.category()).equals("")) {
                category = "general";
            }
            Object actualValue = ConfigSynchronizer.get(configHandler, category, fieldName, configMeta.description(), configMeta.requiresMcRestart(), configMeta.requiresWorldRestart(), field.getType(), defaultValue);
            field.set(null, actualValue);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private static boolean isFromMod(ASMDataTable.ASMData asmData, String modId) {
        List containedMods = asmData.getCandidate().getContainedMods();
        for (ModContainer mod : containedMods) {
            if (!mod.getModId().equals(modId)) continue;
            return true;
        }
        return false;
    }

    private static Property getPropertyByType(Configuration configHandler, String category, String key, Object defaultValue, Class<?> valueType) {
        if (valueType == Boolean.class || valueType == Boolean.TYPE) {
            return configHandler.get(category, key, ((Boolean)defaultValue).booleanValue());
        }
        if (valueType == Integer.class || valueType == Integer.TYPE) {
            return configHandler.get(category, key, ((Integer)defaultValue).intValue());
        }
        if (valueType == Double.class || valueType == Double.TYPE) {
            return configHandler.get(category, key, ((Double)defaultValue).doubleValue());
        }
        if (valueType == String.class) {
            return configHandler.get(category, key, (String)defaultValue);
        }
        if (ConfigSynchronizer.isEnum(valueType)) {
            return configHandler.get(category, key, ((Enum)defaultValue).name());
        }
        throw new IllegalArgumentException("Unsupported type " + valueType.getCanonicalName());
    }

    private static Object getValue(Property property, Class<?> valueType) {
        if (valueType == Boolean.class || valueType == Boolean.TYPE) {
            return property.getBoolean();
        }
        if (valueType == Integer.class || valueType == Integer.TYPE) {
            return property.getInt();
        }
        if (valueType == Double.class || valueType == Double.TYPE) {
            return property.getDouble();
        }
        if (valueType == String.class) {
            return property.getString();
        }
        if (ConfigSynchronizer.isEnum(valueType)) {
            return ConfigSynchronizer.getEnum(valueType, property.getString());
        }
        throw new IllegalArgumentException("Unsupported type " + valueType.getCanonicalName());
    }

    private static <T> T get(Configuration configHandler, String category, String optionName, String description, boolean requiresMcRestart, boolean requiresWorldRestart, Class<T> valueType, Object defaultValue) {
        Property property = ConfigSynchronizer.getPropertyByType(configHandler, category, optionName, defaultValue, valueType);
        if (ConfigSynchronizer.isEnum(valueType)) {
            if (description.length() > 0) {
                description = description + "\n";
            }
            description = description + "Possible values (must match exactly): " + StringUtils.join((Iterable)ConfigSynchronizer.getEnums(valueType), (String)" | ");
        }
        property.setComment(description);
        property.setRequiresMcRestart(requiresMcRestart);
        property.setRequiresWorldRestart(requiresWorldRestart);
        return (T)ConfigSynchronizer.getValue(property, valueType);
    }

    private static boolean isEnum(Class<?> aClass) {
        return Enum.class.isAssignableFrom(aClass);
    }

    private static EnumSet getEnums(Class aClass) {
        return EnumSet.allOf(aClass);
    }

    private static Enum getEnum(Class aClass, String enumName) {
        return Enum.valueOf(aClass, enumName);
    }

    private static Configuration buildConfigHandler(FMLPreInitializationEvent event) {
        Configuration configHandler = new Configuration(event.getSuggestedConfigurationFile());
        configHandler.load();
        return configHandler;
    }
}

