/*
 * Decompiled with CFR 0.152.
 */
package magicbees.util;

import magicbees.init.ItemRegister;
import magicbees.item.types.EnumNuggetType;
import magicbees.util.MagicBeesResourceLocation;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public enum EnumOreResourceType {
    IRON(new ItemStack(ItemRegister.ironNugget), "nuggetIron"),
    GOLD(new ItemStack(Items.field_151074_bl), new String[0]),
    COPPER(EnumNuggetType.COPPER, "nuggetCopper"),
    TIN(EnumNuggetType.TIN, "nuggetTin"),
    SILVER("nuggetSilver", "dustTinySilver"),
    LEAD("nuggetLead", "dustTinyLead"),
    ALUMINIUM("nuggetAluminium", "nuggetAluminum"),
    ARDITE("nuggetArdite"),
    COBALT("nuggetCobalt"),
    MANYULLYN("nuggetManyullyn"),
    OSMIUM("nuggetOsmium"),
    DIAMOND(EnumNuggetType.DIAMOND, new String[]{"nuggetDiamond"}){

        @Override
        public String getType() {
            return "gem";
        }
    }
    ,
    EMERALD(EnumNuggetType.EMERALD, new String[]{"nuggetEmerald"}){

        @Override
        public String getType() {
            return "gem";
        }
    }
    ,
    APATITE(EnumNuggetType.APATITE, new String[]{"nuggetApatite"}){

        @Override
        public String getType() {
            return "gem";
        }
    }
    ,
    SILICON(new String[0]),
    CERTUS(new String[0]),
    FLUIX(new String[0]),
    PLATINUM("nuggetPlatinum"),
    NICKEL("nuggetNickel", "nuggetFerrous"),
    BRONZE(EnumNuggetType.BRONZE, "nuggetBronze"),
    INVAR("nuggetInvar"),
    ELECTRUM("nuggetElectrum");

    private String[] oreDictA;
    private ItemStack finalStack;

    private EnumOreResourceType(EnumNuggetType nugget, String ... oreDictA) {
        this(nugget.getStack(), oreDictA);
    }

    private EnumOreResourceType(String ... oreDictA) {
        this((ItemStack)null, oreDictA);
    }

    private EnumOreResourceType(ItemStack stack, String ... oreDictA) {
        if (oreDictA == null) {
            oreDictA = new String[]{};
        }
        this.setStack(stack);
        this.oreDictA = oreDictA;
    }

    public String getType() {
        return "ingot";
    }

    private void setStack(ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            stack = null;
        }
        this.finalStack = stack;
    }

    public boolean enabled() {
        this.getStack();
        return this.finalStack != null;
    }

    public ItemStack getStack() {
        if (this.oreDictA != null) {
            block0: for (String oreDict : this.oreDictA) {
                NonNullList l = OreDictionary.getOres((String)oreDict);
                if (l.isEmpty()) continue;
                for (ItemStack stack_ : l) {
                    if (stack_.func_190926_b()) continue;
                    this.setStack(stack_.func_77946_l());
                    break block0;
                }
            }
            this.oreDictA = null;
        }
        return this.finalStack == null ? ItemStack.field_190927_a : this.finalStack;
    }

    public static void registerRecipes(IForgeRegistry<IRecipe> recipes) {
        for (EnumOreResourceType type : EnumOreResourceType.values()) {
            NonNullList scks;
            if (type.oreDictA.length <= 0 || type.finalStack == null || type.finalStack.func_190926_b() || type.finalStack.func_77973_b() == ItemRegister.ironNugget && ItemRegister.ironNugget.getRegistryName().func_110624_b().equals("minecraft")) continue;
            for (String s : type.oreDictA) {
                if (!s.startsWith("nugget")) continue;
                OreDictionary.registerOre((String)s, (ItemStack)type.finalStack);
            }
            if (!type.oreDictA[0].startsWith("nugget") || (scks = OreDictionary.getOres((String)type.oreDictA[0].replace("nugget", type.getType()))).size() <= 0 || ((ItemStack)scks.get(0)).func_190926_b()) continue;
            MagicBeesResourceLocation name = new MagicBeesResourceLocation(type.oreDictA[0] + "_to_block");
            IRecipe recipe = (IRecipe)new ShapedOreRecipe(null, (ItemStack)scks.get(0), new Object[]{"XXX", "XXX", "XXX", Character.valueOf('X'), type.oreDictA[0]}).setRegistryName((ResourceLocation)name);
            recipes.register((IForgeRegistryEntry)recipe);
        }
    }
}

