/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_chemistry.handlers.ModConfig;
import com.globbypotato.rockhounding_chemistry.machines.tile.ICollapse;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEGaslinePump;
import com.globbypotato.rockhounding_core.gas.GasHandlerConcatenate;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityVessel;
import java.util.ArrayList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileVessel
extends TileEntityVessel
implements ICollapse {
    public int emitType;
    public int emitThreashold;
    public int capacity;
    public static int templateSlots = 5;
    public FluidTank inputTank;
    public FluidStack filter = null;
    public int collapseRate = 0;

    public TileVessel(int capacity) {
        super(0, 0, templateSlots, 0);
        this.capacity = capacity;
        this.inputTank = new FluidTank(capacity){

            public boolean canFillFluidType(FluidStack gas) {
                return TileVessel.this.canFillFiltered(gas);
            }

            public boolean canDrainFluidType(FluidStack gas) {
                return TileVessel.this.isValidPump(gas);
            }

            public void onContentsChanged() {
                TileVessel.this.updateNeighbours();
            }
        };
        this.inputTank.setTileEntity((TileEntity)this);
        this.markDirtyClient();
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inputTank.readFromNBT(compound.func_74775_l("InputGas"));
        this.filter = FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound.func_74775_l("Filter"));
        this.collapseRate = compound.func_74762_e("Collapse");
        this.emitThreashold = compound.func_74762_e("EmitThreashold");
        this.emitType = compound.func_74762_e("EmitType");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("Collapse", this.getCollapse());
        compound.func_74768_a("EmitType", this.emitType);
        compound.func_74768_a("EmitThreashold", this.emitThreashold);
        NBTTagCompound storage = new NBTTagCompound();
        this.inputTank.writeToNBT(storage);
        compound.func_74782_a("InputGas", (NBTBase)storage);
        if (this.getFilter() != null) {
            NBTTagCompound filterNBT = new NBTTagCompound();
            this.filter.writeToNBT(filterNBT);
            compound.func_74782_a("Filter", (NBTBase)filterNBT);
        }
        return compound;
    }

    public GasHandlerConcatenate getCombinedGasTank() {
        return new GasHandlerConcatenate(new IFluidHandler[]{this.inputTank});
    }

    public int getGUIHeight() {
        return 200;
    }

    public int getCollapse() {
        return this.collapseRate;
    }

    @Override
    public ArrayList<FluidTank> collapseList() {
        ArrayList<FluidTank> tanks = new ArrayList<FluidTank>();
        tanks.add(this.inputTank);
        return tanks;
    }

    public int exhaustOffset() {
        return 1;
    }

    public int getTankCapacity() {
        return this.capacity;
    }

    public int getTankAmount() {
        return this.hasTankFluid() ? this.inputTank.getFluidAmount() : 0;
    }

    public void updateNeighbours() {
        this.field_145850_b.func_175685_c(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c(), true);
    }

    public int getEmitType() {
        return this.emitType;
    }

    public int getEmitThreashold() {
        return this.emitThreashold;
    }

    public int emittedPower() {
        int powerFraction = this.getTankCapacity() / 16;
        if (this.getEmitType() == 1) {
            return 15 * this.getTankAmount() / this.getTankCapacity();
        }
        if (this.getEmitType() == 2) {
            return this.getTankAmount() >= this.getTankCapacity() / 100 * this.getEmitThreashold() ? 15 : 0;
        }
        if (this.getEmitType() == 3) {
            return this.getTankAmount() < this.getTankCapacity() / 100 * this.getEmitThreashold() ? 15 : 0;
        }
        return 0;
    }

    public FluidStack getFilter() {
        return this.filter;
    }

    public boolean hasFilter() {
        return this.getFilter() != null;
    }

    public boolean inputTankHasGas() {
        return this.inputTank.getFluid() != null && this.inputTank.getFluidAmount() > 0;
    }

    public boolean hasTankFluid() {
        return this.inputTank.getFluid() != null;
    }

    public FluidStack getTankFluid() {
        return this.hasTankFluid() ? this.inputTank.getFluid() : null;
    }

    public boolean canFillFiltered(FluidStack gas) {
        return gas.getFluid().isGaseous() && this.isMatchingFilter(gas) && this.input.canSetOrAddFluid(this.inputTank, this.getTankFluid(), gas, 1);
    }

    private boolean isMatchingFilter(FluidStack fluid) {
        return this.hasFilter() ? this.getFilter().isFluidEqual(fluid) : true;
    }

    public boolean isValidPump(FluidStack gas) {
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.getFacing()));
        if (tile != null && tile instanceof TEGaslinePump) {
            TEGaslinePump pump = (TEGaslinePump)tile;
            return pump.isActive() && gas != null && gas.getFluid().isGaseous();
        }
        return false;
    }

    public void func_73660_a() {
    }

    public void checkCollapse() {
        if (ModConfig.enableHazard && this.field_145850_b.field_73012_v.nextInt(ModConfig.hazardChance) == 0) {
            if (this.handleCollapse(this.getCollapse(), this.field_145850_b, this.field_174879_c)) {
                ++this.collapseRate;
                if (this.getCollapse() >= ModConfig.pressureTolerance) {
                    if (this.hasExhaust(this.field_145850_b, this.field_174879_c, this.exhaustOffset())) {
                        this.doExhaustion(this.field_145850_b, this.field_174879_c, this.exhaustOffset());
                        this.collapseRate /= 2;
                    } else {
                        this.field_145850_b.func_72876_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 2.0f * (float)this.exhaustOffset(), true);
                    }
                }
            } else if (this.handleRelease(this.getCollapse(), this.field_145850_b, this.field_174879_c) && this.getCollapse() > 0) {
                --this.collapseRate;
            }
        }
    }
}

