/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_chemistry.ModItems;
import com.globbypotato.rockhounding_chemistry.enums.EnumCasting;
import com.globbypotato.rockhounding_chemistry.enums.EnumMiscItems;
import com.globbypotato.rockhounding_chemistry.enums.EnumServer;
import com.globbypotato.rockhounding_chemistry.machines.recipe.DepositionChamberRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.GasReformerRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.LabOvenRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.MetalAlloyerRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.PrecipitationRecipes;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class TEServer
extends TileEntityInv {
    public static int inputsSlots = 10;
    public static int templateSlots = 10;
    public static final int[] FILE_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    public static final int PRINT_SLOT = 9;
    public static final int FILTER_SLOT = 9;
    public boolean cycle;
    public int device = -1;
    public int deviceMax;
    public int recipeAmount = 0;
    public ItemStack filterStack = ItemStack.field_190927_a;
    public FluidStack filterFluid = null;

    public TEServer() {
        super(inputsSlots, 0, templateSlots, 0);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.cycle = compound.func_74767_n("Cycle");
        this.device = compound.func_74762_e("Device");
        this.deviceMax = compound.func_74762_e("MaxRecipes");
        this.recipeAmount = compound.func_74762_e("Amount");
        if (compound.func_74764_b("FilterStack")) {
            this.filterStack = new ItemStack(compound.func_74775_l("FilterStack"));
        }
        if (compound.func_74764_b("FilterFluid")) {
            this.filterFluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound.func_74775_l("FilterFluid"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("Cycle", this.getCycle());
        compound.func_74768_a("Device", this.servedDevice());
        compound.func_74768_a("MaxRecipes", this.servedMaxRecipes());
        compound.func_74768_a("Amount", this.getRecipeAmount());
        if (!this.getFilterStack().func_190926_b()) {
            NBTTagCompound filterstack = new NBTTagCompound();
            this.filterStack.func_77955_b(filterstack);
            compound.func_74782_a("FilterStack", (NBTBase)filterstack);
        }
        if (this.getFilterFluid() != null) {
            NBTTagCompound filterfluidNBT = new NBTTagCompound();
            this.filterFluid.writeToNBT(filterfluidNBT);
            compound.func_74782_a("FilterFluid", (NBTBase)filterfluidNBT);
        }
        return compound;
    }

    public ItemStack filterSlot() {
        return this.template.getStackInSlot(9);
    }

    public ItemStack printSlot() {
        return this.input.getStackInSlot(9);
    }

    public ItemStack inputSlot(int x) {
        return this.input.getStackInSlot(x);
    }

    public int getGUIHeight() {
        return 200;
    }

    public static String getName() {
        return "server";
    }

    public boolean isComparatorSensible() {
        return false;
    }

    public boolean getCycle() {
        return this.cycle;
    }

    public ItemStack getFilterStack() {
        return this.filterStack;
    }

    public FluidStack getFilterFluid() {
        return this.filterFluid;
    }

    public int servedDevice() {
        return this.device;
    }

    public int servedMaxRecipes() {
        return this.deviceMax;
    }

    public int getRecipeAmount() {
        return this.recipeAmount;
    }

    public boolean isValidInterval() {
        return this.getRecipeIndex() > -1 && this.getRecipeIndex() < this.servedMaxRecipes();
    }

    public boolean hasStackFilter() {
        return this.servedDevice() > -1 && EnumServer.values()[this.servedDevice()].getFilter();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.loadFilter();
            this.loadFile();
            this.markDirtyClient();
        }
    }

    private void loadFilter() {
        if (this.hasStackFilter() && !this.getFilterStack().func_190926_b() && (this.filterSlot().func_190926_b() || !this.filterSlot().func_77969_a(this.getFilterStack()))) {
            this.template.setStackInSlot(9, this.getFilterStack());
        }
        if (!this.hasStackFilter() || this.hasStackFilter() && this.getFilterStack().func_190926_b()) {
            this.template.setStackInSlot(9, ItemStack.field_190927_a);
        }
    }

    private void loadFile() {
        NBTTagCompound tag;
        if (!this.printSlot().func_190926_b() && this.printSlot().func_77969_a(new ItemStack(ModItems.MISC_ITEMS, 1, EnumMiscItems.SERVER_FILE.ordinal())) && this.printSlot().func_77942_o() && (tag = this.printSlot().func_77978_p()).func_74764_b("Device") && tag.func_74762_e("Device") == this.servedDevice()) {
            ItemStack temp;
            this.device = tag.func_74762_e("Device");
            if (tag.func_74764_b("Amount")) {
                this.recipeAmount = tag.func_74762_e("Amount");
            }
            if (tag.func_74764_b("Cycle")) {
                this.cycle = tag.func_74767_n("Cycle");
            }
            if (tag.func_74764_b("Recipe")) {
                this.recipeIndex = tag.func_74762_e("Recipe");
            }
            if (tag.func_74764_b("FilterStack") && !(temp = new ItemStack(tag.func_74775_l("FilterStack"))).func_190926_b()) {
                this.filterStack = temp;
            }
            if (tag.func_74764_b("FilterFluid") && (temp = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l("FilterFluid"))) != null) {
                this.filterFluid = temp;
            }
        }
    }

    public void writeFile() {
        if (!this.field_145850_b.field_72995_K && !this.printSlot().func_190926_b() && this.printSlot().func_77969_a(new ItemStack(ModItems.MISC_ITEMS, 1, EnumMiscItems.SERVER_FILE.ordinal()))) {
            if (!this.printSlot().func_77942_o()) {
                this.printSlot().func_77982_d(new NBTTagCompound());
            }
            NBTTagCompound tag = this.printSlot().func_77978_p();
            tag.func_74768_a("Device", this.servedDevice());
            tag.func_74768_a("Recipe", this.getRecipeIndex());
            tag.func_74768_a("Amount", this.getRecipeAmount());
            tag.func_74757_a("Cycle", this.getCycle());
            tag.func_74768_a("Done", this.getRecipeAmount());
            if (this.hasStackFilter()) {
                if (!this.getFilterStack().func_190926_b()) {
                    NBTTagCompound filterstackNBT = new NBTTagCompound();
                    this.getFilterStack().func_77955_b(filterstackNBT);
                    tag.func_74782_a("FilterStack", (NBTBase)filterstackNBT);
                } else if (tag.func_74764_b("FilterStack")) {
                    tag.func_82580_o("FilterStack");
                }
                if (this.getFilterFluid() != null) {
                    NBTTagCompound filterfluidNBT = new NBTTagCompound();
                    this.getFilterFluid().writeToNBT(filterfluidNBT);
                    tag.func_74782_a("FilterFluid", (NBTBase)filterfluidNBT);
                } else if (tag.func_74764_b("FilterFluid")) {
                    tag.func_82580_o("FilterFluid");
                }
            }
        }
    }

    public void applyServer(int i) {
        if (i == EnumServer.LAB_OVEN.ordinal()) {
            if (this.servedDevice() != i) {
                this.device = i;
                this.deviceMax = LabOvenRecipes.lab_oven_recipes.size();
            }
        } else if (i == EnumServer.METAL_ALLOYER.ordinal()) {
            if (this.servedDevice() != i) {
                this.device = i;
                this.deviceMax = MetalAlloyerRecipes.metal_alloyer_recipes.size();
            }
        } else if (i == EnumServer.DEPOSITION.ordinal()) {
            if (this.servedDevice() != i) {
                this.device = i;
                this.deviceMax = DepositionChamberRecipes.deposition_chamber_recipes.size();
            }
        } else if (i == EnumServer.SIZER.ordinal()) {
            if (this.servedDevice() != i) {
                this.device = i;
                this.deviceMax = 16;
            }
        } else if (i == EnumServer.LEACHING.ordinal()) {
            if (this.servedDevice() != i) {
                this.device = i;
                this.deviceMax = 16;
            }
        } else if (i == EnumServer.RETENTION.ordinal()) {
            if (this.servedDevice() != i) {
                this.device = i;
                this.deviceMax = 16;
            }
        } else if (i == EnumServer.CASTING.ordinal()) {
            if (this.servedDevice() != i) {
                this.device = i;
                this.deviceMax = EnumCasting.size();
            }
        } else if (i == EnumServer.REFORMER.ordinal()) {
            if (this.servedDevice() != i) {
                this.device = i;
                this.deviceMax = GasReformerRecipes.gas_reformer_recipes.size();
            }
        } else if (i == EnumServer.EXTRACTOR.ordinal()) {
            if (this.servedDevice() != i) {
                this.device = i;
                this.deviceMax = 16;
            }
        } else if (i == EnumServer.PRECIPITATOR.ordinal()) {
            if (this.servedDevice() != i) {
                this.device = i;
                this.deviceMax = PrecipitationRecipes.precipitation_recipes.size();
            }
        } else {
            this.device = -1;
        }
    }
}

