/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_chemistry.ModItems;
import com.globbypotato.rockhounding_chemistry.enums.EnumMiscItems;
import com.globbypotato.rockhounding_chemistry.enums.EnumServer;
import com.globbypotato.rockhounding_chemistry.machines.recipe.ProfilingBenchRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.ProfilingBenchRecipe;
import com.globbypotato.rockhounding_chemistry.machines.tile.IInternalServer;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEServer;
import com.globbypotato.rockhounding_chemistry.machines.tile.TileStructure;
import com.globbypotato.rockhounding_core.machines.tileentity.MachineStackHandler;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.machines.tileentity.WrappedItemHandler;
import com.globbypotato.rockhounding_core.utils.CoreUtils;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.oredict.OreDictionary;

public class TEProfilingBench
extends TileEntityInv
implements IInternalServer {
    public static final int PURGE_SLOT = 1;
    public int currentCast;
    public ItemStack filter = ItemStack.field_190927_a;
    public static int inputSlots = 1;
    public static int outputSlots = 2;
    public int currentFile = -1;
    public boolean isRepeatable = false;

    public TEProfilingBench() {
        super(inputSlots, outputSlots, 0, 0);
        this.input = new MachineStackHandler(inputSlots, this){

            public ItemStack insertItem(int slot, ItemStack insertingStack, boolean simulate) {
                if (slot == 0 && TEProfilingBench.this.isInputEmpty() && TEProfilingBench.this.isValidInput(insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                return insertingStack;
            }
        };
        this.automationInput = new WrappedItemHandler((IItemHandlerModifiable)this.input, WrappedItemHandler.WriteMode.IN);
        this.output = new MachineStackHandler(outputSlots, this){

            public void validateSlotIndex(int slot) {
                if (TEProfilingBench.this.output.getSlots() < outputSlots) {
                    NonNullList stacksCloned = this.stacks;
                    TEProfilingBench.this.output.setSize(outputSlots);
                    for (ItemStack stack : stacksCloned) {
                        this.stacks.set(slot, (Object)stack);
                    }
                }
                super.validateSlotIndex(slot);
            }
        };
        this.automationOutput = new WrappedItemHandler((IItemHandlerModifiable)this.output, WrappedItemHandler.WriteMode.OUT);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.currentCast = compound.func_74762_e("Casting");
        if (compound.func_74764_b("Filter")) {
            this.filter = new ItemStack(compound.func_74775_l("Filter"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("Casting", this.getCasting());
        if (!this.getFilter().func_190926_b()) {
            NBTTagCompound filterstack = new NBTTagCompound();
            this.filter.func_77955_b(filterstack);
            compound.func_74782_a("Filter", (NBTBase)filterstack);
        }
        return compound;
    }

    public ItemStack inputSlot() {
        return this.input.getStackInSlot(0);
    }

    public ItemStack outputSlot() {
        return this.output.getStackInSlot(0);
    }

    public ItemStack purgeSlot() {
        return this.output.getStackInSlot(1);
    }

    public int getCooktimeMax() {
        return 30;
    }

    public int getGUIHeight() {
        return 200;
    }

    public int getCurrentCast() {
        return this.currentCast;
    }

    public static String getName() {
        return "profiling_bench";
    }

    private static int deviceCode() {
        return EnumServer.CASTING.ordinal();
    }

    public int getCasting() {
        return this.currentCast;
    }

    public boolean isProcessing() {
        return this.canProcess() && this.getCooktime() > 0;
    }

    boolean isInputEmpty() {
        return this.inputSlot().func_190926_b();
    }

    private boolean isOutputEmpty() {
        return this.outputSlot().func_190926_b();
    }

    public ItemStack getFilter() {
        return this.filter;
    }

    public ArrayList<ProfilingBenchRecipe> recipeList() {
        return ProfilingBenchRecipes.profiling_bench_recipes;
    }

    public ProfilingBenchRecipe getRecipeList(int x) {
        return this.recipeList().get(x);
    }

    public boolean isValidInput(ItemStack stack) {
        if (!stack.func_190926_b()) {
            if (!this.getFilter().func_190926_b()) {
                if (this.getFilter().func_77969_a(stack)) {
                    return true;
                }
            } else {
                ArrayList inputOreIDs = CoreUtils.intArrayToList((int[])OreDictionary.getOreIDs((ItemStack)stack));
                for (ProfilingBenchRecipe recipe : this.recipeList()) {
                    if (!(recipe.getType() ? !inputOreIDs.isEmpty() && inputOreIDs.contains(OreDictionary.getOreID((String)recipe.getOredict())) : recipe.getInput().func_77969_a(stack))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public ProfilingBenchRecipe getCurrentRecipe() {
        if (!this.inputSlot().func_190926_b()) {
            for (int x = 0; x < this.recipeList().size(); ++x) {
                ArrayList inputOreIDs = CoreUtils.intArrayToList((int[])OreDictionary.getOreIDs((ItemStack)this.inputSlot()));
                if (!(this.getRecipeList(x).getType() ? inputOreIDs.contains(OreDictionary.getOreID((String)this.getRecipeList(x).getOredict())) && this.getRecipeList(x).getCasting() == this.getCurrentCast() : this.getRecipeList(x).getInput().func_77969_a(this.inputSlot()) && this.getRecipeList(x).getCasting() == this.getCurrentCast())) continue;
                return this.getRecipeList(x);
            }
        }
        return null;
    }

    public boolean isValidRecipe() {
        return this.getCurrentRecipe() != null;
    }

    public TEServer getServer() {
        TEServer server = TileStructure.getServer(this.field_145850_b, this.field_174879_c, this.getFacing(), 1, 0);
        return server != null ? server : null;
    }

    public boolean hasServer() {
        return this.getServer() != null;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.handlePurge();
            this.initializeServer(this.isRepeatable, this.hasServer(), this.getServer(), TEProfilingBench.deviceCode());
            if (!this.inputSlot().func_190926_b() && this.canProcess()) {
                ++this.cooktime;
                if (this.cooktime >= this.getCooktimeMax()) {
                    this.cooktime = 0;
                    this.process();
                }
            }
            this.markDirtyClient();
        }
    }

    private void handlePurge() {
        if (!this.inputSlot().func_190926_b() && !this.getFilter().func_190926_b() && !CoreUtils.isMatchingIngredient((ItemStack)this.inputSlot(), (ItemStack)this.getFilter()) && this.output.canSetOrStack(this.purgeSlot(), this.inputSlot())) {
            this.output.setOrStack(1, this.inputSlot());
            this.input.setStackInSlot(0, ItemStack.field_190927_a);
        }
    }

    private boolean canProcess() {
        return this.isOutputEmpty() && this.isValidRecipe() && this.handleFilter(this.inputSlot(), this.getFilter()) && this.handleServer(this.hasServer(), this.getServer(), this.currentFile);
    }

    private void process() {
        this.output.setStackInSlot(0, this.getCurrentRecipe().getOutput());
        this.input.decrementSlot(0);
        this.updateServer(this.hasServer(), this.getServer(), this.currentFile);
    }

    @Override
    public void loadServerStatus() {
        this.currentFile = -1;
        if (this.getServer().isActive()) {
            for (int x = 0; x < TEServer.FILE_SLOTS.length; ++x) {
                NBTTagCompound tag;
                ItemStack fileSlot = this.getServer().inputSlot(x).func_77946_l();
                if (!fileSlot.func_190926_b() && fileSlot.func_77969_a(new ItemStack(ModItems.MISC_ITEMS, 1, EnumMiscItems.SERVER_FILE.ordinal())) && fileSlot.func_77942_o() && this.isValidFile(tag = fileSlot.func_77978_p()) && tag.func_74762_e("Device") == TEProfilingBench.deviceCode() && tag.func_74762_e("Recipe") < 16 && tag.func_74762_e("Done") > 0) {
                    this.currentCast = tag.func_74762_e("Recipe");
                    this.currentFile = x;
                    if (!tag.func_74764_b("FilterStack")) break;
                    ItemStack temp = new ItemStack(tag.func_74775_l("FilterStack"));
                    if (!this.getFilter().func_190926_b() && this.getFilter().func_77969_a(temp)) break;
                    this.filter = temp;
                    break;
                }
                if (x != TEServer.FILE_SLOTS.length - 1) continue;
                this.resetFiles(this.getServer(), TEProfilingBench.deviceCode());
            }
        }
    }
}

