/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_chemistry.enums.EnumFluid;
import com.globbypotato.rockhounding_chemistry.items.ProbeItems;
import com.globbypotato.rockhounding_chemistry.utils.BaseRecipes;
import com.globbypotato.rockhounding_chemistry.utils.ModUtils;
import com.globbypotato.rockhounding_core.machines.tileentity.MachineStackHandler;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityTank;
import com.globbypotato.rockhounding_core.machines.tileentity.WrappedItemHandler;
import com.globbypotato.rockhounding_core.utils.CoreUtils;
import java.util.List;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerConcatenate;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TEOrbiter
extends TileEntityTank {
    public static int inputSlots = 2;
    public static int templateSlots = 4;
    public FluidTank inputTank = new FluidTank(this.getWasteCapacity()){

        public boolean canFillFluidType(FluidStack fluid) {
            return TEOrbiter.this.canFillWaste(fluid);
        }
    };
    public FluidTank outputTank;
    public static int DRAIN_BUCKET = 1;
    public int xpCount = 0;
    public int xpCountMax = 20000;
    public int numLevel = 1;
    public boolean offScale;

    public TEOrbiter() {
        super(inputSlots, 0, templateSlots, 0);
        this.inputTank.setCanDrain(false);
        this.inputTank.setTileEntity((TileEntity)this);
        this.outputTank = new FluidTank(this.getJuiceCapacity()){

            public boolean canFillFluidType(FluidStack fluid) {
                return TEOrbiter.this.canFillJuice(fluid);
            }

            public boolean canDrainFluidType(FluidStack fluid) {
                return TEOrbiter.this.canDrainJuice(fluid);
            }
        };
        this.outputTank.setTileEntity((TileEntity)this);
        this.input = new MachineStackHandler(inputSlots, (TileEntityInv)this){

            public ItemStack insertItem(int slot, ItemStack insertingStack, boolean simulate) {
                if (slot == 0 && ModUtils.isOrbiterProbe(insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                if (slot == DRAIN_BUCKET && CoreUtils.isEmptyBucket((ItemStack)insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                return insertingStack;
            }
        };
        this.automationInput = new WrappedItemHandler((IItemHandlerModifiable)this.input, WrappedItemHandler.WriteMode.IN);
        this.markDirtyClient();
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inputTank.readFromNBT(compound.func_74775_l("InputTank"));
        this.outputTank.readFromNBT(compound.func_74775_l("OutputTank"));
        this.xpCount = compound.func_74762_e("XPCount");
        this.numLevel = compound.func_74762_e("Levels");
        this.offScale = compound.func_74767_n("Scale");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        NBTTagCompound inputTankNBT = new NBTTagCompound();
        this.inputTank.writeToNBT(inputTankNBT);
        compound.func_74782_a("InputTank", (NBTBase)inputTankNBT);
        NBTTagCompound outputTankNBT = new NBTTagCompound();
        this.outputTank.writeToNBT(outputTankNBT);
        compound.func_74782_a("OutputTank", (NBTBase)outputTankNBT);
        compound.func_74768_a("XPCount", this.getXPCount());
        compound.func_74768_a("Levels", this.getLevels());
        compound.func_74757_a("Scale", this.getOffScale());
        return compound;
    }

    public FluidHandlerConcatenate getCombinedTank() {
        return new FluidHandlerConcatenate(new IFluidHandler[]{this.inputTank, this.outputTank});
    }

    public ItemStack probeSlot() {
        return this.input.getStackInSlot(0);
    }

    public ItemStack drainSlot() {
        return this.input.getStackInSlot(DRAIN_BUCKET);
    }

    public int getGUIHeight() {
        return 200;
    }

    public static String getName() {
        return "orbiter";
    }

    public boolean isComparatorSensible() {
        return false;
    }

    public boolean wasteHasFluid() {
        return this.inputTank.getFluid() != null;
    }

    public FluidStack getWasteFluid() {
        return this.wasteHasFluid() ? this.inputTank.getFluid() : null;
    }

    public int getWasteAmount() {
        return this.wasteHasFluid() ? this.inputTank.getFluidAmount() : 0;
    }

    public boolean juiceHasFluid() {
        return this.outputTank.getFluid() != null;
    }

    public FluidStack getJuiceFluid() {
        return this.juiceHasFluid() ? this.outputTank.getFluid() : null;
    }

    public int getJuiceAmount() {
        return this.juiceHasFluid() ? this.outputTank.getFluidAmount() : 0;
    }

    private boolean hasWaste() {
        return this.wasteHasFluid() && this.getWasteAmount() >= this.wasteAmount();
    }

    private FluidStack waste() {
        return BaseRecipes.getFluid(EnumFluid.TOXIC_WASTE, 5);
    }

    private int wasteAmount() {
        return 5;
    }

    public boolean canFillWaste(FluidStack fluid) {
        return fluid != null && fluid.getFluid() != null && fluid.isFluidEqual(this.waste()) && this.input.canSetOrFillFluid(this.inputTank, this.getWasteFluid(), fluid);
    }

    public boolean xpJuiceExists() {
        return Loader.isModLoaded((String)ModUtils.openblocks_id) && ModUtils.liquidXP() != null;
    }

    public boolean canFillJuice(FluidStack fluid) {
        return this.xpJuiceExists() && fluid != null && fluid.getFluid() != null && fluid.isFluidEqual(ModUtils.liquidXP()) && this.input.canSetOrFillFluid(this.outputTank, this.getJuiceFluid(), fluid);
    }

    private boolean canDrainJuice(FluidStack fluid) {
        return this.xpJuiceExists() && fluid != null && fluid.getFluid() != null && fluid.isFluidEqual(ModUtils.liquidXP());
    }

    public int getJuiceCapacity() {
        return 400000;
    }

    public int getWasteCapacity() {
        return 1000;
    }

    public int getXPCount() {
        return this.xpCount > this.getXPCountMax() ? this.getXPCountMax() : this.xpCount;
    }

    public int getXPCountMax() {
        return this.xpCountMax;
    }

    public int getLevels() {
        return this.numLevel;
    }

    public boolean getOffScale() {
        return this.offScale;
    }

    public int getRadius() {
        return ProbeItems.orbiterUpgrade(this.probeSlot());
    }

    public int getstoredXP() {
        return this.xpJuiceExists() && this.juiceHasFluid() && this.getJuiceAmount() > 0 ? this.getJuiceAmount() / 20 : this.getXPCount();
    }

    public int getstoredXPMax() {
        return this.xpJuiceExists() ? this.getJuiceCapacity() : this.getXPCountMax();
    }

    private boolean canAbsorb(int currJuice) {
        return this.getstoredXP() <= this.getstoredXPMax() - currJuice;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            List orbs;
            this.fillContainer(DRAIN_BUCKET, this.outputTank);
            if (this.isActive() && !(orbs = this.field_145850_b.func_175647_a(EntityXPOrb.class, new AxisAlignedBB(new BlockPos(this.field_174879_c.func_177958_n() - this.getRadius(), this.field_174879_c.func_177956_o() - this.getRadius(), this.field_174879_c.func_177952_p() - this.getRadius()), new BlockPos(this.field_174879_c.func_177958_n() + this.getRadius(), this.field_174879_c.func_177956_o() + this.getRadius(), this.field_174879_c.func_177952_p() + this.getRadius())), EntitySelectors.field_94557_a)).isEmpty() && orbs.size() > 0) {
                for (int i = 0; i < orbs.size(); ++i) {
                    EntityXPOrb orb = (EntityXPOrb)orbs.get(i);
                    int currJuice = orb.func_70526_d();
                    int luckyOrb = this.rand.nextInt(2);
                    if (this.hasWaste() && luckyOrb == 0) {
                        currJuice *= 2;
                    }
                    if (!this.canAbsorb(currJuice)) continue;
                    if (luckyOrb == 0 && this.input.canDrainFluid(this.getWasteFluid(), this.waste())) {
                        this.input.drainOrCleanFluid(this.inputTank, this.wasteAmount(), true);
                    }
                    this.xpCount += currJuice;
                    int xpJuice = 20 * currJuice;
                    if (this.xpJuiceExists() && this.output.canSetOrAddFluid(this.outputTank, this.getJuiceFluid(), ModUtils.liquidXP(), xpJuice)) {
                        this.output.setOrFillFluid(this.outputTank, ModUtils.liquidXP(), xpJuice);
                        this.xpCount -= currJuice;
                    }
                    orb.func_70106_y();
                }
            }
            if (this.xpJuiceExists() && this.getXPCount() > 0) {
                for (int x = 0; x < this.getXPCount(); ++x) {
                    if (!this.output.canSetOrAddFluid(this.outputTank, this.getJuiceFluid(), ModUtils.liquidXP(), 20)) continue;
                    this.output.setOrFillFluid(this.outputTank, ModUtils.liquidXP(), 20);
                    --this.xpCount;
                    this.markDirtyClient();
                }
            }
            this.markDirtyClient();
        }
    }

    public int calculateRetrievedXP(EntityPlayer player, int offset) {
        int exp = 0;
        if (!player.func_130014_f_().field_72995_K) {
            for (int i = player.field_71068_ca; i < player.field_71068_ca + this.getLevels() + offset; ++i) {
                exp += this.xpBarCap(i);
            }
        }
        return exp;
    }

    public void retrieveXP(EntityPlayer player) {
        if (!player.func_130014_f_().field_72995_K) {
            int required = this.calculateRetrievedXP(player, 0);
            int xpJuice = required * 20;
            if (this.xpJuiceExists()) {
                if (this.juiceHasFluid() && this.getJuiceAmount() >= xpJuice) {
                    player.func_71023_q(required);
                    this.output.drainOrCleanFluid(this.outputTank, xpJuice, true);
                }
            } else if (this.getXPCount() >= required) {
                player.func_71023_q(required);
                this.xpCount -= required;
            }
            this.offScale = this.calculateRetrievedXP(player, 0) > this.getstoredXP();
        }
    }

    public int xpBarCap(int levels) {
        if (levels >= 30) {
            return 112 + (levels - 30) * 9;
        }
        return levels >= 15 ? 37 + (levels - 15) * 5 : 7 + levels * 2;
    }
}

