/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_chemistry.ModItems;
import com.globbypotato.rockhounding_chemistry.enums.EnumElements;
import com.globbypotato.rockhounding_chemistry.enums.EnumMiscItems;
import com.globbypotato.rockhounding_chemistry.enums.EnumServer;
import com.globbypotato.rockhounding_chemistry.handlers.ModConfig;
import com.globbypotato.rockhounding_chemistry.machines.recipe.MaterialCabinetRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.MetalAlloyerRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.MaterialCabinetRecipe;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.MetalAlloyerRecipe;
import com.globbypotato.rockhounding_chemistry.machines.tile.IInternalServer;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEElementsCabinetBase;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEMaterialCabinetBase;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEPowerGenerator;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEServer;
import com.globbypotato.rockhounding_chemistry.machines.tile.TileStructure;
import com.globbypotato.rockhounding_chemistry.utils.BaseRecipes;
import com.globbypotato.rockhounding_chemistry.utils.ModUtils;
import com.globbypotato.rockhounding_core.machines.tileentity.MachineStackHandler;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.machines.tileentity.WrappedItemHandler;
import com.globbypotato.rockhounding_core.utils.CoreUtils;
import java.util.ArrayList;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TEMetalAlloyer
extends TileEntityInv
implements IInternalServer {
    public static int inputSlots = 1;
    public static int outputSlots = 1;
    public static int templateSlots = 4;
    public static int upgradeSlots = 1;
    public static final int PATTERN_SLOT = 0;
    public static final int PREVIEW_SLOT = 3;
    public static final int SPEED_SLOT = 0;
    public int currentFile = -1;
    public boolean isRepeatable;
    public MetalAlloyerRecipe dummyRecipe;

    public TEMetalAlloyer() {
        super(inputSlots, outputSlots, templateSlots, upgradeSlots);
        this.input = new MachineStackHandler(inputSlots, this){

            public ItemStack insertItem(int slot, ItemStack insertingStack, boolean simulate) {
                if (slot == 0 && CoreUtils.hasConsumable((ItemStack)BaseRecipes.ingot_pattern, (ItemStack)insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                return insertingStack;
            }
        };
        this.automationInput = new WrappedItemHandler((IItemHandlerModifiable)this.input, WrappedItemHandler.WriteMode.IN);
        this.upgrade = new MachineStackHandler(upgradeSlots, this){

            public ItemStack insertItem(int slot, ItemStack insertingStack, boolean simulate) {
                if (slot == 0 && ModUtils.isValidSpeedUpgrade(insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                return insertingStack;
            }
        };
        this.automationUpgrade = new WrappedItemHandler((IItemHandlerModifiable)this.upgrade, WrappedItemHandler.WriteMode.IN);
    }

    public ItemStack speedSlot() {
        return this.upgrade.getStackInSlot(0);
    }

    public ItemStack patternSlot() {
        return this.input.getStackInSlot(0);
    }

    public ItemStack outputSlot() {
        return this.output.getStackInSlot(0);
    }

    public ItemStack previewSlot() {
        return this.template.getStackInSlot(3);
    }

    public int getGUIHeight() {
        return 200;
    }

    public static String getName() {
        return "metal_alloyer";
    }

    public int speedFactor() {
        return ModUtils.isValidSpeedUpgrade(this.speedSlot()) ? ModUtils.speedUpgrade(this.speedSlot()) : 1;
    }

    public int getCooktimeMax() {
        return ModUtils.isValidSpeedUpgrade(this.speedSlot()) ? ModConfig.speedAlloyer / ModUtils.speedUpgrade(this.speedSlot()) : ModConfig.speedAlloyer;
    }

    private static int deviceCode() {
        return EnumServer.METAL_ALLOYER.ordinal();
    }

    public EnumFacing poweredFacing() {
        return this.getFacing().func_176734_d();
    }

    public ArrayList<MetalAlloyerRecipe> recipeList() {
        return MetalAlloyerRecipes.metal_alloyer_recipes;
    }

    public MetalAlloyerRecipe getRecipeList(int x) {
        return this.recipeList().get(x);
    }

    public ArrayList<MaterialCabinetRecipe> materialList() {
        return MaterialCabinetRecipes.material_cabinet_recipes;
    }

    public MaterialCabinetRecipe getMaterialList(int x) {
        return this.materialList().get(x);
    }

    public MetalAlloyerRecipe getCurrentRecipe() {
        if (this.isActive() && this.isValidPreset()) {
            return this.isFullRecipe(this.getRecipeList(this.getRecipeIndex()));
        }
        return null;
    }

    public MetalAlloyerRecipe getDummyRecipe() {
        return this.dummyRecipe;
    }

    private MetalAlloyerRecipe isFullRecipe(MetalAlloyerRecipe recipe) {
        int recipeSize = recipe.getInputs().size();
        int ingrCount = 0;
        if (this.hasCabinet() && this.hasMaterial()) {
            for (int ingredient = 0; ingredient < recipeSize; ++ingredient) {
                int element;
                String ingrOredict = recipe.getInputs().get(ingredient);
                int ingrQuantity = recipe.getQuantities().get(ingredient);
                for (element = 0; element < this.getCabinet().elementList.length; ++element) {
                    if (!EnumElements.getDust(element).matches(ingrOredict) || ingrQuantity > this.getCabinet().elementList[element]) continue;
                    ++ingrCount;
                }
                for (element = 0; element < this.materialList().size(); ++element) {
                    if (!this.getMaterialList(element).getOredict().matches(ingrOredict) || ingrQuantity > this.getMaterial().elementList[element]) continue;
                    ++ingrCount;
                }
            }
        }
        return ingrCount == recipeSize ? recipe : null;
    }

    public boolean isValidRecipe() {
        return this.getDummyRecipe() != null;
    }

    public boolean isValidPreset() {
        return this.getRecipeIndex() > -1 && this.getRecipeIndex() < this.recipeList().size();
    }

    public ItemStack recipeOutput() {
        return this.isValidRecipe() ? this.getDummyRecipe().getOutput() : ItemStack.field_190927_a;
    }

    public TEPowerGenerator getEngine() {
        TEPowerGenerator engine = TileStructure.getEngine(this.field_145850_b, this.field_174879_c, this.isFacingAt(90), 1, 0);
        return engine != null ? engine : null;
    }

    public boolean hasEngine() {
        return this.getEngine() != null;
    }

    public boolean hasFuelPower() {
        return this.hasEngine() ? this.getEngine().getPower() > 0 : false;
    }

    private void drainPower() {
        --this.getEngine().powerCount;
        this.getEngine().markDirtyClient();
    }

    public TEElementsCabinetBase getCabinet() {
        TEElementsCabinetBase cabinet;
        BlockPos cabinetPos = this.field_174879_c.func_177967_a(this.getFacing(), 1);
        TileEntity te = this.field_145850_b.func_175625_s(cabinetPos);
        if (this.field_145850_b.func_180495_p(cabinetPos) != null && te instanceof TEElementsCabinetBase && (cabinet = (TEElementsCabinetBase)te).getFacing() == this.getFacing().func_176734_d()) {
            return cabinet;
        }
        return null;
    }

    public boolean hasCabinet() {
        return this.getCabinet() != null;
    }

    public TEMaterialCabinetBase getMaterial() {
        TEMaterialCabinetBase cabinet;
        BlockPos cabinetPos = this.field_174879_c.func_177967_a(this.getFacing(), 1).func_177967_a(this.isFacingAt(270), 1);
        TileEntity te = this.field_145850_b.func_175625_s(cabinetPos);
        if (this.field_145850_b.func_180495_p(cabinetPos) != null && te instanceof TEMaterialCabinetBase && (cabinet = (TEMaterialCabinetBase)te).getFacing() == this.getFacing().func_176734_d()) {
            return cabinet;
        }
        return null;
    }

    public boolean hasMaterial() {
        return this.getMaterial() != null;
    }

    public TEServer getServer() {
        TEServer server = TileStructure.getServer(this.field_145850_b, this.field_174879_c, this.isFacingAt(270), 1, 0);
        return server != null ? server : null;
    }

    public boolean hasServer() {
        return this.getServer() != null;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.doPreset();
            this.initializeServer(this.isRepeatable, this.hasServer(), this.getServer(), TEMetalAlloyer.deviceCode());
            if (this.getDummyRecipe() == null) {
                this.dummyRecipe = this.getCurrentRecipe();
                this.cooktime = 0;
            }
            if (this.canProcess()) {
                ++this.cooktime;
                this.drainPower();
                if (this.getCooktime() >= this.getCooktimeMax()) {
                    this.cooktime = 0;
                    this.process();
                }
                this.markDirtyClient();
            } else {
                this.tickOff();
            }
        }
    }

    private void doPreset() {
        if (this.hasEngine()) {
            if (!this.getEngine().enablePower) {
                this.getEngine().enablePower = true;
                this.getEngine().markDirtyClient();
            }
            if (this.getEngine().enableRedstone) {
                this.getEngine().enableRedstone = false;
                this.getEngine().markDirtyClient();
            }
        }
    }

    private boolean canProcess() {
        return this.isActive() && this.isValidRecipe() && this.hasFuelPower() && this.hasPattern() && this.canOutput() && this.handleServer(this.hasServer(), this.getServer(), this.currentFile);
    }

    private boolean canOutput() {
        return this.output.canSetOrStack(this.outputSlot(), this.recipeOutput());
    }

    private void process() {
        if (this.isValidRecipe()) {
            this.output.setOrStack(0, this.getDummyRecipe().getOutput().func_77946_l());
            int unbreakingLevel = CoreUtils.getEnchantmentLevel((Enchantment)Enchantments.field_185307_s, (ItemStack)this.patternSlot());
            this.input.damageUnbreakingSlot(unbreakingLevel, 0);
            for (int ingredient = 0; ingredient < this.getDummyRecipe().getInputs().size(); ++ingredient) {
                int element;
                String ingrOredict = this.getDummyRecipe().getInputs().get(ingredient);
                int ingrQuantity = this.getDummyRecipe().getQuantities().get(ingredient);
                for (element = 0; element < this.getCabinet().elementList.length; ++element) {
                    if (!EnumElements.getDust(element).matches(ingrOredict)) continue;
                    int n = element;
                    this.getCabinet().elementList[n] = this.getCabinet().elementList[n] - ingrQuantity;
                }
                for (element = 0; element < this.materialList().size(); ++element) {
                    if (!this.getMaterialList(element).getOredict().matches(ingrOredict)) continue;
                    int n = element;
                    this.getMaterial().elementList[n] = this.getMaterial().elementList[n] - ingrQuantity;
                }
            }
            this.getCabinet().markDirtyClient();
            this.getMaterial().markDirtyClient();
            this.updateServer(this.hasServer(), this.getServer(), this.currentFile);
        }
        this.dummyRecipe = null;
    }

    private boolean hasPattern() {
        return CoreUtils.hasConsumable((ItemStack)BaseRecipes.ingot_pattern, (ItemStack)this.input.getStackInSlot(0));
    }

    public void showPreview() {
        if (this.isValidPreset()) {
            ItemStack previewStack = this.getRecipeList(this.getRecipeIndex()).getOutput();
            if (!this.template.getStackInSlot(3).func_77969_a(previewStack)) {
                previewStack.func_190920_e(1);
                this.template.setStackInSlot(3, previewStack);
            }
        } else if (!this.template.getStackInSlot(3).func_190926_b()) {
            this.template.setStackInSlot(3, ItemStack.field_190927_a);
        }
    }

    @Override
    public void loadServerStatus() {
        this.currentFile = -1;
        if (this.getServer().isActive()) {
            for (int x = 0; x < TEServer.FILE_SLOTS.length; ++x) {
                NBTTagCompound tag;
                ItemStack fileSlot = this.getServer().inputSlot(x).func_77946_l();
                if (!fileSlot.func_190926_b() && fileSlot.func_77969_a(new ItemStack(ModItems.MISC_ITEMS, 1, EnumMiscItems.SERVER_FILE.ordinal())) && fileSlot.func_77942_o() && this.isValidFile(tag = fileSlot.func_77978_p()) && tag.func_74762_e("Device") == TEMetalAlloyer.deviceCode() && tag.func_74762_e("Recipe") < this.recipeList().size() && tag.func_74762_e("Done") > 0) {
                    if (this.recipeIndex != tag.func_74762_e("Recipe")) {
                        this.recipeIndex = tag.func_74762_e("Recipe");
                        this.markDirtyClient();
                    }
                    if (this.currentFile == x) break;
                    this.currentFile = x;
                    this.markDirtyClient();
                    break;
                }
                if (x != TEServer.FILE_SLOTS.length - 1) continue;
                this.resetFiles(this.getServer(), TEMetalAlloyer.deviceCode());
            }
        }
    }
}

