/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_chemistry.ModItems;
import com.globbypotato.rockhounding_chemistry.enums.EnumMiscItems;
import com.globbypotato.rockhounding_chemistry.handlers.ModConfig;
import com.globbypotato.rockhounding_chemistry.machines.recipe.GasifierPlantRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.GasifierPlantRecipe;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEGasPressurizer;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEGasifierBurner;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEGasifierTank;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEParticulateCollector;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEPowerGenerator;
import com.globbypotato.rockhounding_chemistry.machines.tile.TileStructure;
import com.globbypotato.rockhounding_chemistry.machines.tile.TileVessel;
import com.globbypotato.rockhounding_chemistry.utils.ModUtils;
import com.globbypotato.rockhounding_core.machines.tileentity.MachineStackHandler;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.machines.tileentity.WrappedItemHandler;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TEGasifierCooler
extends TileEntityInv {
    public static int upgradeSlots = 2;
    public static final int SPEED_SLOT = 0;
    public static final int CASING_SLOT = 1;
    public int temperature = 300;
    public GasifierPlantRecipe dummyRecipe;
    ItemStack refractory_upd = new ItemStack(ModItems.MISC_ITEMS, 1, EnumMiscItems.REFRACTORY_CASING.ordinal());

    public TEGasifierCooler() {
        super(0, 0, 0, upgradeSlots);
        this.upgrade = new MachineStackHandler(upgradeSlots, this){

            public void validateSlotIndex(int slot) {
                if (TEGasifierCooler.this.upgrade.getSlots() < upgradeSlots) {
                    NonNullList stacksCloned = this.stacks;
                    TEGasifierCooler.this.upgrade.setSize(upgradeSlots);
                    for (ItemStack stack : stacksCloned) {
                        this.stacks.set(slot, (Object)stack);
                    }
                }
                super.validateSlotIndex(slot);
            }

            public ItemStack insertItem(int slot, ItemStack insertingStack, boolean simulate) {
                if (slot == 0 && ModUtils.isValidSpeedUpgrade(insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                if (slot == 1 && ItemStack.func_179545_c((ItemStack)insertingStack, (ItemStack)TEGasifierCooler.this.refractory_upd)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                return insertingStack;
            }
        };
        this.automationUpgrade = new WrappedItemHandler((IItemHandlerModifiable)this.upgrade, WrappedItemHandler.WriteMode.IN);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.temperature = compound.func_74762_e("Temperature");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("Temperature", this.getTemperature());
        return compound;
    }

    public ItemStack speedSlot() {
        return this.upgrade.getStackInSlot(0);
    }

    public ItemStack casingSlot() {
        return this.upgrade.getStackInSlot(1);
    }

    public static ArrayList<GasifierPlantRecipe> recipeList() {
        return GasifierPlantRecipes.gasifier_plant_recipes;
    }

    public static GasifierPlantRecipe getRecipeList(int x) {
        return TEGasifierCooler.recipeList().get(x);
    }

    public GasifierPlantRecipe getCurrentRecipe() {
        if (this.hasFluids()) {
            for (int x = 0; x < TEGasifierCooler.recipeList().size(); ++x) {
                if (!this.isMatchingInput(x) || !this.isMatchingReactant(x)) continue;
                return TEGasifierCooler.getRecipeList(x);
            }
        }
        return null;
    }

    public GasifierPlantRecipe getDummyRecipe() {
        return this.dummyRecipe;
    }

    private boolean hasFluids() {
        return this.hasSlurry() && this.hasReactant();
    }

    private boolean isMatchingInput(int x) {
        return TEGasifierCooler.getRecipeList(x).getInput() != null && TEGasifierCooler.getRecipeList(x).getInput().isFluidEqual(this.getSlurry());
    }

    private boolean isMatchingReactant(int x) {
        return TEGasifierCooler.getRecipeList(x).getReactant() != null && TEGasifierCooler.getRecipeList(x).getReactant().isFluidEqual(this.getReactant());
    }

    public boolean isValidRecipe() {
        return this.getDummyRecipe() != null;
    }

    public FluidStack getRecipeSlurry() {
        return this.isValidRecipe() ? this.getDummyRecipe().getInput() : null;
    }

    private int getDrainSlurry() {
        return this.isValidRecipe() ? this.getRecipeSlurry().amount * this.speedFactor() : 0;
    }

    public FluidStack getRecipeReactant() {
        return this.isValidRecipe() ? this.getDummyRecipe().getReactant() : null;
    }

    private int getDrainReactant() {
        return this.isValidRecipe() ? this.getRecipeReactant().amount * this.speedFactor() : 0;
    }

    public FluidStack getRecipeOutput() {
        return this.isValidRecipe() ? this.getDummyRecipe().getOutput() : null;
    }

    private int getProducedGas() {
        return this.isValidRecipe() ? this.getRecipeOutput().amount * this.speedFactor() : 0;
    }

    public int getThreashold() {
        return this.isValidRecipe() ? this.getDummyRecipe().getTemperature() : 0;
    }

    public ItemStack getMainSlag() {
        return this.isValidRecipe() ? this.getDummyRecipe().getMainSlag() : ItemStack.field_190927_a;
    }

    private boolean hasMainSlag() {
        return !this.getMainSlag().func_190926_b();
    }

    public ItemStack getAltSlag() {
        return this.isValidRecipe() ? this.getDummyRecipe().getAltSlag() : ItemStack.field_190927_a;
    }

    private boolean hasAltSlag() {
        return !this.getAltSlag().func_190926_b();
    }

    public int getGUIHeight() {
        return 200;
    }

    public static String getName() {
        return "gasifier_cooler";
    }

    public int speedFactor() {
        return ModUtils.isValidSpeedUpgrade(this.speedSlot()) ? ModUtils.speedUpgrade(this.speedSlot()) : 1;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public int getTemperatureMax() {
        return 2000;
    }

    public int getCooktimeMax() {
        return this.hasRefractory() ? 30 : 80;
    }

    public int getCoolingChance() {
        return this.hasRefractory() ? 60 : 20;
    }

    private int heatingFactor() {
        return this.hasRefractory() ? 3 : 1;
    }

    private int coolingFactor() {
        return this.hasRefractory() ? 1 : 3;
    }

    public int powerConsume() {
        return this.hasRefractory() ? 100 : 300;
    }

    private int chamberStress() {
        return 4000 / this.speedFactor();
    }

    public boolean hasRefractory() {
        return !this.casingSlot().func_190926_b() && ItemStack.func_179545_c((ItemStack)this.casingSlot(), (ItemStack)this.refractory_upd);
    }

    public TEPowerGenerator getEngine() {
        TEPowerGenerator engine = TileStructure.getEngine(this.field_145850_b, this.field_174879_c.func_177984_a(), this.getFacing(), 1, 0);
        return engine != null ? engine : null;
    }

    public boolean hasEngine() {
        return this.getEngine() != null;
    }

    public void drainPower() {
        this.getEngine().powerCount -= this.powerConsume();
        this.getEngine().markDirtyClient();
    }

    public int getEnginePower() {
        return this.hasEngine() ? this.getEngine().getPower() : 0;
    }

    public BlockPos slurryPos() {
        return this.field_174879_c.func_177967_a(EnumFacing.UP, 2);
    }

    public TEGasifierTank getSlurryTank() {
        TileEntity te = this.field_145850_b.func_175625_s(this.slurryPos());
        if (this.field_145850_b.func_180495_p(this.slurryPos()) != null && te instanceof TEGasifierTank) {
            TEGasifierTank tank = (TEGasifierTank)te;
            return tank;
        }
        return null;
    }

    public boolean hasTank() {
        return this.getSlurryTank() != null;
    }

    public FluidStack getSlurry() {
        return this.hasTank() ? this.getSlurryTank().inputTank.getFluid() : null;
    }

    public boolean hasSlurry() {
        return this.getSlurry() != null;
    }

    public BlockPos burnerPos() {
        return this.field_174879_c.func_177967_a(EnumFacing.UP, 1);
    }

    public TEGasifierBurner getBurner() {
        TEGasifierBurner tank;
        TileEntity te = this.field_145850_b.func_175625_s(this.burnerPos());
        if (this.field_145850_b.func_180495_p(this.burnerPos()) != null && te instanceof TEGasifierBurner && (tank = (TEGasifierBurner)te).getFacing() == this.getFacing()) {
            return tank;
        }
        return null;
    }

    public boolean hasBurner() {
        return this.getBurner() != null;
    }

    public boolean hasReactant() {
        return this.hasBurner() && this.getBurner().inputTank.getFluid() != null;
    }

    public FluidStack getReactant() {
        return this.hasReactant() ? this.getBurner().inputTank.getFluid() : null;
    }

    public TEGasPressurizer getPressurizer() {
        TEGasPressurizer pressurizer = TileStructure.getPressurizer(this.field_145850_b, this.field_174879_c, this.getFacing(), 1, 0);
        return pressurizer != null ? pressurizer : null;
    }

    public boolean hasParts() {
        return this.getPressurizer() != null;
    }

    public TEParticulateCollector getParticulate() {
        TEParticulateCollector vessel = TileStructure.getCollector(this.field_145850_b, this.field_174879_c, this.isFacingAt(90), 1, 0);
        return vessel != null ? vessel : null;
    }

    public boolean hasParticulate() {
        return this.getParticulate() != null;
    }

    public TileVessel getOutTank() {
        TileVessel vessel = TileStructure.getHolder(this.field_145850_b, this.field_174879_c, this.isFacingAt(270), 1, 0);
        return vessel != null ? vessel : null;
    }

    public boolean hasOutTank() {
        return this.getOutTank() != null;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.doPreset();
            if (this.getTemperature() >= 303 && this.rand.nextInt(this.getCoolingChance()) == 0) {
                this.temperature -= this.coolingFactor();
                this.markDirtyClient();
            }
            if (this.getDummyRecipe() == null) {
                this.dummyRecipe = this.getCurrentRecipe();
                this.cooktime = 0;
            } else if (!this.hasFluids()) {
                this.dummyRecipe = null;
            }
            if (this.isValidRecipe()) {
                if (this.getTemperature() < this.getThreashold() + 10 && this.getEnginePower() >= this.powerConsume()) {
                    this.temperature += this.heatingFactor();
                    this.drainPower();
                    this.markDirtyClient();
                }
                if (this.hasParticulate()) {
                    this.getParticulate().handlePreview(this.hasMainSlag(), this.getMainSlag(), this.hasAltSlag(), this.getAltSlag());
                }
            }
            if (this.canProcess()) {
                ++this.cooktime;
                if (this.getCooktime() >= this.getCooktimeMax()) {
                    this.cooktime = 0;
                    this.process();
                }
                this.markDirtyClient();
            } else {
                this.tickOff();
            }
        }
    }

    private void doPreset() {
        if (this.hasEngine()) {
            if (!this.getEngine().enablePower) {
                this.getEngine().enablePower = true;
                this.getEngine().markDirtyClient();
            }
            if (this.getEngine().enableRedstone) {
                this.getEngine().enableRedstone = false;
                this.getEngine().markDirtyClient();
            }
        }
    }

    private boolean canProcess() {
        return this.isValidRecipe() && this.hasParts() && this.getTemperature() >= this.getThreashold() && this.hasEnoughSlurry() && this.hasEnoughReactant() && this.canStoreOutput();
    }

    private boolean hasEnoughSlurry() {
        return this.hasSlurry() && this.getSlurry().amount >= this.getDrainSlurry();
    }

    private boolean hasEnoughReactant() {
        return this.hasReactant() && this.getReactant().amount >= this.getDrainReactant();
    }

    private boolean canStoreOutput() {
        return this.hasOutTank() && this.output.canSetOrAddFluid(this.getOutTank().inputTank, this.getOutTank().inputTank.getFluid(), this.getRecipeOutput(), this.getProducedGas());
    }

    private void process() {
        if (this.getDummyRecipe() != null && this.getDummyRecipe() == this.getCurrentRecipe()) {
            this.output.setOrFillFluid(this.getOutTank().inputTank, this.getRecipeOutput(), this.getProducedGas());
            this.input.drainOrCleanFluid(this.getBurner().inputTank, this.getDrainReactant(), true);
            this.input.drainOrCleanFluid(this.getSlurryTank().inputTank, this.getDrainSlurry(), true);
            if (this.hasParticulate()) {
                this.getParticulate().handleParticulate(this.hasMainSlag(), ModConfig.burner_main_slag, this.hasAltSlag(), ModConfig.burner_secondary_slag);
            }
            if (this.hasRefractory() && this.rand.nextInt(this.chamberStress()) == 0) {
                this.upgrade.setStackInSlot(1, ItemStack.field_190927_a);
            }
        }
        this.dummyRecipe = null;
    }
}

