/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_chemistry.enums.EnumFluid;
import com.globbypotato.rockhounding_chemistry.machines.tile.TileStructure;
import com.globbypotato.rockhounding_chemistry.machines.tile.TileVessel;
import com.globbypotato.rockhounding_chemistry.utils.BaseRecipes;
import com.globbypotato.rockhounding_core.gas.GasHandlerConcatenate;
import com.globbypotato.rockhounding_core.machines.tileentity.MachineStackHandler;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityPoweredVessel;
import com.globbypotato.rockhounding_core.machines.tileentity.WrappedItemHandler;
import com.globbypotato.rockhounding_core.utils.CoreBasics;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerConcatenate;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TEAirCompressor
extends TileEntityPoweredVessel {
    public static int inputSlots = 1;
    public static int templateSlots = 1;

    public TEAirCompressor() {
        super(inputSlots, 0, templateSlots, 0);
        this.input = new MachineStackHandler(inputSlots, (TileEntityInv)this){

            public ItemStack insertItem(int slot, ItemStack insertingStack, boolean simulate) {
                if (slot == TEAirCompressor.this.fuelID() && TEAirCompressor.this.isGatedPowerSource(insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                return insertingStack;
            }
        };
        this.automationInput = new WrappedItemHandler((IItemHandlerModifiable)this.input, WrappedItemHandler.WriteMode.IN);
    }

    public FluidHandlerConcatenate getCombinedTank() {
        return new FluidHandlerConcatenate(new IFluidHandler[]{this.lavaTank});
    }

    public GasHandlerConcatenate getCombinedGasTank() {
        return new GasHandlerConcatenate(new IFluidHandler[]{this.gasTank});
    }

    public int getGUIHeight() {
        return 200;
    }

    public static String getName() {
        return "air_compressor";
    }

    public int fuelID() {
        return 0;
    }

    public EnumFacing poweredFacing() {
        return EnumFacing.func_176733_a((double)(this.getFacing().func_185119_l() + 90.0f));
    }

    public ItemStack fuelSlot() {
        return this.input.getStackInSlot(this.fuelID());
    }

    public int getCooktimeMax() {
        return 20;
    }

    public TileVessel getVessel() {
        TileVessel vessel = TileStructure.getHolder(this.field_145850_b, this.field_174879_c, this.getFacing(), 1, 0);
        return vessel != null ? vessel : null;
    }

    public boolean hasVessel() {
        return this.getVessel() != null;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.handleSupplies();
            if (this.isActive()) {
                if (this.canCompress()) {
                    this.compress();
                    if (this.getCooktime() >= this.getCooktimeMax()) {
                        this.cooktime = 0;
                    }
                    this.markDirtyClient();
                } else {
                    this.tickOff();
                }
            } else {
                this.tickOff();
            }
        }
    }

    private void handleSupplies() {
        if (!this.fuelSlot().func_190926_b()) {
            if (this.fuelSlot().func_77969_a(CoreBasics.heat_inductor)) {
                this.powerHandler(this.fuelSlot());
                if (this.isActive()) {
                    this.injectFuel();
                }
                this.markDirtyClient();
            } else if (this.isActive()) {
                this.fuelHandler(this.fuelSlot());
            }
        }
        if (this.isActive() && this.isInductionActive()) {
            this.injectFuel();
        }
        if (this.isActive()) {
            this.lavaHandler();
            this.gasHandler();
        }
    }

    private boolean canCompress() {
        return this.getPower() > 0 && this.canFillAir() && this.output.canSetOrFillFluid(this.getVessel().inputTank, this.getVessel().inputTank.getFluid(), TEAirCompressor.compressedAir());
    }

    private boolean canFillAir() {
        return this.hasVessel() ? this.getVessel().canFillFiltered(TEAirCompressor.compressedAir()) : false;
    }

    private void compress() {
        this.output.setOrFillFluid(this.getVessel().inputTank, TEAirCompressor.compressedAir());
        ++this.cooktime;
        this.drainPower();
    }

    private static FluidStack compressedAir() {
        return BaseRecipes.getFluid(EnumFluid.COMPRESSED_AIR, 100);
    }

    public void drainPower() {
        --this.powerCount;
    }
}

