/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_chemistry.fluids.ModFluids;
import com.globbypotato.rockhounding_chemistry.handlers.ModConfig;
import com.globbypotato.rockhounding_chemistry.machines.recipe.PollutantRecipes;
import java.util.ArrayList;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidTank;

public interface IToxic {
    default public ArrayList<FluidTank> hazardList() {
        ArrayList<FluidTank> tanks = new ArrayList<FluidTank>();
        return tanks;
    }

    default public void handleToxic(World world, BlockPos pos) {
        if (ModConfig.enableHazard && world.field_73012_v.nextInt(ModConfig.hazardChance) == 0) {
            for (FluidTank tank : this.hazardList()) {
                if (!this.isHazardousFluid(tank)) continue;
                int xRad = world.field_73012_v.nextInt(9) - 4;
                int yRad = world.field_73012_v.nextInt(9) - 4;
                int zRad = world.field_73012_v.nextInt(9) - 4;
                BlockPos toxicPos = new BlockPos(pos.func_177958_n() + xRad, pos.func_177956_o() + yRad, pos.func_177952_p() + zRad);
                if (!world.func_175623_d(toxicPos) || !this.hasSolidBase(world, toxicPos, xRad, yRad, zRad)) continue;
                world.func_184133_a(null, pos, SoundEvents.field_187904_gd, SoundCategory.AMBIENT, 1.0f, 2.0f);
                world.func_175656_a(toxicPos, ModFluids.TOXIC_SLUDGE.getBlock().func_176203_a(0));
                world.func_184133_a(null, pos, SoundEvents.field_187917_gq, SoundCategory.AMBIENT, 0.4f, 0.2f);
                break;
            }
        }
    }

    default public boolean isHazardousFluid(FluidTank tank) {
        return tank.getFluid() != null && !tank.getFluid().getFluid().isGaseous() && PollutantRecipes.pollutant_fluids.size() > 0 && PollutantRecipes.pollutant_fluids.contains(tank.getFluid()) && tank.getFluidAmount() >= 1000;
    }

    default public boolean hasSolidBase(World world, BlockPos toxicPos, int xRad, int yRad, int zRad) {
        if (xRad >= -1 && xRad <= 1 && yRad >= -1 && yRad <= 1 && zRad >= -1 && zRad <= 1) {
            return true;
        }
        return world.func_180495_p(toxicPos.func_177977_b()).isSideSolid((IBlockAccess)world, toxicPos, EnumFacing.UP);
    }
}

