/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines;

import com.globbypotato.rockhounding_chemistry.ModItems;
import com.globbypotato.rockhounding_chemistry.Rhchemistry;
import com.globbypotato.rockhounding_chemistry.enums.EnumMachinesE;
import com.globbypotato.rockhounding_chemistry.enums.EnumMiscItems;
import com.globbypotato.rockhounding_chemistry.machines.io.MachineIO;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEBufferTank;
import com.globbypotato.rockhounding_chemistry.machines.tile.TECatalystRegen;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEDisposer;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEExhaustionValve;
import com.globbypotato.rockhounding_chemistry.machines.tile.TELaserEmitter;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEPrecipitationChamber;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEPrecipitationController;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEPrecipitationReactor;
import com.globbypotato.rockhounding_chemistry.machines.tile.TESlurryDrum;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEStirredTankBase;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEStirredTankOut;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEStirredTankTop;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEWaterPump;
import com.globbypotato.rockhounding_chemistry.machines.tile.TileTank;
import com.globbypotato.rockhounding_core.enums.EnumFluidNbt;
import com.globbypotato.rockhounding_core.machines.tileentity.IFluidHandlingTile;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.utils.CoreUtils;
import com.globbypotato.rockhounding_core.utils.MachinesUtils;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;

public class MachinesE
extends MachineIO {
    public static PropertyEnum VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumMachinesE.class);
    public static final AxisAlignedBB LASER_EMITTER_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.6, 1.0);
    public static final AxisAlignedBB EXHAUSTION_VALVE_AABB = new AxisAlignedBB(0.2, 0.0, 0.2, 0.8, 0.7, 0.8);
    public static final AxisAlignedBB SLURRY_DRUM_AABB = new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 1.0, 0.9);
    public static final AxisAlignedBB BUFFER_TANK_AABB = new AxisAlignedBB(0.2, 0.0, 0.2, 0.8, 1.0, 0.8);
    ItemStack compressor = new ItemStack(ModItems.MISC_ITEMS, 1, EnumMiscItems.COMPRESSOR.ordinal());
    ItemStack iron_impeller = new ItemStack(ModItems.MISC_ITEMS, 1, EnumMiscItems.IRON_IMPELLER.ordinal());
    ItemStack aluminum_impeller = new ItemStack(ModItems.MISC_ITEMS, 1, EnumMiscItems.ALUMINUM_IMPELLER.ordinal());
    ItemStack stellite_impeller = new ItemStack(ModItems.MISC_ITEMS, 1, EnumMiscItems.STELLITE_IMPELLER.ordinal());

    public MachinesE(String name) {
        super(name, Material.field_151573_f, EnumMachinesE.getNames(), 3.0f, 5.0f, SoundType.field_185852_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumMachinesE.values()[0])).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumMachinesE.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumMachinesE)((Object)state.func_177229_b((IProperty)VARIANT))).ordinal();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityInv tile = (TileEntityInv)world.func_175625_s(pos);
        return state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)tile.facing));
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT, FACING});
    }

    @Override
    public boolean hiddenParts(int meta) {
        return meta == EnumMachinesE.STIRRED_TANK_TOP.ordinal() || meta == EnumMachinesE.PRECIPITATION_CONTROLLER.ordinal();
    }

    @Override
    public boolean baseParts(int meta) {
        return meta == EnumMachinesE.STIRRED_TANK_BASE.ordinal() || meta == EnumMachinesE.PRECIPITATION_CHAMBER.ordinal();
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        int meta = stack.func_77952_i();
        EnumFacing isFacing = EnumFacing.func_82600_a((int)2);
        world.func_180501_a(pos, state.func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumMachinesE.values()[meta])).func_177226_a((IProperty)FACING, (Comparable)isFacing), 2);
        TileEntity te = world.func_175625_s(pos);
        if (world.func_175625_s(pos) != null) {
            TileEntityInv reactor;
            if (te instanceof TEStirredTankBase) {
                reactor = (TEStirredTankBase)world.func_175625_s(pos);
                this.setOrDropBlock(world, state, pos, reactor.getFacing(), placer, EnumMachinesE.STIRRED_TANK_TOP);
            }
            if (te instanceof TEPrecipitationChamber) {
                reactor = (TEPrecipitationChamber)world.func_175625_s(pos);
                this.setOrDropBlock(world, state, pos, reactor.getFacing(), placer, EnumMachinesE.PRECIPITATION_CONTROLLER);
            }
            if (te instanceof TEWaterPump) {
                MachinesE.restoreWaterPumpNBT(stack, te);
            }
            if (te instanceof TEDisposer) {
                MachinesE.restoreDisposerNBT(stack, te);
            }
            if (te instanceof TESlurryDrum) {
                MachinesE.restoreSlurryDrumNBT(stack, te);
            }
            if (te instanceof TEBufferTank) {
                MachinesE.restoreBufferTankNBT(stack, te);
            }
            if (te instanceof TEStirredTankOut) {
                MachinesE.restoreStirredTankOutNBT(stack, te);
            }
        }
    }

    @Override
    public void checkFullBlocks(World world, BlockPos pos, IBlockState state) {
        int meta = state.func_177230_c().func_176201_c(state);
        if (meta == EnumMachinesE.STIRRED_TANK_BASE.ordinal()) {
            this.checkTopBlocks(world, world.func_180495_p(pos), world.func_180495_p(pos.func_177984_a()), pos);
        }
        if (meta == EnumMachinesE.STIRRED_TANK_TOP.ordinal()) {
            MachinesE.checkBaseBlocks(world, world.func_180495_p(pos.func_177977_b()), pos);
        }
        if (meta == EnumMachinesE.PRECIPITATION_CHAMBER.ordinal()) {
            this.checkTopBlocks(world, world.func_180495_p(pos), world.func_180495_p(pos.func_177984_a()), pos);
        }
        if (meta == EnumMachinesE.PRECIPITATION_CONTROLLER.ordinal()) {
            MachinesE.checkBaseBlocks(world, world.func_180495_p(pos.func_177977_b()), pos);
        }
    }

    private void setOrDropBlock(World world, IBlockState state, BlockPos pos, EnumFacing facing, EntityLivingBase placer, EnumMachinesE prop) {
        if (world.func_180495_p(pos.func_177984_a()).func_177230_c().isAir(world.func_180495_p(pos.func_177984_a()), (IBlockAccess)world, pos)) {
            world.func_180501_a(pos.func_177984_a(), this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)prop)).func_177226_a((IProperty)FACING, (Comparable)facing), 2);
            TileEntityInv top = (TileEntityInv)world.func_175625_s(pos.func_177984_a());
            top.facing = facing.ordinal();
        } else {
            int meta = state.func_177230_c().func_176201_c(state);
            if (meta == EnumMachinesE.STIRRED_TANK_BASE.ordinal() || meta == EnumMachinesE.PRECIPITATION_CHAMBER.ordinal()) {
                TileEntity te = world.func_175625_s(pos);
                ItemStack itemstack = this.func_180643_i(state);
                this.handleTileNBT(te, itemstack);
                MachinesE.func_180635_a((World)world, (BlockPos)pos, (ItemStack)itemstack);
            } else {
                this.func_176226_b(world, pos, state, 0);
            }
            world.func_175698_g(pos);
        }
    }

    private void checkTopBlocks(World world, IBlockState state, IBlockState stateUp, BlockPos pos) {
        int meta = state.func_177230_c().func_176201_c(state);
        TileEntity te = world.func_175625_s(pos);
        TileEntity teUp = world.func_175625_s(pos.func_177984_a());
        if (teUp == null || te instanceof TEStirredTankBase && !(teUp instanceof TEStirredTankTop) || te instanceof TEPrecipitationChamber && !(teUp instanceof TEPrecipitationController)) {
            ItemStack itemstack = this.func_180643_i(state);
            if (meta == EnumMachinesE.STIRRED_TANK_BASE.ordinal() || meta == EnumMachinesE.PRECIPITATION_CHAMBER.ordinal()) {
                this.handleTileNBT(te, itemstack);
            }
            MachinesE.func_180635_a((World)world, (BlockPos)pos, (ItemStack)itemstack);
            world.func_175698_g(pos);
        }
    }

    private static void checkBaseBlocks(World world, IBlockState state, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        TileEntity teDown = world.func_175625_s(pos.func_177977_b());
        if (teDown == null || te instanceof TEStirredTankTop && !(teDown instanceof TEStirredTankBase) || te instanceof TEPrecipitationController && !(teDown instanceof TEPrecipitationChamber)) {
            world.func_175698_g(pos);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        int meta = state.func_177230_c().func_176201_c(state);
        if (meta == EnumMachinesE.LASER_EMITTER.ordinal()) {
            return LASER_EMITTER_AABB;
        }
        if (meta == EnumMachinesE.EXHAUSTION_VALVE.ordinal()) {
            return EXHAUSTION_VALVE_AABB;
        }
        if (meta == EnumMachinesE.BUFFER_TANK.ordinal()) {
            return BUFFER_TANK_AABB;
        }
        if (meta == EnumMachinesE.SLURRY_DRUM.ordinal()) {
            return SLURRY_DRUM_AABB;
        }
        return field_185505_j;
    }

    public boolean canEmitSignal(IBlockState state) {
        int meta = state.func_177230_c().func_176201_c(state);
        return meta == EnumMachinesE.SLURRY_DRUM.ordinal();
    }

    public boolean func_149744_f(IBlockState state) {
        return this.canEmitSignal(state);
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.canEmitSignal(state);
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return blockState.func_185911_a(blockAccess, pos, side);
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        int currentPower = 0;
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileTank) {
            TileTank tank = (TileTank)te;
            currentPower = tank.emittedPower();
        }
        return currentPower;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        int meta = state.func_177230_c().func_176201_c(state);
        if (meta == EnumMachinesE.LASER_EMITTER.ordinal()) {
            return new TELaserEmitter();
        }
        if (meta == EnumMachinesE.EXHAUSTION_VALVE.ordinal()) {
            return new TEExhaustionValve();
        }
        if (meta == EnumMachinesE.WATER_PUMP.ordinal()) {
            return new TEWaterPump();
        }
        if (meta == EnumMachinesE.CATALYST_REGEN.ordinal()) {
            return new TECatalystRegen();
        }
        if (meta == EnumMachinesE.DISPOSER.ordinal()) {
            return new TEDisposer();
        }
        if (meta == EnumMachinesE.SLURRY_DRUM.ordinal()) {
            return new TESlurryDrum();
        }
        if (meta == EnumMachinesE.BUFFER_TANK.ordinal()) {
            return new TEBufferTank();
        }
        if (meta == EnumMachinesE.STIRRED_TANK_BASE.ordinal()) {
            return new TEStirredTankBase();
        }
        if (meta == EnumMachinesE.STIRRED_TANK_TOP.ordinal()) {
            return new TEStirredTankTop();
        }
        if (meta == EnumMachinesE.STIRRED_TANK_OUT.ordinal()) {
            return new TEStirredTankOut();
        }
        if (meta == EnumMachinesE.PRECIPITATION_CHAMBER.ordinal()) {
            return new TEPrecipitationChamber();
        }
        if (meta == EnumMachinesE.PRECIPITATION_CONTROLLER.ordinal()) {
            return new TEPrecipitationController();
        }
        if (meta == EnumMachinesE.PRECIPITATION_REACTOR.ordinal()) {
            return new TEPrecipitationReactor();
        }
        return null;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            int meta = state.func_177230_c().func_176201_c(state);
            if (world.func_175625_s(pos) != null) {
                if (world.func_175625_s(pos) instanceof IFluidHandlingTile && !player.func_184614_ca().func_190926_b() && CoreUtils.isBucketType((ItemStack)player.func_184614_ca())) {
                    ((IFluidHandlingTile)world.func_175625_s(pos)).interactWithFluidHandler(player, hand, world, pos, facing);
                    return true;
                }
                if (this.hasNullifier(player, hand)) {
                    this.handleNullifier(world, pos, player, hand, state.func_177230_c(), meta);
                    return false;
                }
                if (meta == EnumMachinesE.WATER_PUMP.ordinal()) {
                    TEWaterPump pump = (TEWaterPump)world.func_175625_s(pos);
                    if (!world.field_72995_K) {
                        EntityItem upgrade;
                        if (pump.getCompressor() && CoreUtils.hasWrench((EntityPlayer)player)) {
                            pump.compressor = false;
                            upgrade = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), this.compressor);
                            world.func_72838_d((Entity)upgrade);
                        }
                        if (!pump.getCompressor() && CoreUtils.hasTool((EntityPlayer)player, (ItemStack)this.compressor)) {
                            pump.compressor = true;
                            pump.markDirtyClient();
                            if (!player.field_71075_bZ.field_75098_d) {
                                player.func_184614_ca().func_190918_g(1);
                            }
                        }
                        if (CoreUtils.hasTool((EntityPlayer)player, (ItemStack)this.iron_impeller)) {
                            upgrade = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack(ModItems.MISC_ITEMS, 1, pump.tier + 30));
                            world.func_72838_d((Entity)upgrade);
                            pump.tier = 0;
                            if (!player.field_71075_bZ.field_75098_d) {
                                player.func_184614_ca().func_190918_g(1);
                            }
                        }
                        if (CoreUtils.hasTool((EntityPlayer)player, (ItemStack)this.aluminum_impeller)) {
                            upgrade = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack(ModItems.MISC_ITEMS, 1, pump.tier + 30));
                            world.func_72838_d((Entity)upgrade);
                            pump.tier = 1;
                            if (!player.field_71075_bZ.field_75098_d) {
                                player.func_184614_ca().func_190918_g(1);
                            }
                        }
                        if (CoreUtils.hasTool((EntityPlayer)player, (ItemStack)this.stellite_impeller)) {
                            upgrade = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack(ModItems.MISC_ITEMS, 1, pump.tier + 30));
                            world.func_72838_d((Entity)upgrade);
                            pump.tier = 2;
                            if (!player.field_71075_bZ.field_75098_d) {
                                player.func_184614_ca().func_190918_g(1);
                            }
                        }
                    }
                }
                if (meta == EnumMachinesE.CATALYST_REGEN.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 65, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesE.DISPOSER.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 66, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesE.SLURRY_DRUM.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 67, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesE.BUFFER_TANK.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 68, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesE.STIRRED_TANK_BASE.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 69, world, pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p());
                }
                if (meta == EnumMachinesE.STIRRED_TANK_TOP.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 69, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesE.STIRRED_TANK_OUT.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 70, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesE.PRECIPITATION_CHAMBER.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 71, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesE.PRECIPITATION_CONTROLLER.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 72, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
            }
        }
        return true;
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        IBlockState state = world.func_180495_p(pos);
        int meta = state.func_177230_c().func_176201_c(state);
        if (CoreUtils.hasWrench((EntityPlayer)player)) {
            this.handleRotation(world, pos, player, meta);
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        int meta = state.func_177230_c().func_176201_c(state);
        return meta != EnumMachinesE.STIRRED_TANK_TOP.ordinal() && meta != EnumMachinesE.PRECIPITATION_CONTROLLER.ordinal() ? Item.func_150898_a((Block)this) : null;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        int meta = state.func_177230_c().func_176201_c(state);
        return meta != EnumMachinesE.STIRRED_TANK_TOP.ordinal() && meta != EnumMachinesE.PRECIPITATION_CONTROLLER.ordinal();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        int meta = state.func_177230_c().func_176201_c(state);
        if (meta == EnumMachinesE.STIRRED_TANK_TOP.ordinal()) {
            return new ItemStack(Item.func_150898_a((Block)this), 1, EnumMachinesE.STIRRED_TANK_BASE.ordinal());
        }
        if (meta == EnumMachinesE.PRECIPITATION_CONTROLLER.ordinal()) {
            return new ItemStack(Item.func_150898_a((Block)this), 1, EnumMachinesE.PRECIPITATION_CHAMBER.ordinal());
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, @Nullable ItemStack stack) {
        player.func_71029_a(StatList.func_188055_a((Block)this));
        player.func_71020_j(0.025f);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        int meta = this.func_176201_c(state);
        ItemStack itemstack = ItemStack.field_190927_a;
        if (meta != EnumMachinesE.STIRRED_TANK_TOP.ordinal() && meta != EnumMachinesE.PRECIPITATION_CONTROLLER.ordinal()) {
            itemstack = new ItemStack((Block)this, 1, meta);
        }
        this.handleTileNBT(te, itemstack);
        if (!itemstack.func_190926_b()) {
            items.add(itemstack);
        }
        ForgeEventFactory.fireBlockHarvesting(items, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)player);
        for (ItemStack item : items) {
            MachinesE.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)item);
        }
    }

    public void handleTileNBT(TileEntity te, ItemStack itemstack) {
        if (te != null) {
            MachinesUtils.addMachineNbt((ItemStack)itemstack, (TileEntity)te);
            if (te instanceof TEWaterPump) {
                MachinesE.addWaterPumpNbt(itemstack, te);
            }
            if (te instanceof TEDisposer) {
                MachinesE.addDisposerNbt(itemstack, te);
            }
            if (te instanceof TESlurryDrum) {
                MachinesE.addSlurryDrumNbt(itemstack, te);
            }
            if (te instanceof TEBufferTank) {
                MachinesE.addBufferTankNbt(itemstack, te);
            }
            if (te instanceof TEStirredTankOut) {
                MachinesE.addStirredTankOutNbt(itemstack, te);
            }
        }
    }

    private static void addWaterPumpNbt(ItemStack itemstack, TileEntity te) {
        TEWaterPump tank = (TEWaterPump)te;
        NBTTagCompound solvent = new NBTTagCompound();
        itemstack.func_77978_p().func_74757_a("Compressor", tank.getCompressor());
        itemstack.func_77978_p().func_74768_a("Tier", tank.getTier());
        if (tank.inputTank.getFluid() != null) {
            tank.inputTank.getFluid().writeToNBT(solvent);
            itemstack.func_77978_p().func_74782_a(EnumFluidNbt.FLUID.nameTag(), (NBTBase)solvent);
        }
    }

    private static void restoreWaterPumpNBT(ItemStack stack, TileEntity te) {
        TEWaterPump tank = (TEWaterPump)te;
        if (stack.func_77942_o() && tank != null) {
            int upg;
            if (stack.func_77978_p().func_74764_b("Compressor")) {
                tank.compressor = upg = stack.func_77978_p().func_74767_n("Compressor");
            }
            if (stack.func_77978_p().func_74764_b("Tier")) {
                tank.tier = upg = stack.func_77978_p().func_74762_e("Tier");
            }
            if (stack.func_77942_o() && tank != null && stack.func_77978_p().func_74764_b(EnumFluidNbt.FLUID.nameTag())) {
                tank.inputTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l(EnumFluidNbt.FLUID.nameTag())));
            }
        }
    }

    private static void addDisposerNbt(ItemStack itemstack, TileEntity te) {
        TEDisposer disposer = (TEDisposer)te;
        NBTTagList nbttaglist = new NBTTagList();
        itemstack.func_77978_p().func_74768_a("Interval", disposer.getInterval());
        itemstack.func_77978_p().func_74757_a("Lock", disposer.isLocked());
        for (int i = 0; i < disposer.lockList.size(); ++i) {
            if (disposer.lockList.get(i).func_190926_b()) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            disposer.lockList.get(i).func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        itemstack.func_77978_p().func_74782_a("Filter", (NBTBase)nbttaglist);
    }

    private static void restoreDisposerNBT(ItemStack stack, TileEntity te) {
        TEDisposer disposer = (TEDisposer)te;
        if (stack.func_77942_o() && disposer != null) {
            disposer.lock = stack.func_77978_p().func_74767_n("Lock");
            disposer.interval = stack.func_77978_p().func_74762_e("Interval");
            if (stack.func_77978_p().func_74764_b("Filter")) {
                NBTTagList nbttaglist = stack.func_77978_p().func_150295_c("Filter", 10);
                disposer.lockList = new ArrayList<ItemStack>();
                disposer.resetLock();
                for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                    NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                    byte j = nbttagcompound.func_74771_c("Slot");
                    if (j < 0 || j >= disposer.lockList.size()) continue;
                    disposer.lockList.add(j, new ItemStack(nbttagcompound));
                }
            }
        }
    }

    private static void addSlurryDrumNbt(ItemStack itemstack, TileEntity te) {
        TESlurryDrum tank = (TESlurryDrum)te;
        NBTTagCompound solvent = new NBTTagCompound();
        if (tank.inputTank.getFluid() != null) {
            tank.inputTank.getFluid().writeToNBT(solvent);
            itemstack.func_77978_p().func_74782_a(EnumFluidNbt.FLUID.nameTag(), (NBTBase)solvent);
        }
        if (tank.getFilter() != null) {
            NBTTagCompound filterNBT = new NBTTagCompound();
            tank.filter.writeToNBT(filterNBT);
            itemstack.func_77978_p().func_74782_a("Filter", (NBTBase)filterNBT);
        }
    }

    private static void restoreSlurryDrumNBT(ItemStack stack, TileEntity te) {
        TESlurryDrum tank = (TESlurryDrum)te;
        if (stack.func_77942_o() && tank != null) {
            if (stack.func_77978_p().func_74764_b(EnumFluidNbt.FLUID.nameTag())) {
                tank.inputTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l(EnumFluidNbt.FLUID.nameTag())));
            }
            if (stack.func_77978_p().func_74764_b("Filter")) {
                tank.filter = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l("Filter"));
            }
        }
    }

    private static void addBufferTankNbt(ItemStack itemstack, TileEntity te) {
        TEBufferTank tank = (TEBufferTank)te;
        NBTTagCompound solvent = new NBTTagCompound();
        if (tank.inputTank.getFluid() != null) {
            tank.inputTank.getFluid().writeToNBT(solvent);
            itemstack.func_77978_p().func_74782_a(EnumFluidNbt.FLUID.nameTag(), (NBTBase)solvent);
        }
    }

    private static void restoreBufferTankNBT(ItemStack stack, TileEntity te) {
        TEBufferTank tank = (TEBufferTank)te;
        if (stack.func_77942_o() && tank != null && stack.func_77978_p().func_74764_b(EnumFluidNbt.FLUID.nameTag())) {
            tank.inputTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l(EnumFluidNbt.FLUID.nameTag())));
        }
    }

    private static void addStirredTankOutNbt(ItemStack itemstack, TileEntity te) {
        TEStirredTankOut tank = (TEStirredTankOut)te;
        NBTTagCompound solvent = new NBTTagCompound();
        if (tank.inputTank.getFluid() != null) {
            tank.inputTank.getFluid().writeToNBT(solvent);
            itemstack.func_77978_p().func_74782_a(EnumFluidNbt.FLUID.nameTag(), (NBTBase)solvent);
        }
    }

    private static void restoreStirredTankOutNBT(ItemStack stack, TileEntity te) {
        TEStirredTankOut tank = (TEStirredTankOut)te;
        if (stack.func_77942_o() && tank != null && stack.func_77942_o() && tank != null && stack.func_77978_p().func_74764_b(EnumFluidNbt.FLUID.nameTag())) {
            tank.inputTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l(EnumFluidNbt.FLUID.nameTag())));
        }
    }
}

