/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines;

import com.globbypotato.rockhounding_chemistry.Rhchemistry;
import com.globbypotato.rockhounding_chemistry.enums.EnumMachinesC;
import com.globbypotato.rockhounding_chemistry.machines.io.MachineIO;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEElementsCabinetBase;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEElementsCabinetTop;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEExtractorBalance;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEExtractorController;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEExtractorInjector;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEExtractorReactor;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEExtractorStabilizer;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEGanController;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEGasCondenser;
import com.globbypotato.rockhounding_chemistry.machines.tile.TELeachingVatCollector;
import com.globbypotato.rockhounding_chemistry.machines.tile.TELeachingVatController;
import com.globbypotato.rockhounding_chemistry.machines.tile.TELeachingVatTank;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEMultivessel;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEReformerController;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEReformerReactor;
import com.globbypotato.rockhounding_chemistry.machines.tile.TERetentionVat;
import com.globbypotato.rockhounding_core.enums.EnumFluidNbt;
import com.globbypotato.rockhounding_core.machines.tileentity.IFluidHandlingTile;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.utils.CoreUtils;
import com.globbypotato.rockhounding_core.utils.MachinesUtils;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;

public class MachinesC
extends MachineIO {
    public static PropertyEnum VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumMachinesC.class);

    public MachinesC(String name) {
        super(name, Material.field_151573_f, EnumMachinesC.getNames(), 3.0f, 5.0f, SoundType.field_185852_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumMachinesC.values()[0])).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumMachinesC.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumMachinesC)((Object)state.func_177229_b((IProperty)VARIANT))).ordinal();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityInv tile = (TileEntityInv)world.func_175625_s(pos);
        return state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)tile.facing));
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT, FACING});
    }

    @Override
    public boolean hiddenParts(int meta) {
        return meta == EnumMachinesC.ELEMENTS_CABINET_TOP.ordinal() || meta == EnumMachinesC.REFORMER_REACTOR.ordinal();
    }

    @Override
    public boolean baseParts(int meta) {
        return meta == EnumMachinesC.ELEMENTS_CABINET_BASE.ordinal() || meta == EnumMachinesC.REFORMER_CONTROLLER.ordinal();
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        int meta = stack.func_77952_i();
        EnumFacing isFacing = EnumFacing.func_82600_a((int)2);
        world.func_180501_a(pos, state.func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumMachinesC.values()[meta])).func_177226_a((IProperty)FACING, (Comparable)isFacing), 2);
        TileEntity te = world.func_175625_s(pos);
        if (world.func_175625_s(pos) != null) {
            if (te instanceof TEMultivessel) {
                MachinesC.restoreMultivesselNBT(stack, te);
            }
            if (te instanceof TELeachingVatController) {
                MachinesC.restoreLeachingVatControllerNBT(stack, te);
            }
            if (te instanceof TELeachingVatTank) {
                MachinesC.restoreLeachingVatTankNBT(stack, te);
            }
            if (te instanceof TEElementsCabinetBase) {
                TEElementsCabinetBase cabinet = (TEElementsCabinetBase)world.func_175625_s(pos);
                MachinesC.restoreCabinetNBT(stack, te);
                this.setOrDropBlock(world, state, pos, cabinet.getFacing(), placer, EnumMachinesC.ELEMENTS_CABINET_TOP);
            }
            if (te instanceof TEReformerController) {
                TEReformerController reactor = (TEReformerController)world.func_175625_s(pos);
                this.setOrDropBlock(world, state, pos, reactor.getFacing(), placer, EnumMachinesC.REFORMER_REACTOR);
            }
        }
    }

    @Override
    public void checkFullBlocks(World world, BlockPos pos, IBlockState state) {
        int meta = state.func_177230_c().func_176201_c(state);
        if (meta == EnumMachinesC.ELEMENTS_CABINET_BASE.ordinal()) {
            this.checkTopBlocks(world, world.func_180495_p(pos), world.func_180495_p(pos.func_177984_a()), pos);
        }
        if (meta == EnumMachinesC.ELEMENTS_CABINET_TOP.ordinal()) {
            MachinesC.checkBaseBlocks(world, world.func_180495_p(pos.func_177977_b()), pos);
        }
        if (meta == EnumMachinesC.REFORMER_CONTROLLER.ordinal()) {
            this.checkTopBlocks(world, world.func_180495_p(pos), world.func_180495_p(pos.func_177984_a()), pos);
        }
        if (meta == EnumMachinesC.REFORMER_REACTOR.ordinal()) {
            MachinesC.checkBaseBlocks(world, world.func_180495_p(pos.func_177977_b()), pos);
        }
    }

    private void setOrDropBlock(World world, IBlockState state, BlockPos pos, EnumFacing facing, EntityLivingBase placer, EnumMachinesC prop) {
        if (world.func_180495_p(pos.func_177984_a()).func_177230_c().isAir(world.func_180495_p(pos.func_177984_a()), (IBlockAccess)world, pos)) {
            world.func_180501_a(pos.func_177984_a(), this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)prop)).func_177226_a((IProperty)FACING, (Comparable)facing), 2);
            TileEntityInv top = (TileEntityInv)world.func_175625_s(pos.func_177984_a());
            top.facing = facing.ordinal();
        } else {
            int meta = state.func_177230_c().func_176201_c(state);
            if (meta == EnumMachinesC.ELEMENTS_CABINET_BASE.ordinal()) {
                TileEntity te = world.func_175625_s(pos);
                ItemStack itemstack = this.func_180643_i(state);
                this.handleTileNBT(te, itemstack);
                MachinesC.func_180635_a((World)world, (BlockPos)pos, (ItemStack)itemstack);
            } else {
                this.func_176226_b(world, pos, state, 0);
            }
            world.func_175698_g(pos);
        }
    }

    private void checkTopBlocks(World world, IBlockState state, IBlockState stateUp, BlockPos pos) {
        int meta = state.func_177230_c().func_176201_c(state);
        TileEntity te = world.func_175625_s(pos);
        TileEntity teUp = world.func_175625_s(pos.func_177984_a());
        if (teUp == null || te instanceof TEElementsCabinetBase && !(teUp instanceof TEElementsCabinetTop) || te instanceof TEReformerController && !(teUp instanceof TEReformerReactor)) {
            ItemStack itemstack = this.func_180643_i(state);
            if (meta == EnumMachinesC.ELEMENTS_CABINET_BASE.ordinal() || meta == EnumMachinesC.REFORMER_CONTROLLER.ordinal()) {
                this.handleTileNBT(te, itemstack);
            }
            MachinesC.func_180635_a((World)world, (BlockPos)pos, (ItemStack)itemstack);
            world.func_175698_g(pos);
        }
    }

    private static void checkBaseBlocks(World world, IBlockState state, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        TileEntity teDown = world.func_175625_s(pos.func_177977_b());
        if (teDown == null || te instanceof TEElementsCabinetTop && !(teDown instanceof TEElementsCabinetBase) || te instanceof TEReformerReactor && !(teDown instanceof TEReformerController)) {
            world.func_175698_g(pos);
        }
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        int meta = state.func_177230_c().func_176201_c(state);
        if (meta == EnumMachinesC.GAN_CONTROLLER.ordinal()) {
            return new TEGanController();
        }
        if (meta == EnumMachinesC.GAS_CONDENSER.ordinal()) {
            return new TEGasCondenser();
        }
        if (meta == EnumMachinesC.MULTIVESSEL.ordinal()) {
            return new TEMultivessel();
        }
        if (meta == EnumMachinesC.LEACHING_VAT_CONTROLLER.ordinal()) {
            return new TELeachingVatController();
        }
        if (meta == EnumMachinesC.LEACHING_VAT_TANK.ordinal()) {
            return new TELeachingVatTank();
        }
        if (meta == EnumMachinesC.LEACHING_VAT_COLLECTOR.ordinal()) {
            return new TELeachingVatCollector();
        }
        if (meta == EnumMachinesC.RETENTION_VAT.ordinal()) {
            return new TERetentionVat();
        }
        if (meta == EnumMachinesC.EXTRACTOR_CONTROLLER.ordinal()) {
            return new TEExtractorController();
        }
        if (meta == EnumMachinesC.EXTRACTOR_REACTOR.ordinal()) {
            return new TEExtractorReactor();
        }
        if (meta == EnumMachinesC.ELEMENTS_CABINET_BASE.ordinal()) {
            return new TEElementsCabinetBase();
        }
        if (meta == EnumMachinesC.ELEMENTS_CABINET_TOP.ordinal()) {
            return new TEElementsCabinetTop();
        }
        if (meta == EnumMachinesC.EXTRACTOR_INJECTOR.ordinal()) {
            return new TEExtractorInjector();
        }
        if (meta == EnumMachinesC.EXTRACTOR_BALANCE.ordinal()) {
            return new TEExtractorBalance();
        }
        if (meta == EnumMachinesC.REFORMER_CONTROLLER.ordinal()) {
            return new TEReformerController();
        }
        if (meta == EnumMachinesC.REFORMER_REACTOR.ordinal()) {
            return new TEReformerReactor();
        }
        if (meta == EnumMachinesC.EXTRACTOR_STABILIZER.ordinal()) {
            return new TEExtractorStabilizer();
        }
        return null;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            int meta = state.func_177230_c().func_176201_c(state);
            if (world.func_175625_s(pos) != null) {
                if (world.func_175625_s(pos) instanceof IFluidHandlingTile && !player.func_184614_ca().func_190926_b() && CoreUtils.isBucketType((ItemStack)player.func_184614_ca())) {
                    ((IFluidHandlingTile)world.func_175625_s(pos)).interactWithFluidHandler(player, hand, world, pos, facing);
                    return true;
                }
                if (this.hasNullifier(player, hand)) {
                    this.handleNullifier(world, pos, player, hand, state.func_177230_c(), meta);
                    return false;
                }
                if (meta == EnumMachinesC.GAN_CONTROLLER.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 32, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesC.MULTIVESSEL.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 33, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesC.GAS_CONDENSER.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 34, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesC.LEACHING_VAT_CONTROLLER.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 36, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesC.LEACHING_VAT_TANK.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 35, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesC.LEACHING_VAT_COLLECTOR.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 37, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesC.RETENTION_VAT.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 38, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesC.EXTRACTOR_INJECTOR.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 39, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesC.ELEMENTS_CABINET_BASE.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 40, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesC.ELEMENTS_CABINET_TOP.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 45, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesC.EXTRACTOR_CONTROLLER.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 41, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesC.EXTRACTOR_STABILIZER.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 42, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesC.REFORMER_CONTROLLER.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 43, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesC.REFORMER_REACTOR.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 44, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
            }
        }
        return true;
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        IBlockState state = world.func_180495_p(pos);
        int meta = state.func_177230_c().func_176201_c(state);
        if (CoreUtils.hasWrench((EntityPlayer)player)) {
            this.handleRotation(world, pos, player, meta);
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        int meta = state.func_177230_c().func_176201_c(state);
        return meta != EnumMachinesC.ELEMENTS_CABINET_TOP.ordinal() && meta != EnumMachinesC.REFORMER_REACTOR.ordinal() ? Item.func_150898_a((Block)this) : null;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        int meta = state.func_177230_c().func_176201_c(state);
        return meta != EnumMachinesC.ELEMENTS_CABINET_TOP.ordinal() && meta != EnumMachinesC.REFORMER_REACTOR.ordinal();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        int meta = state.func_177230_c().func_176201_c(state);
        if (meta == EnumMachinesC.ELEMENTS_CABINET_TOP.ordinal()) {
            return new ItemStack(Item.func_150898_a((Block)this), 1, EnumMachinesC.ELEMENTS_CABINET_BASE.ordinal());
        }
        if (meta == EnumMachinesC.REFORMER_REACTOR.ordinal()) {
            return new ItemStack(Item.func_150898_a((Block)this), 1, EnumMachinesC.REFORMER_CONTROLLER.ordinal());
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, @Nullable ItemStack stack) {
        player.func_71029_a(StatList.func_188055_a((Block)this));
        player.func_71020_j(0.025f);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        int meta = this.func_176201_c(state);
        ItemStack itemstack = ItemStack.field_190927_a;
        if (meta != EnumMachinesC.ELEMENTS_CABINET_TOP.ordinal() && meta != EnumMachinesC.REFORMER_REACTOR.ordinal()) {
            itemstack = new ItemStack((Block)this, 1, meta);
        }
        this.handleTileNBT(te, itemstack);
        if (!itemstack.func_190926_b()) {
            items.add(itemstack);
        }
        ForgeEventFactory.fireBlockHarvesting(items, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)player);
        for (ItemStack item : items) {
            MachinesC.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)item);
        }
    }

    public void handleTileNBT(TileEntity te, ItemStack itemstack) {
        if (te != null) {
            MachinesUtils.addMachineNbt((ItemStack)itemstack, (TileEntity)te);
            if (te instanceof TEMultivessel) {
                MachinesC.addMultivesselNbt(itemstack, te);
            }
            if (te instanceof TELeachingVatController) {
                MachinesC.addLeachingVatControllerNbt(itemstack, te);
            }
            if (te instanceof TELeachingVatTank) {
                MachinesC.addLeachingVatTankNbt(itemstack, te);
            }
            if (te instanceof TEElementsCabinetBase) {
                MachinesC.addCabinetNbt(itemstack, te);
            }
        }
    }

    private static void addMultivesselNbt(ItemStack itemstack, TileEntity te) {
        TEMultivessel tank = (TEMultivessel)te;
        NBTTagCompound tank_Ar = new NBTTagCompound();
        if (tank.tank_Ar.getFluid() != null) {
            tank.tank_Ar.getFluid().writeToNBT(tank_Ar);
            itemstack.func_77978_p().func_74782_a("Tank_Ar", (NBTBase)tank_Ar);
        }
        NBTTagCompound tank_CO = new NBTTagCompound();
        if (tank.tank_CO.getFluid() != null) {
            tank.tank_CO.getFluid().writeToNBT(tank_CO);
            itemstack.func_77978_p().func_74782_a("Tank_CO", (NBTBase)tank_CO);
        }
        NBTTagCompound tank_Ne = new NBTTagCompound();
        if (tank.tank_Ne.getFluid() != null) {
            tank.tank_Ne.getFluid().writeToNBT(tank_Ne);
            itemstack.func_77978_p().func_74782_a("Tank_Ne", (NBTBase)tank_Ne);
        }
        NBTTagCompound tank_He = new NBTTagCompound();
        if (tank.tank_He.getFluid() != null) {
            tank.tank_He.getFluid().writeToNBT(tank_He);
            itemstack.func_77978_p().func_74782_a("Tank_He", (NBTBase)tank_He);
        }
        NBTTagCompound tank_Kr = new NBTTagCompound();
        if (tank.tank_Kr.getFluid() != null) {
            tank.tank_Kr.getFluid().writeToNBT(tank_Kr);
            itemstack.func_77978_p().func_74782_a("Tank_Kr", (NBTBase)tank_Kr);
        }
        NBTTagCompound tank_Xe = new NBTTagCompound();
        if (tank.tank_Xe.getFluid() != null) {
            tank.tank_Xe.getFluid().writeToNBT(tank_Xe);
            itemstack.func_77978_p().func_74782_a("Tank_Xe", (NBTBase)tank_Xe);
        }
        itemstack.func_77978_p().func_74768_a("Collapse", tank.collapseRate);
    }

    private static void restoreMultivesselNBT(ItemStack itemstack, TileEntity te) {
        TEMultivessel tank = (TEMultivessel)te;
        if (itemstack.func_77942_o() && tank != null) {
            if (itemstack.func_77978_p().func_74764_b("Tank_Ar")) {
                tank.tank_Ar.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemstack.func_77978_p().func_74775_l("Tank_Ar")));
            }
            if (itemstack.func_77978_p().func_74764_b("Tank_CO")) {
                tank.tank_CO.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemstack.func_77978_p().func_74775_l("Tank_CO")));
            }
            if (itemstack.func_77978_p().func_74764_b("Tank_Ne")) {
                tank.tank_Ne.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemstack.func_77978_p().func_74775_l("Tank_Ne")));
            }
            if (itemstack.func_77978_p().func_74764_b("Tank_He")) {
                tank.tank_He.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemstack.func_77978_p().func_74775_l("Tank_He")));
            }
            if (itemstack.func_77978_p().func_74764_b("Tank_Kr")) {
                tank.tank_Kr.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemstack.func_77978_p().func_74775_l("Tank_Kr")));
            }
            if (itemstack.func_77978_p().func_74764_b("Tank_Xe")) {
                tank.tank_Xe.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemstack.func_77978_p().func_74775_l("Tank_Xe")));
            }
            tank.collapseRate = itemstack.func_77978_p().func_74762_e("Collapse");
        }
    }

    private static void addLeachingVatControllerNbt(ItemStack itemstack, TileEntity te) {
        TELeachingVatController controller = (TELeachingVatController)te;
        itemstack.func_77978_p().func_74776_a("Gravity", controller.getGravity());
    }

    private static void restoreLeachingVatControllerNBT(ItemStack stack, TileEntity te) {
        TELeachingVatController controller = (TELeachingVatController)te;
        if (stack.func_77942_o() && controller != null && stack.func_77978_p().func_74764_b("Gravity")) {
            float comm;
            controller.gravity = comm = stack.func_77978_p().func_74760_g("Gravity");
        }
    }

    private static void addLeachingVatTankNbt(ItemStack itemstack, TileEntity te) {
        TELeachingVatTank tank = (TELeachingVatTank)te;
        NBTTagCompound solvent = new NBTTagCompound();
        if (tank.inputTank.getFluid() != null) {
            tank.inputTank.getFluid().writeToNBT(solvent);
            itemstack.func_77978_p().func_74782_a(EnumFluidNbt.SOLVENT.nameTag(), (NBTBase)solvent);
        }
        if (tank.getFilter() != null) {
            NBTTagCompound filterNBT = new NBTTagCompound();
            tank.filter.writeToNBT(filterNBT);
            itemstack.func_77978_p().func_74782_a("Filter", (NBTBase)filterNBT);
        }
    }

    private static void restoreLeachingVatTankNBT(ItemStack itemstack, TileEntity te) {
        TELeachingVatTank tank = (TELeachingVatTank)te;
        if (itemstack.func_77942_o() && tank != null) {
            if (itemstack.func_77978_p().func_74764_b(EnumFluidNbt.SOLVENT.nameTag())) {
                tank.inputTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemstack.func_77978_p().func_74775_l(EnumFluidNbt.SOLVENT.nameTag())));
            }
            if (itemstack.func_77978_p().func_74764_b("Filter")) {
                tank.filter = FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemstack.func_77978_p().func_74775_l("Filter"));
            }
        }
    }

    private static void addCabinetNbt(ItemStack itemstack, TileEntity te) {
        TEElementsCabinetBase cabinet = (TEElementsCabinetBase)te;
        NBTTagList quantityList = new NBTTagList();
        for (int i = 0; i < cabinet.elementList.length; ++i) {
            NBTTagCompound tagQuantity = new NBTTagCompound();
            tagQuantity.func_74768_a("Element" + i, cabinet.elementList[i]);
            quantityList.func_74742_a((NBTBase)tagQuantity);
        }
        itemstack.func_77978_p().func_74782_a("ElementsList", (NBTBase)quantityList);
    }

    private static void restoreCabinetNBT(ItemStack itemstack, TileEntity te) {
        TEElementsCabinetBase cabinet = (TEElementsCabinetBase)te;
        if (itemstack.func_77942_o() && itemstack.func_77978_p().func_74764_b("ElementsList")) {
            NBTTagList quantityList = itemstack.func_77978_p().func_150295_c("ElementsList", 10);
            for (int i = 0; i < quantityList.func_74745_c(); ++i) {
                NBTTagCompound getQuantities = quantityList.func_150305_b(i);
                cabinet.elementList[i] = getQuantities.func_74762_e("Element" + i);
            }
        }
    }
}

