/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines;

import com.globbypotato.rockhounding_chemistry.Rhchemistry;
import com.globbypotato.rockhounding_chemistry.enums.EnumCasting;
import com.globbypotato.rockhounding_chemistry.enums.EnumMachinesA;
import com.globbypotato.rockhounding_chemistry.machines.io.MachineIO;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEEvaporationTank;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEFluidInputTank;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEFluidOutputTank;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEFluidTank;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEGasExpander;
import com.globbypotato.rockhounding_chemistry.machines.tile.TELabBlenderController;
import com.globbypotato.rockhounding_chemistry.machines.tile.TELabBlenderTank;
import com.globbypotato.rockhounding_chemistry.machines.tile.TELabOvenChamber;
import com.globbypotato.rockhounding_chemistry.machines.tile.TELabOvenController;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEMineralSizerCollector;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEMineralSizerController;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEMineralSizerTank;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEPowerGenerator;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEProfilingBench;
import com.globbypotato.rockhounding_chemistry.machines.tile.TESeasoningRack;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEServer;
import com.globbypotato.rockhounding_chemistry.machines.tile.TileTank;
import com.globbypotato.rockhounding_core.enums.EnumFluidNbt;
import com.globbypotato.rockhounding_core.machines.tileentity.IFluidHandlingTile;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.utils.CoreUtils;
import com.globbypotato.rockhounding_core.utils.MachinesUtils;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;

public class MachinesA
extends MachineIO {
    public static PropertyEnum VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumMachinesA.class);
    public static final AxisAlignedBB TANK_BLOCK_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.4, 1.0);

    public MachinesA(String name) {
        super(name, Material.field_151573_f, EnumMachinesA.getNames(), 3.0f, 5.0f, SoundType.field_185852_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumMachinesA.values()[0])).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumMachinesA.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumMachinesA)((Object)state.func_177229_b((IProperty)VARIANT))).ordinal();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityInv tile = (TileEntityInv)world.func_175625_s(pos);
        return state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)tile.facing));
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT, FACING});
    }

    @Override
    public boolean hiddenParts(int meta) {
        return meta == EnumMachinesA.LAB_BLENDER_TANK.ordinal() || meta == EnumMachinesA.LAB_OVEN_CONTROLLER.ordinal();
    }

    @Override
    public boolean baseParts(int meta) {
        return meta == EnumMachinesA.LAB_BLENDER_CONTROLLER.ordinal() || meta == EnumMachinesA.LAB_OVEN_CHAMBER.ordinal();
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        int meta = stack.func_77952_i();
        EnumFacing isFacing = EnumFacing.func_82600_a((int)2);
        world.func_180501_a(pos, state.func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumMachinesA.values()[meta])).func_177226_a((IProperty)FACING, (Comparable)isFacing), 2);
        TileEntity te = world.func_175625_s(pos);
        if (world.func_175625_s(pos) != null) {
            TileEntityInv chamber;
            if (te instanceof TEMineralSizerController) {
                MachinesA.restoreMineralSizerControllerNBT(stack, te);
            }
            if (te instanceof TEFluidTank) {
                MachinesA.restoreFluidTankNBT(stack, te);
            }
            if (te instanceof TEPowerGenerator) {
                MachinesA.restorePowerGeneratorNBT(stack, te);
            }
            if (te instanceof TEFluidInputTank) {
                MachinesA.restoreLabOvenIntankNBT(stack, te);
            }
            if (te instanceof TEFluidOutputTank) {
                MachinesA.restoreLabOvenOuttankNBT(stack, te);
            }
            if (te instanceof TELabBlenderController) {
                chamber = (TELabBlenderController)world.func_175625_s(pos);
                this.setOrDropBlock(world, state, pos, chamber.getFacing(), placer, EnumMachinesA.LAB_BLENDER_TANK);
            }
            if (te instanceof TELabOvenChamber) {
                chamber = (TELabOvenChamber)world.func_175625_s(pos);
                this.setOrDropBlock(world, state, pos, chamber.getFacing(), placer, EnumMachinesA.LAB_OVEN_CONTROLLER);
            }
        }
    }

    private void setOrDropBlock(World world, IBlockState state, BlockPos pos, EnumFacing facing, EntityLivingBase placer, EnumMachinesA prop) {
        if (world.func_180495_p(pos.func_177984_a()).func_177230_c().isAir(world.func_180495_p(pos.func_177984_a()), (IBlockAccess)world, pos)) {
            world.func_180501_a(pos.func_177984_a(), this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)prop)).func_177226_a((IProperty)FACING, (Comparable)facing), 2);
            TileEntityInv top = (TileEntityInv)world.func_175625_s(pos.func_177984_a());
            top.facing = facing.ordinal();
        } else {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    @Override
    public void checkFullBlocks(World world, BlockPos pos, IBlockState state) {
        int meta = state.func_177230_c().func_176201_c(state);
        if (meta == EnumMachinesA.LAB_OVEN_CHAMBER.ordinal()) {
            this.checkTopBlocks(world, world.func_180495_p(pos), world.func_180495_p(pos.func_177984_a()), pos);
        }
        if (meta == EnumMachinesA.LAB_OVEN_CONTROLLER.ordinal()) {
            MachinesA.checkBaseBlocks(world, world.func_180495_p(pos.func_177977_b()), pos);
        }
        if (meta == EnumMachinesA.LAB_BLENDER_CONTROLLER.ordinal()) {
            this.checkTopBlocks(world, world.func_180495_p(pos), world.func_180495_p(pos.func_177984_a()), pos);
        }
        if (meta == EnumMachinesA.LAB_BLENDER_TANK.ordinal()) {
            MachinesA.checkBaseBlocks(world, world.func_180495_p(pos.func_177977_b()), pos);
        }
    }

    private void checkTopBlocks(World world, IBlockState state, IBlockState stateUp, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        TileEntity teUp = world.func_175625_s(pos.func_177984_a());
        if (teUp == null || te instanceof TELabOvenChamber && !(teUp instanceof TELabOvenController) || te instanceof TELabBlenderController && !(teUp instanceof TELabBlenderTank)) {
            ItemStack itemstack = this.func_180643_i(state);
            MachinesA.func_180635_a((World)world, (BlockPos)pos, (ItemStack)itemstack);
            world.func_175698_g(pos);
        }
    }

    private static void checkBaseBlocks(World world, IBlockState state, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        TileEntity teDown = world.func_175625_s(pos.func_177977_b());
        if (teDown == null || te instanceof TELabOvenController && !(teDown instanceof TELabOvenChamber) || te instanceof TELabBlenderTank && !(teDown instanceof TELabBlenderController)) {
            world.func_175698_g(pos);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        int meta = state.func_177230_c().func_176201_c(state);
        return meta == EnumMachinesA.EVAPORATION_TANK.ordinal() ? TANK_BLOCK_AABB : field_185505_j;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TEMineralSizerController) {
            TEMineralSizerController sizer = (TEMineralSizerController)te;
            if (sizer.hasTankA()) {
                sizer.getTankA().activation = false;
                sizer.getTankA().markDirtyClient();
            }
            if (sizer.hasTankB()) {
                sizer.getTankB().activation = false;
                sizer.getTankB().markDirtyClient();
            }
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean canEmitSignal(IBlockState state) {
        int meta = state.func_177230_c().func_176201_c(state);
        return meta == EnumMachinesA.FLUID_TANK.ordinal();
    }

    public boolean func_149744_f(IBlockState state) {
        return this.canEmitSignal(state);
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.canEmitSignal(state);
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return blockState.func_185911_a(blockAccess, pos, side);
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        int currentPower = 0;
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileTank) {
            TileTank tank = (TileTank)te;
            currentPower = tank.emittedPower();
        }
        return currentPower;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        int meta = state.func_177230_c().func_176201_c(state);
        if (meta == EnumMachinesA.SIZER_CONTROLLER.ordinal()) {
            return new TEMineralSizerController();
        }
        if (meta == EnumMachinesA.SIZER_TANK.ordinal()) {
            return new TEMineralSizerTank();
        }
        if (meta == EnumMachinesA.POWER_GENERATOR.ordinal()) {
            return new TEPowerGenerator();
        }
        if (meta == EnumMachinesA.SIZER_COLLECTOR.ordinal()) {
            return new TEMineralSizerCollector();
        }
        if (meta == EnumMachinesA.FLUID_TANK.ordinal()) {
            return new TEFluidTank();
        }
        if (meta == EnumMachinesA.LAB_OVEN_CONTROLLER.ordinal()) {
            return new TELabOvenController();
        }
        if (meta == EnumMachinesA.LAB_OVEN_CHAMBER.ordinal()) {
            return new TELabOvenChamber();
        }
        if (meta == EnumMachinesA.FLUID_INPUT_TANK.ordinal()) {
            return new TEFluidInputTank();
        }
        if (meta == EnumMachinesA.FLUID_OUTPUT_TANK.ordinal()) {
            return new TEFluidOutputTank();
        }
        if (meta == EnumMachinesA.LAB_BLENDER_CONTROLLER.ordinal()) {
            return new TELabBlenderController();
        }
        if (meta == EnumMachinesA.LAB_BLENDER_TANK.ordinal()) {
            return new TELabBlenderTank();
        }
        if (meta == EnumMachinesA.PROFILING_BENCH.ordinal()) {
            return new TEProfilingBench();
        }
        if (meta == EnumMachinesA.EVAPORATION_TANK.ordinal()) {
            return new TEEvaporationTank();
        }
        if (meta == EnumMachinesA.SEASONING_RACK.ordinal()) {
            return new TESeasoningRack();
        }
        if (meta == EnumMachinesA.SERVER.ordinal()) {
            return new TEServer();
        }
        if (meta == EnumMachinesA.GAS_EXPANDER.ordinal()) {
            return new TEGasExpander();
        }
        return null;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            int meta = state.func_177230_c().func_176201_c(state);
            if (world.func_175625_s(pos) != null) {
                if (world.func_175625_s(pos) instanceof IFluidHandlingTile && CoreUtils.isBucketType((ItemStack)player.func_184614_ca())) {
                    ((IFluidHandlingTile)world.func_175625_s(pos)).interactWithFluidHandler(player, hand, world, pos, facing);
                    return true;
                }
                if (this.hasNullifier(player, hand)) {
                    this.handleNullifier(world, pos, player, hand, state.func_177230_c(), meta);
                    return false;
                }
                if (meta == EnumMachinesA.SIZER_CONTROLLER.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesA.SIZER_TANK.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesA.POWER_GENERATOR.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 2, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesA.SIZER_COLLECTOR.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 3, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesA.FLUID_TANK.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 4, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesA.LAB_OVEN_CONTROLLER.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 5, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesA.LAB_OVEN_CHAMBER.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 5, world, pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p());
                }
                if (meta == EnumMachinesA.FLUID_INPUT_TANK.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 6, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesA.FLUID_OUTPUT_TANK.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 7, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesA.LAB_BLENDER_CONTROLLER.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 8, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesA.LAB_BLENDER_TANK.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 9, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesA.PROFILING_BENCH.ordinal()) {
                    TEProfilingBench casting = (TEProfilingBench)world.func_175625_s(pos);
                    ItemStack outputStack = casting.outputSlot().func_77946_l();
                    if (!outputStack.func_190926_b()) {
                        EntityItem outEntity = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5, outputStack);
                        outEntity.field_70159_w = 0.0;
                        outEntity.field_70181_x = 0.0;
                        outEntity.field_70179_y = 0.0;
                        if (!world.field_72995_K) {
                            world.func_72838_d((Entity)outEntity);
                        }
                        world.func_184148_a((EntityPlayer)null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187629_cO, SoundCategory.AMBIENT, 0.5f, this.rand.nextFloat() * 0.1f + 0.9f);
                        casting.getOutput().extractItem(0, outputStack.func_190916_E(), false);
                    } else {
                        ItemStack inputStack = casting.inputSlot().func_77946_l();
                        if (!inputStack.func_190926_b()) {
                            EntityItem inputEntity = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5, inputStack);
                            inputEntity.field_70159_w = 0.0;
                            inputEntity.field_70181_x = 0.0;
                            inputEntity.field_70179_y = 0.0;
                            if (!world.field_72995_K) {
                                world.func_72838_d((Entity)inputEntity);
                            }
                            world.func_184148_a((EntityPlayer)null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187629_cO, SoundCategory.AMBIENT, 0.5f, this.rand.nextFloat() * 0.1f + 0.9f);
                            casting.getInput().extractItem(0, inputStack.func_190916_E(), false);
                        } else if (inputStack.func_190926_b() && !player.func_184614_ca().func_190926_b() && casting.isValidInput(player.func_184614_ca())) {
                            int possibleStack = casting.inputSlot().func_77976_d() - casting.inputSlot().func_190916_E();
                            int availableStack = player.func_184614_ca().func_190916_E();
                            casting.getInput().insertItem(0, new ItemStack(player.func_184614_ca().func_77973_b(), 1, player.func_184614_ca().func_77952_i()), false);
                            player.func_184614_ca().func_190918_g(1);
                            world.func_184148_a((EntityPlayer)null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187626_cN, SoundCategory.AMBIENT, 0.5f, this.rand.nextFloat() * 0.1f + 0.9f);
                        }
                    }
                }
                if (meta == EnumMachinesA.EVAPORATION_TANK.ordinal()) {
                    TEEvaporationTank tank;
                    ItemStack heldItem = player.func_184614_ca();
                    if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof ItemSpade && facing == EnumFacing.UP && (tank = (TEEvaporationTank)world.func_175625_s(pos)).getStage() == tank.finalStage()) {
                        ItemStack outputStack = tank.outputSlot().func_77946_l();
                        EntityItem outEntity = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5, outputStack);
                        outEntity.field_70159_w = 0.0;
                        outEntity.field_70181_x = 0.0;
                        outEntity.field_70179_y = 0.0;
                        if (!world.field_72995_K) {
                            world.func_72838_d((Entity)outEntity);
                        }
                        world.func_184148_a((EntityPlayer)null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187753_eE, SoundCategory.AMBIENT, 0.5f, this.rand.nextFloat() * 0.1f + 0.9f);
                        tank.getOutput().extractItem(0, outputStack.func_190916_E(), false);
                        tank.stage = 0;
                        if (!player.field_71075_bZ.field_75098_d && heldItem.func_77984_f()) {
                            int damageItem = heldItem.func_77952_i() + 1;
                            heldItem.func_77964_b(damageItem);
                            if (damageItem >= heldItem.func_77958_k()) {
                                heldItem.func_190918_g(1);
                            }
                        }
                    }
                    if (CoreUtils.hasWrench((EntityPlayer)player)) {
                        tank = (TEEvaporationTank)world.func_175625_s(pos);
                        tank.purge = tank.getPurge() < tank.finalStage() ? ++tank.purge : 0;
                    }
                }
                if (meta == EnumMachinesA.SEASONING_RACK.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 11, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesA.SERVER.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 12, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesA.GAS_EXPANDER.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 13, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
            }
        }
        return true;
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        IBlockState state = world.func_180495_p(pos);
        int meta = state.func_177230_c().func_176201_c(state);
        if (!CoreUtils.hasWrench((EntityPlayer)player) && meta == EnumMachinesA.PROFILING_BENCH.ordinal() && world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof TEProfilingBench) {
            TEProfilingBench bench = (TEProfilingBench)world.func_175625_s(pos);
            bench.currentCast = !player.func_70093_af() ? (bench.getCurrentCast() < EnumCasting.size() - 1 ? ++bench.currentCast : 0) : (bench.getCurrentCast() > 0 ? --bench.currentCast : EnumCasting.size() - 1);
        }
        if (CoreUtils.hasWrench((EntityPlayer)player)) {
            this.handleRotation(world, pos, player, meta);
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        int meta = state.func_177230_c().func_176201_c(state);
        return meta != EnumMachinesA.LAB_OVEN_CONTROLLER.ordinal() && meta != EnumMachinesA.LAB_BLENDER_TANK.ordinal() ? Item.func_150898_a((Block)this) : null;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        int meta = state.func_177230_c().func_176201_c(state);
        return meta != EnumMachinesA.LAB_OVEN_CONTROLLER.ordinal() && meta != EnumMachinesA.LAB_BLENDER_TANK.ordinal();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        int meta = state.func_177230_c().func_176201_c(state);
        if (meta == EnumMachinesA.LAB_OVEN_CONTROLLER.ordinal()) {
            return new ItemStack(Item.func_150898_a((Block)this), 1, EnumMachinesA.LAB_OVEN_CHAMBER.ordinal());
        }
        if (meta == EnumMachinesA.LAB_BLENDER_TANK.ordinal()) {
            return new ItemStack(Item.func_150898_a((Block)this), 1, EnumMachinesA.LAB_BLENDER_CONTROLLER.ordinal());
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, @Nullable ItemStack stack) {
        player.func_71029_a(StatList.func_188055_a((Block)this));
        player.func_71020_j(0.025f);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        int meta = this.func_176201_c(state);
        ItemStack itemstack = ItemStack.field_190927_a;
        if (meta != EnumMachinesA.LAB_OVEN_CONTROLLER.ordinal() && meta != EnumMachinesA.LAB_BLENDER_TANK.ordinal()) {
            itemstack = new ItemStack((Block)this, 1, this.func_176201_c(state));
        }
        if (te != null) {
            MachinesUtils.addMachineNbt((ItemStack)itemstack, (TileEntity)te);
            if (te instanceof TEMineralSizerController) {
                MachinesA.addMineralSizerControllerNbt(itemstack, te);
            }
            if (te instanceof TEFluidTank) {
                MachinesA.addFluidTankNbt(itemstack, te);
            }
            if (te instanceof TEPowerGenerator) {
                MachinesA.addPowerGeneratorNbt(itemstack, te);
            }
            if (te instanceof TEFluidInputTank) {
                MachinesA.addLabOvenIntankNbt(itemstack, te);
            }
            if (te instanceof TEFluidOutputTank) {
                MachinesA.addLabOvenOuttankNbt(itemstack, te);
            }
        }
        if (!itemstack.func_190926_b()) {
            items.add(itemstack);
        }
        ForgeEventFactory.fireBlockHarvesting(items, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)player);
        for (ItemStack item : items) {
            MachinesA.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)item);
        }
    }

    private static void addFluidTankNbt(ItemStack itemstack, TileEntity te) {
        TEFluidTank tank = (TEFluidTank)te;
        NBTTagCompound solvent = new NBTTagCompound();
        if (tank.inputTank.getFluid() != null) {
            tank.inputTank.getFluid().writeToNBT(solvent);
            itemstack.func_77978_p().func_74782_a(EnumFluidNbt.FLUID.nameTag(), (NBTBase)solvent);
        }
        if (tank.getFilter() != null) {
            NBTTagCompound filterNBT = new NBTTagCompound();
            tank.filter.writeToNBT(filterNBT);
            itemstack.func_77978_p().func_74782_a("Filter", (NBTBase)filterNBT);
        }
    }

    private static void restoreFluidTankNBT(ItemStack stack, TileEntity te) {
        TEFluidTank tank = (TEFluidTank)te;
        if (stack.func_77942_o() && tank != null) {
            if (stack.func_77978_p().func_74764_b(EnumFluidNbt.FLUID.nameTag())) {
                tank.inputTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l(EnumFluidNbt.FLUID.nameTag())));
            }
            if (stack.func_77978_p().func_74764_b("Filter")) {
                tank.filter = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l("Filter"));
            }
        }
    }

    private static void addPowerGeneratorNbt(ItemStack stack, TileEntity te) {
        TEPowerGenerator engine = (TEPowerGenerator)te;
        stack.func_77978_p().func_74757_a("FuelModule", engine.enablePower());
        stack.func_77978_p().func_74757_a("RedstoneModule", engine.enableRedstone());
    }

    private static void restorePowerGeneratorNBT(ItemStack stack, TileEntity te) {
        TEPowerGenerator engine = (TEPowerGenerator)te;
        if (stack.func_77942_o() && engine != null) {
            engine.enablePower = stack.func_77978_p().func_74767_n("FuelModule");
            engine.enableRedstone = stack.func_77978_p().func_74767_n("RedstoneModule");
        }
    }

    private static void addMineralSizerControllerNbt(ItemStack itemstack, TileEntity te) {
        TEMineralSizerController controller = (TEMineralSizerController)te;
        itemstack.func_77978_p().func_74768_a("Comminution", controller.getComminution());
    }

    private static void restoreMineralSizerControllerNBT(ItemStack stack, TileEntity te) {
        TEMineralSizerController controller = (TEMineralSizerController)te;
        if (stack.func_77942_o() && controller != null && stack.func_77978_p().func_74764_b("Comminution")) {
            int comm;
            controller.comminution = comm = stack.func_77978_p().func_74762_e("Comminution");
        }
    }

    private static void addLabOvenIntankNbt(ItemStack itemstack, TileEntity te) {
        TEFluidInputTank tank = (TEFluidInputTank)te;
        NBTTagCompound solvent = new NBTTagCompound();
        if (tank.solventTank.getFluid() != null) {
            tank.solventTank.getFluid().writeToNBT(solvent);
            itemstack.func_77978_p().func_74782_a(EnumFluidNbt.SOLVENT.nameTag(), (NBTBase)solvent);
        }
        if (tank.getFilterSolvent() != null) {
            NBTTagCompound filterSolventNBT = new NBTTagCompound();
            tank.filterSolvent.writeToNBT(filterSolventNBT);
            itemstack.func_77978_p().func_74782_a("FilterSolvent", (NBTBase)filterSolventNBT);
        }
        NBTTagCompound reagent = new NBTTagCompound();
        if (tank.reagentTank.getFluid() != null) {
            tank.reagentTank.getFluid().writeToNBT(reagent);
            itemstack.func_77978_p().func_74782_a(EnumFluidNbt.REAGENT.nameTag(), (NBTBase)reagent);
        }
        if (tank.getFilterSolvent() != null) {
            NBTTagCompound filterReagentNBT = new NBTTagCompound();
            tank.filterReagent.writeToNBT(filterReagentNBT);
            itemstack.func_77978_p().func_74782_a("FilterReagent", (NBTBase)filterReagentNBT);
        }
    }

    private static void restoreLabOvenIntankNBT(ItemStack stack, TileEntity te) {
        TEFluidInputTank tank = (TEFluidInputTank)te;
        if (stack.func_77942_o() && tank != null) {
            if (stack.func_77978_p().func_74764_b(EnumFluidNbt.SOLVENT.nameTag())) {
                tank.solventTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l(EnumFluidNbt.SOLVENT.nameTag())));
            }
            if (stack.func_77978_p().func_74764_b("FilterSolvent")) {
                tank.filterSolvent = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l("FilterSolvent"));
            }
            if (stack.func_77978_p().func_74764_b(EnumFluidNbt.REAGENT.nameTag())) {
                tank.reagentTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l(EnumFluidNbt.REAGENT.nameTag())));
            }
            if (stack.func_77978_p().func_74764_b("FilterReagent")) {
                tank.filterReagent = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l("FilterReagent"));
            }
        }
    }

    private static void addLabOvenOuttankNbt(ItemStack itemstack, TileEntity te) {
        TEFluidOutputTank tank = (TEFluidOutputTank)te;
        NBTTagCompound solution = new NBTTagCompound();
        if (tank.solutionTank.getFluid() != null) {
            tank.solutionTank.getFluid().writeToNBT(solution);
            itemstack.func_77978_p().func_74782_a(EnumFluidNbt.SOLUTION.nameTag(), (NBTBase)solution);
        }
        NBTTagCompound byproduct = new NBTTagCompound();
        if (tank.byproductTank.getFluid() != null) {
            tank.byproductTank.getFluid().writeToNBT(byproduct);
            itemstack.func_77978_p().func_74782_a(EnumFluidNbt.BYPRODUCT.nameTag(), (NBTBase)byproduct);
        }
    }

    private static void restoreLabOvenOuttankNBT(ItemStack stack, TileEntity te) {
        TEFluidOutputTank tank = (TEFluidOutputTank)te;
        if (stack.func_77942_o() && tank != null) {
            if (stack.func_77978_p().func_74764_b(EnumFluidNbt.SOLUTION.nameTag())) {
                tank.solutionTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l(EnumFluidNbt.SOLUTION.nameTag())));
            }
            if (stack.func_77978_p().func_74764_b(EnumFluidNbt.BYPRODUCT.nameTag())) {
                tank.byproductTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l(EnumFluidNbt.BYPRODUCT.nameTag())));
            }
        }
    }
}

