/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.compat.crafttweaker;

import com.globbypotato.rockhounding_chemistry.compat.crafttweaker.CTSupport;
import com.globbypotato.rockhounding_chemistry.machines.recipe.ToxicMutationRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.ToxicMutationRecipe;
import com.google.common.base.Strings;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IItemStack;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.rockhounding_chemistry.ToxicMutation")
public class CT_ToxicMutation
extends CTSupport {
    public static String name = "Toxic Mutation";
    public static ArrayList<ToxicMutationRecipe> recipeList = ToxicMutationRecipes.toxic_mutation_recipes;

    @ZenMethod
    public static void add(IItemStack input, IItemStack output) {
        if (input == null || output == null) {
            CT_ToxicMutation.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new Add(new ToxicMutationRecipe(CT_ToxicMutation.toStack(input), CT_ToxicMutation.toStack(output))));
    }

    @ZenMethod
    public static void add(String oredict, IItemStack output) {
        if (oredict == null || output == null) {
            CT_ToxicMutation.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new Add(new ToxicMutationRecipe(oredict, CT_ToxicMutation.toStack(output))));
    }

    @ZenMethod
    public static void removeByInput(IItemStack input) {
        if (input == null) {
            CT_ToxicMutation.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new RemoveByInput(CT_ToxicMutation.toStack(input)));
    }

    @ZenMethod
    public static void removeByOredict(String input) {
        if (input == null) {
            CT_ToxicMutation.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new RemoveByOredict(input));
    }

    @ZenMethod
    public static void removeByOutput(IItemStack output) {
        if (output == null) {
            CT_ToxicMutation.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new RemoveByOutput(CT_ToxicMutation.toStack(output)));
    }

    private static class RemoveByOutput
    implements IAction {
        private ItemStack output;

        public RemoveByOutput(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            for (ToxicMutationRecipe recipe : recipeList) {
                if (this.output.func_190926_b() || !recipe.getOutput().func_77969_a(this.output)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class RemoveByOredict
    implements IAction {
        private String input;

        public RemoveByOredict(String input) {
            this.input = input;
        }

        public void apply() {
            for (ToxicMutationRecipe recipe : recipeList) {
                if (Strings.isNullOrEmpty((String)this.input) || !recipe.getType() || !recipe.getOredict().matches(this.input)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class RemoveByInput
    implements IAction {
        private ItemStack input;

        public RemoveByInput(ItemStack input) {
            this.input = input;
        }

        public void apply() {
            for (ToxicMutationRecipe recipe : recipeList) {
                if (this.input.func_190926_b() || recipe.getType() || !recipe.getInput().func_77969_a(this.input)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class Add
    implements IAction {
        private final ToxicMutationRecipe recipe;

        public Add(ToxicMutationRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            recipeList.add(this.recipe);
        }

        public String describe() {
            return CTSupport.addCaption(name);
        }
    }
}

