/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.compat.crafttweaker;

import com.globbypotato.rockhounding_chemistry.compat.crafttweaker.CTSupport;
import com.globbypotato.rockhounding_chemistry.machines.recipe.RetentionVatRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.RetentionVatRecipe;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.rockhounding_chemistry.RetentionVat")
public class CT_RetentionVat
extends CTSupport {
    public static String name = "Retention Vat";
    public static ArrayList<RetentionVatRecipe> recipeList = RetentionVatRecipes.retention_vat_recipes;

    @ZenMethod
    public static void add(ILiquidStack input, IItemStack[] output, float[] gravity) {
        if (input == null || output == null) {
            CT_RetentionVat.error(name);
            return;
        }
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        ArrayList<Float> gravities = new ArrayList<Float>();
        for (int x = 0; x < output.length; ++x) {
            outputs.add(CT_RetentionVat.toStack(output[x]));
            gravities.add(Float.valueOf(gravity[x]));
        }
        CraftTweakerAPI.apply((IAction)new Add(new RetentionVatRecipe(CT_RetentionVat.toFluid(input), outputs, gravities)));
    }

    @ZenMethod
    public static void add(ILiquidStack input, IItemStack output, float gravity) {
        if (input == null || output == null) {
            CT_RetentionVat.error(name);
            return;
        }
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        ArrayList<Float> gravities = new ArrayList<Float>();
        outputs.add(CT_RetentionVat.toStack(output));
        gravities.add(Float.valueOf(gravity));
        CraftTweakerAPI.apply((IAction)new Add(new RetentionVatRecipe(CT_RetentionVat.toFluid(input), outputs, gravities)));
    }

    @ZenMethod
    public static void remove(ILiquidStack input) {
        if (input == null) {
            CT_RetentionVat.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new Remove(CT_RetentionVat.toFluid(input)));
    }

    private static class Remove
    implements IAction {
        private FluidStack input;

        public Remove(FluidStack input) {
            this.input = input;
        }

        public void apply() {
            for (RetentionVatRecipe recipe : recipeList) {
                if (this.input == null || !recipe.getInput().isFluidEqual(this.input)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class Add
    implements IAction {
        private final RetentionVatRecipe recipe;

        public Add(RetentionVatRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            recipeList.add(this.recipe);
        }

        public String describe() {
            return CTSupport.addCaption(name);
        }
    }
}

