/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.compat.crafttweaker;

import com.globbypotato.rockhounding_chemistry.compat.crafttweaker.CTSupport;
import com.globbypotato.rockhounding_chemistry.machines.recipe.MaterialCabinetRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.MaterialCabinetRecipe;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import java.util.ArrayList;
import joptsimple.internal.Strings;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.rockhounding_chemistry.MaterialCabinet")
public class CT_MaterialCabinet
extends CTSupport {
    public static String name = "Material Cabinet";
    public static ArrayList<MaterialCabinetRecipe> recipeList = MaterialCabinetRecipes.material_cabinet_recipes;

    @ZenMethod
    public static void add(String symbol, String oredict, String name) {
        if (symbol == null || oredict == null || name == null) {
            CT_MaterialCabinet.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new Add(new MaterialCabinetRecipe(symbol, oredict, name)));
    }

    @ZenMethod
    public static void remove(String oredict) {
        if (oredict == null) {
            CT_MaterialCabinet.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new Remove(oredict));
    }

    private static class Remove
    implements IAction {
        private String oredict;

        public Remove(String oredict) {
            this.oredict = oredict;
        }

        public void apply() {
            for (MaterialCabinetRecipe recipe : recipeList) {
                if (Strings.isNullOrEmpty((String)this.oredict) || !recipe.getOredict().matches(this.oredict)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class Add
    implements IAction {
        private final MaterialCabinetRecipe recipe;

        public Add(MaterialCabinetRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            recipeList.add(this.recipe);
        }

        public String describe() {
            return CTSupport.addCaption(name);
        }
    }
}

