/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.compat.crafttweaker;

import com.globbypotato.rockhounding_chemistry.compat.crafttweaker.CTSupport;
import com.globbypotato.rockhounding_chemistry.machines.recipe.LabOvenRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.LabOvenRecipe;
import com.google.common.base.Strings;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.rockhounding_chemistry.LabOven")
public class CT_LabOven
extends CTSupport {
    public static String name = "Lab Oven";
    public static ArrayList<LabOvenRecipe> recipeList = LabOvenRecipes.lab_oven_recipes;

    @ZenMethod
    public static void add(String recipename, IItemStack input, IItemStack catalyst, ILiquidStack solvent, ILiquidStack reagent, ILiquidStack solution, ILiquidStack byproduct) {
        if (input == null && catalyst == null || catalyst != null && !CT_LabOven.toStack(catalyst).func_77973_b().func_77645_m() || solvent == null || solution == null) {
            CT_LabOven.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new Add(new LabOvenRecipe(recipename, CT_LabOven.toStack(input), CT_LabOven.toStack(catalyst), CT_LabOven.toFluid(solvent), CT_LabOven.toFluid(reagent), CT_LabOven.toFluid(solution), CT_LabOven.toFluid(byproduct))));
    }

    @ZenMethod
    public static void add(String recipename, String input, IItemStack catalyst, ILiquidStack solvent, ILiquidStack reagent, ILiquidStack solution, ILiquidStack byproduct) {
        if (input == null && catalyst == null || catalyst != null && !CT_LabOven.toStack(catalyst).func_77973_b().func_77645_m() || solvent == null || solution == null) {
            CT_LabOven.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new Add(new LabOvenRecipe(recipename, input, CT_LabOven.toStack(catalyst), CT_LabOven.toFluid(solvent), CT_LabOven.toFluid(reagent), CT_LabOven.toFluid(solution), CT_LabOven.toFluid(byproduct))));
    }

    @ZenMethod
    public static void removeByInput(IItemStack input) {
        if (input == null) {
            CT_LabOven.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new RemoveByInput(CT_LabOven.toStack(input)));
    }

    @ZenMethod
    public static void removeByOredict(String input) {
        if (input == null) {
            CT_LabOven.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new RemoveByOredict(input));
    }

    @ZenMethod
    public static void removeByOutput(ILiquidStack output) {
        if (output == null) {
            CT_LabOven.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new RemoveByOutput(CT_LabOven.toFluid(output)));
    }

    private static class RemoveByOutput
    implements IAction {
        private FluidStack output;

        public RemoveByOutput(FluidStack output) {
            this.output = output;
        }

        public void apply() {
            for (LabOvenRecipe recipe : recipeList) {
                if (this.output == null || !recipe.getSolution().isFluidEqual(this.output)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class RemoveByOredict
    implements IAction {
        private String input;

        public RemoveByOredict(String input) {
            this.input = input;
        }

        public void apply() {
            for (LabOvenRecipe recipe : recipeList) {
                if (Strings.isNullOrEmpty((String)this.input) || !recipe.getType() || !recipe.getOredict().matches(this.input)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class RemoveByInput
    implements IAction {
        private ItemStack input;

        public RemoveByInput(ItemStack input) {
            this.input = input;
        }

        public void apply() {
            for (LabOvenRecipe recipe : recipeList) {
                if (this.input.func_190926_b() || recipe.getType() || !recipe.getSolute().func_77969_a(this.input)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class Add
    implements IAction {
        private final LabOvenRecipe recipe;

        public Add(LabOvenRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            recipeList.add(this.recipe);
        }

        public String describe() {
            return CTSupport.addCaption(name);
        }
    }
}

