/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.compat.crafttweaker;

import com.globbypotato.rockhounding_chemistry.compat.crafttweaker.CTSupport;
import com.globbypotato.rockhounding_chemistry.machines.recipe.ChemicalExtractorRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.ChemicalExtractorRecipe;
import com.google.common.base.Strings;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IItemStack;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.rockhounding_chemistry.ChemicalExtractor")
public class CT_ChemicalExtractor
extends CTSupport {
    public static String name = "Chemical Extractor";
    public static ArrayList<ChemicalExtractorRecipe> recipeList = ChemicalExtractorRecipes.extractor_recipes;

    @ZenMethod
    public static void add(String category, IItemStack input, String[] output, int[] quantity) {
        if (input == null || output == null) {
            CT_ChemicalExtractor.error(name);
            return;
        }
        ArrayList<String> outputs = new ArrayList<String>();
        ArrayList<Integer> quantities = new ArrayList<Integer>();
        for (int x = 0; x < output.length; ++x) {
            outputs.add(output[x]);
            quantities.add(quantity[x]);
        }
        CraftTweakerAPI.apply((IAction)new Add(new ChemicalExtractorRecipe(category, CT_ChemicalExtractor.toStack(input), outputs, quantities)));
    }

    @ZenMethod
    public static void add(String category, String input, String[] output, int[] quantity) {
        if (input == null || output == null) {
            CT_ChemicalExtractor.error(name);
            return;
        }
        ArrayList<String> outputs = new ArrayList<String>();
        ArrayList<Integer> quantities = new ArrayList<Integer>();
        for (int x = 0; x < output.length; ++x) {
            outputs.add(output[x]);
            quantities.add(quantity[x]);
        }
        CraftTweakerAPI.apply((IAction)new Add(new ChemicalExtractorRecipe(category, input, outputs, quantities)));
    }

    @ZenMethod
    public static void remove(IItemStack input) {
        if (input == null) {
            CT_ChemicalExtractor.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new RemoveByInput(CT_ChemicalExtractor.toStack(input)));
    }

    @ZenMethod
    public static void removeByInput(IItemStack input) {
        if (input == null) {
            CT_ChemicalExtractor.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new RemoveByInput(CT_ChemicalExtractor.toStack(input)));
    }

    @ZenMethod
    public static void removeByOredict(String input) {
        if (input == null) {
            CT_ChemicalExtractor.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new RemoveByOredict(input));
    }

    private static class RemoveByOredict
    implements IAction {
        private String input;

        public RemoveByOredict(String input) {
            this.input = input;
        }

        public void apply() {
            for (ChemicalExtractorRecipe recipe : recipeList) {
                if (Strings.isNullOrEmpty((String)this.input) || !recipe.getType() || !recipe.getOredict().matches(this.input)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class RemoveByInput
    implements IAction {
        private ItemStack input;

        public RemoveByInput(ItemStack input) {
            this.input = input;
        }

        public void apply() {
            for (ChemicalExtractorRecipe recipe : recipeList) {
                if (this.input.func_190926_b() || recipe.getType() || !recipe.getInput().func_77969_a(this.input)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class Add
    implements IAction {
        private final ChemicalExtractorRecipe recipe;

        public Add(ChemicalExtractorRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            recipeList.add(this.recipe);
        }

        public String describe() {
            return CTSupport.addCaption(name);
        }
    }
}

