/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.addons;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import vswe.stevescarts.containers.slots.SlotBase;
import vswe.stevescarts.containers.slots.SlotIncinerator;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.guis.GuiMinecart;
import vswe.stevescarts.modules.addons.ModuleAddon;

public class ModuleIncinerator
extends ModuleAddon {
    public ModuleIncinerator(EntityMinecartModular cart) {
        super(cart);
    }

    public void incinerate(@Nonnull ItemStack item) {
        if (this.isItemValid(item)) {
            if (this.getIncinerationCost() != 0) {
                int amount = item.func_190916_E() * this.getIncinerationCost();
                amount = this.getCart().drain(FluidRegistry.LAVA, amount, false);
                int incinerated = amount / this.getIncinerationCost();
                this.getCart().drain(FluidRegistry.LAVA, incinerated * this.getIncinerationCost(), true);
                item.func_190918_g(incinerated);
            } else {
                item.func_190920_e(0);
            }
        }
    }

    protected int getIncinerationCost() {
        return 3;
    }

    protected boolean isItemValid(@Nonnull ItemStack item) {
        if (!item.func_190926_b()) {
            for (int i = 0; i < this.getInventorySize(); ++i) {
                if (this.getStack(i).func_190926_b() || !item.func_77969_a(this.getStack(i))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void drawForeground(GuiMinecart gui) {
        this.drawString(gui, this.getModuleName(), 8, 6, 0x404040);
    }

    @Override
    protected int getInventoryWidth() {
        return 4;
    }

    @Override
    protected SlotBase getSlot(int slotId, int x, int y) {
        return new SlotIncinerator(this.getCart(), slotId, 8 + x * 18, 23 + y * 18);
    }
}

