/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.client.rendering.model;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BufferBuilderUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    public static Field byteBufferField = ReflectionHelper.findField(BufferBuilder.class, (String[])new String[]{"byteBuffer", "field_179001_a"});
    public static Field rawIntBufferField = ReflectionHelper.findField(BufferBuilder.class, (String[])new String[]{"rawIntBuffer", "field_178999_b"});
    public static Field rawFloatBufferField = ReflectionHelper.findField(BufferBuilder.class, (String[])new String[]{"rawFloatBuffer", "field_179000_c"});
    public static Field rawShortBufferField = ReflectionHelper.findField(BufferBuilder.class, (String[])new String[]{"rawShortBuffer", "field_181676_c"});
    public static Field vertexCountField = ReflectionHelper.findField(BufferBuilder.class, (String[])new String[]{"vertexCount", "field_178997_d"});
    public static Method growBuffer = ReflectionHelper.findMethod(BufferBuilder.class, (String)"growBuffer", (String)"func_181670_b", (Class[])new Class[]{Integer.TYPE});

    public static void growBuffer(BufferBuilder builder, int size) {
        try {
            growBuffer.invoke((Object)builder, size);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e1) {
            e1.printStackTrace();
        }
    }

    public static void growBufferSmall(BufferBuilder builder, int size) {
        try {
            ByteBuffer oldByteBuffer = builder.func_178966_f();
            IntBuffer intBuffer = (IntBuffer)rawIntBufferField.get(builder);
            if (MathHelper.func_154354_b((int)size, (int)4) / 4 > intBuffer.remaining() || vertexCountField.getInt(builder) * builder.func_178973_g().func_177338_f() + size > oldByteBuffer.capacity()) {
                int i = oldByteBuffer.capacity();
                int j = i + size;
                System.out.println("Made buffer grow buffer: Old size " + Integer.valueOf(i) + " bytes, new size " + Integer.valueOf(j) + " bytes.");
                LOGGER.debug("Needed to grow BufferBuilder buffer: Old size {} bytes, new size {} bytes.", (Object)i, (Object)j);
                int k = intBuffer.position();
                ByteBuffer byteBuffer = GLAllocation.func_74524_c((int)j);
                oldByteBuffer.position(0);
                byteBuffer.put(oldByteBuffer);
                byteBuffer.rewind();
                byteBufferField.set(builder, byteBuffer);
                rawFloatBufferField.set(builder, byteBuffer.asFloatBuffer().asReadOnlyBuffer());
                rawIntBufferField.set(builder, byteBuffer.asIntBuffer());
                ((IntBuffer)rawIntBufferField.get(builder)).position(k);
                rawShortBufferField.set(builder, byteBuffer.asShortBuffer());
                ((ShortBuffer)rawShortBufferField.get(builder)).position(k << 1);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public static int getBufferSize(BufferBuilder builder) {
        return builder.func_178973_g().func_181719_f() * builder.func_178989_h();
    }

    public static void addVertexDataSmall(BufferBuilder builder, int[] vertexData) {
        BufferBuilderUtils.growBufferSmall(builder, vertexData.length * 4 + builder.func_178973_g().func_177338_f());
        try {
            IntBuffer intBuffer = (IntBuffer)rawIntBufferField.get(builder);
            intBuffer.position(BufferBuilderUtils.getBufferSize(builder));
            intBuffer.put(vertexData);
            vertexCountField.setInt(builder, vertexCountField.getInt(builder) + vertexData.length / builder.func_178973_g().func_181719_f());
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public static void addBuffer(BufferBuilder buffer, BufferBuilder toAdd) {
        int size = toAdd.func_178973_g().func_181719_f() * toAdd.func_178989_h();
        try {
            IntBuffer rawIntBuffer = (IntBuffer)rawIntBufferField.get(toAdd);
            rawIntBuffer.rewind();
            rawIntBuffer.limit(size);
            BufferBuilderUtils.growBuffer(buffer, size);
            IntBuffer chunkIntBuffer = (IntBuffer)rawIntBufferField.get(buffer);
            chunkIntBuffer.position(BufferBuilderUtils.getBufferSize(buffer));
            chunkIntBuffer.put(rawIntBuffer);
            vertexCountField.setInt(buffer, vertexCountField.getInt(buffer) + size / buffer.func_178973_g().func_181719_f());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

