/*
 * Decompiled with CFR 0.152.
 */
package com.expensivekoala.refined_avaritia.tile;

import com.expensivekoala.refined_avaritia.Registry;
import com.expensivekoala.refined_avaritia.inventory.ItemHandlerRestricted;
import com.expensivekoala.refined_avaritia.item.ItemExtremePattern;
import com.expensivekoala.refined_avaritia.util.AvaritiaRecipeManagerWrapper;
import com.expensivekoala.refined_avaritia.util.ECRecipeManagerWrapper;
import com.expensivekoala.refined_avaritia.util.ExtendedCraftingUtil;
import com.expensivekoala.refined_avaritia.util.RecipeType;
import com.expensivekoala.refined_avaritia.util.StackUtils;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileExtremePatternEncoder
extends TileEntity {
    private static final String NBT_OREDICT_PATTERN = "OredictPattern";
    private static final String NBT_AVARITIA_RECIPE = "AvaritiaRecipe";
    private static final String NBT_TABLE_SIZE = "TableSize";
    private ItemHandlerRestricted patterns = new ItemHandlerRestricted(2, new ResourceLocation("refined_avaritia", "extreme_pattern"));
    private ItemHandlerRestricted recipe = new ItemHandlerRestricted(81, new ResourceLocation[0]);
    private ItemHandlerRestricted recipeOutput = new ItemHandlerRestricted(1, new ResourceLocation[0]);
    private boolean oredictPattern = false;
    private boolean avaritia = false;
    private ExtendedCraftingUtil.TableSize tableSize = ExtendedCraftingUtil.TableSize.ULTIMATE;

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.oredictPattern = tag.func_74767_n(NBT_OREDICT_PATTERN);
        this.tableSize = ExtendedCraftingUtil.TableSize.values()[tag.func_74762_e(NBT_TABLE_SIZE)];
        this.avaritia = tag.func_74767_n(NBT_AVARITIA_RECIPE);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag.func_74757_a(NBT_OREDICT_PATTERN, this.oredictPattern);
        tag.func_74768_a(NBT_TABLE_SIZE, this.tableSize.ordinal());
        tag.func_74757_a(NBT_AVARITIA_RECIPE, this.avaritia);
        return tag;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        StackUtils.writeItems((IItemHandler)this.patterns, 0, tag);
        StackUtils.writeItems((IItemHandler)this.recipe, 1, tag);
        tag.func_74757_a(NBT_OREDICT_PATTERN, this.oredictPattern);
        tag.func_74768_a(NBT_TABLE_SIZE, this.tableSize.ordinal());
        tag.func_74757_a(NBT_AVARITIA_RECIPE, this.avaritia);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        StackUtils.readItems((IItemHandlerModifiable)this.patterns, 0, tag);
        StackUtils.readItems((IItemHandlerModifiable)this.recipe, 1, tag);
        this.oredictPattern = tag.func_74767_n(NBT_OREDICT_PATTERN);
        this.tableSize = ExtendedCraftingUtil.TableSize.values()[tag.func_74762_e(NBT_TABLE_SIZE)];
        this.avaritia = tag.func_74767_n(NBT_AVARITIA_RECIPE);
    }

    public void onCreatePattern() {
        if (this.canCreatePattern()) {
            this.patterns.extractItem(0, 1, false);
            ItemStack pattern = new ItemStack((Item)Registry.PATTERN);
            ItemExtremePattern.setOredict(pattern, this.oredictPattern);
            if (this.avaritia) {
                ItemExtremePattern.setType(pattern, RecipeType.AVARITIA);
                for (int i = 0; i < 81; ++i) {
                    ItemStack ingredient = this.recipe.getStackInSlot(i);
                    if (ingredient.func_190926_b()) continue;
                    ItemExtremePattern.setSlot(pattern, i, ingredient);
                }
            } else {
                RecipeType type;
                switch (this.tableSize) {
                    case BASIC: {
                        type = RecipeType.EC_BASIC;
                        break;
                    }
                    case ADVANCED: {
                        type = RecipeType.EC_ADVANCED;
                        break;
                    }
                    case ELITE: {
                        type = RecipeType.EC_ELITE;
                        break;
                    }
                    default: {
                        type = RecipeType.EC_ULTIMATE;
                    }
                }
                ItemExtremePattern.setType(pattern, type);
                for (int i = 0; i < type.width * type.height; ++i) {
                    int y = i / type.height;
                    int x = i % type.width;
                    ItemStack ingredient = this.recipe.getStackInSlot((y + (9 - type.height) / 2) * 9 + (x + (9 - type.width) / 2));
                    if (ingredient.func_190926_b()) continue;
                    ItemExtremePattern.setSlot(pattern, i, ingredient);
                }
            }
            this.patterns.setStackInSlot(1, pattern);
        }
    }

    public boolean canCreatePattern() {
        return !this.recipeOutput.getStackInSlot(0).func_190926_b() && this.patterns.getStackInSlot(1).func_190926_b() && !this.patterns.getStackInSlot(0).func_190926_b();
    }

    public void onContentsChanged() {
        if (this.avaritia) {
            ItemStack stack = AvaritiaRecipeManagerWrapper.getCraftingResult(this.getCrafting((IItemHandler)this.recipe), this.func_145831_w());
            this.recipeOutput.setStackInSlot(0, stack);
        } else {
            ItemStack stack = ECRecipeManagerWrapper.getCraftingResult(this.getCrafting((IItemHandler)this.recipe), this.func_145831_w());
            this.recipeOutput.setStackInSlot(0, stack);
        }
        this.func_70296_d();
    }

    public void clearRecipe() {
        for (int i = 0; i < this.recipe.getSlots(); ++i) {
            this.recipe.setStackInSlot(i, ItemStack.field_190927_a);
        }
        this.onContentsChanged();
    }

    public boolean getOredictPattern() {
        return this.oredictPattern;
    }

    public void setOredictPattern(boolean oredictPattern) {
        this.oredictPattern = oredictPattern;
    }

    public boolean isAvaritia() {
        return this.avaritia;
    }

    public void setAvaritia(boolean avaritia) {
        this.avaritia = avaritia;
        this.onContentsChanged();
    }

    public ExtendedCraftingUtil.TableSize getTableSize() {
        return this.tableSize;
    }

    /*
     * Unable to fully structure code
     */
    public void setTableSize(ExtendedCraftingUtil.TableSize tableSize) {
        this.tableSize = tableSize;
        block5: for (i = 0; i < this.recipe.getSlots(); ++i) {
            if (this.recipe.getStackInSlot(i) == ItemStack.field_190927_a) continue;
            x = i % 9;
            y = i / 9;
            switch (2.$SwitchMap$com$expensivekoala$refined_avaritia$util$ExtendedCraftingUtil$TableSize[this.tableSize.ordinal()]) {
                case 1: {
                    if (x < 2 || x > 6 || y != 2 && y != 6) ** GOTO lbl11
                    this.recipe.setStackInSlot(i, ItemStack.field_190927_a);
                    ** GOTO lbl13
lbl11:
                    // 1 sources

                    if (y > 2 && y < 6 && (x == 2 || x == 6)) {
                        this.recipe.setStackInSlot(i, ItemStack.field_190927_a);
                    }
                }
lbl13:
                // 5 sources

                case 2: {
                    if (x < 1 || x > 7 || y != 1 && y != 7) ** GOTO lbl17
                    this.recipe.setStackInSlot(i, ItemStack.field_190927_a);
                    ** GOTO lbl19
lbl17:
                    // 1 sources

                    if (y > 1 && y < 7 && (x == 1 || x == 7)) {
                        this.recipe.setStackInSlot(i, ItemStack.field_190927_a);
                    }
                }
lbl19:
                // 5 sources

                case 3: {
                    if (x >= 0 && x <= 8 && (y == 0 || y == 8)) {
                        this.recipe.setStackInSlot(i, ItemStack.field_190927_a);
                        continue block5;
                    }
                    if (y <= 0 || y >= 8 || x != 0 && x != 8) continue block5;
                    this.recipe.setStackInSlot(i, ItemStack.field_190927_a);
                }
            }
        }
        this.onContentsChanged();
    }

    public InventoryCrafting getCrafting(IItemHandler recipe) {
        RecipeType type;
        Container craftingContainer = new Container(){

            public boolean func_75145_c(EntityPlayer player) {
                return false;
            }
        };
        if (this.avaritia) {
            InventoryCrafting crafting = new InventoryCrafting(craftingContainer, 9, 9);
            for (int i = 0; i < recipe.getSlots(); ++i) {
                if (recipe.getStackInSlot(i).func_190926_b()) continue;
                crafting.func_70299_a(i, recipe.getStackInSlot(i));
            }
            return crafting;
        }
        switch (this.tableSize) {
            case BASIC: {
                type = RecipeType.EC_BASIC;
                break;
            }
            case ADVANCED: {
                type = RecipeType.EC_ADVANCED;
                break;
            }
            case ELITE: {
                type = RecipeType.EC_ELITE;
                break;
            }
            default: {
                type = RecipeType.EC_ULTIMATE;
            }
        }
        InventoryCrafting crafting = new InventoryCrafting(craftingContainer, type.width, type.height);
        for (int x = 0; x < type.width; ++x) {
            for (int y = 0; y < type.height; ++y) {
                if (recipe.getStackInSlot((y + (9 - type.height) / 2) * 9 + (x + (9 - type.width) / 2)).func_190926_b()) continue;
                crafting.func_70299_a(y * type.height + x, recipe.getStackInSlot((y + (9 - type.height) / 2) * 9 + (x + (9 - type.width) / 2)));
            }
        }
        return crafting;
    }

    public IItemHandler getPatterns() {
        return this.patterns;
    }

    public IItemHandler getRecipe() {
        return this.recipe;
    }

    public IItemHandler getRecipeOutput() {
        return this.recipeOutput;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.patterns);
        }
        return (T)super.getCapability(capability, facing);
    }
}

