/*
 * Decompiled with CFR 0.152.
 */
package com.animania.manual.components;

import com.animania.manual.components.IManualComponent;
import com.animania.manual.gui.GuiManual;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.common.crafting.IShapedRecipe;

public class CraftingComponent
implements IManualComponent {
    private List<IRecipe> recipes;
    private GuiManual manual;
    private int x;
    private int y;
    private int absoluteX;
    private int absoluteY;
    private int objectWidth;
    private int objectHeight;
    private Minecraft mc;
    private int recipeIndex = 0;
    private ItemStack[][] items;
    private int[] ingredientIndex = new int[9];
    private IRecipe currentRecipe;
    private static final ResourceLocation MATRIX_TEXTURE = new ResourceLocation("animania", "textures/gui/crafting_matrix.png");
    private static final ResourceLocation BUTTONS = new ResourceLocation("animania", "textures/gui/recipe_buttons.png");
    public static int ITEM_TIMER = 0;

    public CraftingComponent(int x, int y, List<IRecipe> recipes) {
        this.manual = GuiManual.INSTANCE;
        this.absoluteX = x + 36;
        this.absoluteY = y + 16;
        this.x = x;
        this.y = y;
        this.recipes = recipes;
        this.mc = Minecraft.func_71410_x();
        this.objectHeight = 54;
        this.objectWidth = 104;
    }

    @Override
    public void init() {
        this.currentRecipe = this.recipes.get(this.recipeIndex);
        this.items = this.getSortedIngredients(this.currentRecipe);
        this.ingredientIndex = new int[9];
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTicks) {
        this.mc.field_71446_o.func_110577_a(MATRIX_TEXTURE);
        int border = (114 - this.objectWidth) / 2;
        int posX = this.absoluteX + this.manual.guiLeft + border;
        int posY = this.absoluteY + this.manual.guiTop;
        GlStateManager.func_179094_E();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        GuiManual.func_146110_a((int)posX, (int)posY, (float)0.0f, (float)0.0f, (int)this.objectWidth, (int)this.objectHeight, (float)this.objectWidth, (float)this.objectHeight);
        GlStateManager.func_179121_F();
        for (int i = 0; i < 9; ++i) {
            int offsetX = 1 + 18 * (i % 3);
            int offsetY = 1 + 18 * (i / 3);
            if (this.items[i].length <= 0) continue;
            GlStateManager.func_179094_E();
            RenderHelper.func_74520_c();
            this.manual.drawItemStack(this.items[i][this.ingredientIndex[i]], posX + offsetX, posY + offsetY, null);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179094_E();
        RenderHelper.func_74520_c();
        this.manual.drawItemStack(this.currentRecipe.func_77571_b(), posX + 83, posY + 19, null);
        GlStateManager.func_179121_F();
        if (this.recipes.size() > 1) {
            this.mc.field_71446_o.func_110577_a(BUTTONS);
            GuiManual.func_146110_a((int)(posX + 56), (int)(posY + 42), (float)(this.isHovering(mouseX, mouseY, posX + 56, posY + 42, 9, 11) ? 18.0f : 0.0f), (float)0.0f, (int)9, (int)11, (float)36.0f, (float)11.0f);
            GuiManual.func_146110_a((int)(posX + 67), (int)(posY + 42), (float)(this.isHovering(mouseX, mouseY, posX + 67, posY + 42, 9, 11) ? 27.0f : 9.0f), (float)0.0f, (int)9, (int)11, (float)36.0f, (float)11.0f);
        }
        if (!(this.currentRecipe instanceof IShapedRecipe)) {
            this.mc.field_71466_p.func_78276_b(I18n.func_74838_a((String)"manual.crafting.shapeless"), posX + 57, posY + 2, 0);
        }
        GlStateManager.func_179140_f();
    }

    @Override
    public void update() {
        this.updateIngredientIndices();
    }

    @Override
    public void drawLater(int mouseX, int mouseY, float partialTicks) {
        int border = (114 - this.objectWidth) / 2;
        int posX = this.absoluteX + this.manual.guiLeft + border;
        int posY = this.absoluteY + this.manual.guiTop;
        GlStateManager.func_179094_E();
        for (int i = 0; i < 9; ++i) {
            int offsetX = 1 + 18 * (i % 3);
            int offsetY = 1 + 18 * (i / 3);
            if (!this.isHovering(mouseX, mouseY, posX + offsetX, posY + offsetY, 16, 16) || this.items[i].length <= 0) continue;
            this.manual.func_146285_a(this.items[i][this.ingredientIndex[i]], mouseX, mouseY);
        }
        if (this.isHovering(mouseX, mouseY, posX + 83, posY + 19, 16, 16)) {
            this.manual.func_146285_a(this.currentRecipe.func_77571_b(), mouseX, mouseY);
        }
        GlStateManager.func_179140_f();
        GlStateManager.func_179121_F();
    }

    public boolean isHovering(int mouseX, int mouseY, int x, int y, int dx, int dy) {
        return mouseX > x && mouseX < x + dx && mouseY > y && mouseY < y + dy;
    }

    private void updateIngredientIndices() {
        if (!GuiScreen.func_146272_n() && ITEM_TIMER == 0) {
            for (int i = 0; i < this.items.length; ++i) {
                ItemStack[] ings = this.items[i];
                if (ings.length <= 1) continue;
                int currentIndex = this.ingredientIndex[i];
                if (currentIndex == ings.length - 1) {
                    currentIndex = 0;
                }
                this.ingredientIndex[i] = ++currentIndex;
            }
        }
    }

    @Override
    public void onLeftClick(int mouseX, int mouseY) {
        if (this.recipes.size() > 1) {
            int border = (114 - this.objectWidth) / 2;
            int posX = this.absoluteX + this.manual.guiLeft + border;
            int posY = this.absoluteY + this.manual.guiTop;
            if (this.isHovering(mouseX, mouseY, posX + 56, posY + 42, 9, 11)) {
                this.recipeIndex = this.recipeIndex == 0 ? this.recipes.size() - 1 : --this.recipeIndex;
                this.mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                this.init();
                return;
            }
            if (this.isHovering(mouseX, mouseY, posX + 67, posY + 42, 9, 11)) {
                this.recipeIndex = this.recipeIndex == this.recipes.size() - 1 ? 0 : ++this.recipeIndex;
                this.init();
                this.mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                return;
            }
        }
    }

    @Override
    public void onRightClick(int mouseX, int mouseY) {
    }

    @Override
    public int getObjectWidth() {
        return this.objectWidth;
    }

    @Override
    public int getObjectHeight() {
        return this.objectHeight;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public IManualComponent setX(int x) {
        this.x = x;
        this.absoluteX = x + 36;
        return this;
    }

    @Override
    public IManualComponent setY(int y) {
        this.y = y;
        this.absoluteY = y + 16;
        return this;
    }

    @Override
    public void onLeftClick() {
    }

    @Override
    public void onRightClick() {
    }

    private ItemStack[][] getSortedIngredients(IRecipe recipe) {
        ItemStack[][] sortedIngredients = new ItemStack[9][0];
        int craftingWidth = 3;
        int craftingHeight = 3;
        int recipeWidth = recipe instanceof IShapedRecipe ? ((IShapedRecipe)recipe).getRecipeWidth() : craftingWidth;
        int l = 0;
        Iterator iterator = recipe.func_192400_c().iterator();
        block0: for (int i1 = 0; i1 < craftingHeight; ++i1) {
            for (int j1 = 0; j1 < recipeWidth; ++j1) {
                if (!iterator.hasNext()) break block0;
                Ingredient ingredient = (Ingredient)iterator.next();
                if (ingredient != Ingredient.field_193370_a) {
                    sortedIngredients[l] = ingredient.func_193365_a();
                }
                ++l;
            }
            if (recipeWidth >= craftingWidth) continue;
            l += craftingWidth - recipeWidth;
        }
        return sortedIngredients;
    }
}

