/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.entities.goats;

import com.animania.common.entities.AnimalContainer;
import com.animania.common.entities.EntityGender;
import com.animania.common.entities.generic.ai.GenericAIAvoidEntity;
import com.animania.common.entities.generic.ai.GenericAIEatGrass;
import com.animania.common.entities.generic.ai.GenericAIFindFood;
import com.animania.common.entities.generic.ai.GenericAIFindSaltLick;
import com.animania.common.entities.generic.ai.GenericAIFindWater;
import com.animania.common.entities.generic.ai.GenericAILookIdle;
import com.animania.common.entities.generic.ai.GenericAIPanic;
import com.animania.common.entities.generic.ai.GenericAISleep;
import com.animania.common.entities.generic.ai.GenericAITempt;
import com.animania.common.entities.generic.ai.GenericAIWanderAvoidWater;
import com.animania.common.entities.generic.ai.GenericAIWatchClosest;
import com.animania.common.entities.goats.EntityBuckAngora;
import com.animania.common.entities.goats.EntityDoeAngora;
import com.animania.common.entities.goats.EntityKidBase;
import com.animania.common.entities.goats.GoatType;
import com.animania.common.entities.interfaces.IAnimaniaAnimalBase;
import com.animania.common.helper.AnimaniaHelper;
import com.animania.common.items.ItemEntityEgg;
import com.animania.config.AnimaniaConfig;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityAnimaniaGoat
extends EntitySheep
implements IAnimaniaAnimalBase {
    public static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])AnimaniaHelper.getItemArray(AnimaniaConfig.careAndFeeding.goatFood));
    protected static final DataParameter<Boolean> WATERED = EntityDataManager.func_187226_a(EntityAnimaniaGoat.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> FED = EntityDataManager.func_187226_a(EntityAnimaniaGoat.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Optional<UUID>> MATE_UNIQUE_ID = EntityDataManager.func_187226_a(EntityAnimaniaGoat.class, (DataSerializer)DataSerializers.field_187203_m);
    protected static final DataParameter<Optional<UUID>> RIVAL_UNIQUE_ID = EntityDataManager.func_187226_a(EntityAnimaniaGoat.class, (DataSerializer)DataSerializers.field_187203_m);
    protected static final DataParameter<Boolean> SHEARED = EntityDataManager.func_187226_a(EntityAnimaniaGoat.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Integer> SHEARED_TIMER = EntityDataManager.func_187226_a(EntityAnimaniaGoat.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Boolean> SPOOKED = EntityDataManager.func_187226_a(EntityAnimaniaGoat.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Float> SPOOKED_TIMER = EntityDataManager.func_187226_a(EntityAnimaniaGoat.class, (DataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Integer> AGE = EntityDataManager.func_187226_a(EntityAnimaniaGoat.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Boolean> HANDFED = EntityDataManager.func_187226_a(EntityAnimaniaGoat.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> SLEEPING = EntityDataManager.func_187226_a(EntityAnimaniaGoat.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Float> SLEEPTIMER = EntityDataManager.func_187226_a(EntityAnimaniaGoat.class, (DataSerializer)DataSerializers.field_187193_c);
    protected int happyTimer;
    public int blinkTimer;
    public int eatTimer;
    protected int fedTimer;
    protected int wateredTimer;
    protected int damageTimer;
    public GoatType goatType;
    public GenericAIEatGrass<EntityAnimaniaGoat> field_146087_bs;
    protected boolean mateable = false;
    protected boolean headbutting = false;
    protected EntityGender gender;
    private boolean hasRemovedBOP;

    public EntityAnimaniaGoat(World worldIn) {
        super(worldIn);
        this.field_70714_bg.field_75782_a.clear();
        this.field_146087_bs = new GenericAIEatGrass<EntityAnimaniaGoat>(this);
        this.field_70714_bg.func_75776_a(0, new GenericAIPanic<EntityAnimaniaGoat>(this, 1.4));
        if (!AnimaniaConfig.gameRules.ambianceMode) {
            this.field_70714_bg.func_75776_a(2, new GenericAIFindWater<EntityAnimaniaGoat>(this, 1.0, this.field_146087_bs, EntityAnimaniaGoat.class));
            this.field_70714_bg.func_75776_a(3, new GenericAIFindFood<EntityAnimaniaGoat>(this, 1.0, this.field_146087_bs, true));
        }
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new GenericAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(7, new GenericAITempt<EntityAnimaniaGoat>(this, 1.25, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(8, this.field_146087_bs);
        this.field_70714_bg.func_75776_a(9, new GenericAIAvoidEntity<EntityWolf>((EntityCreature)this, EntityWolf.class, 20.0f, 2.2, 2.2));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new GenericAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(11, new GenericAILookIdle<EntityAnimaniaGoat>(this));
        this.field_70714_bg.func_75776_a(12, new GenericAIFindSaltLick<EntityAnimaniaGoat>(this, 1.0, this.field_146087_bs));
        if (AnimaniaConfig.gameRules.animalsSleep) {
            this.field_70714_bg.func_75776_a(10, new GenericAISleep<EntityAnimaniaGoat>(this, 0.8, AnimaniaHelper.getBlock(AnimaniaConfig.careAndFeeding.goatBed), AnimaniaHelper.getBlock(AnimaniaConfig.careAndFeeding.goatBed2), EntityAnimaniaGoat.class));
        }
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.fedTimer = AnimaniaConfig.careAndFeeding.feedTimer + this.field_70146_Z.nextInt(100);
        this.wateredTimer = AnimaniaConfig.careAndFeeding.waterTimer + this.field_70146_Z.nextInt(100);
        this.happyTimer = 60;
        this.blinkTimer = 100 + this.field_70146_Z.nextInt(100);
        this.func_70107_b(0.0, 0.0, 0.0);
        this.func_110163_bv();
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void func_70107_b(double x, double y, double z) {
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        float f = this.field_70130_N / 2.0f;
        float f1 = this.field_70131_O;
        this.func_174826_a(new AxisAlignedBB(x - (double)f, y, z - (double)f, x + (double)f, y + (double)f1, z + (double)f));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FED, (Object)true);
        this.field_70180_af.func_187214_a(HANDFED, (Object)false);
        this.field_70180_af.func_187214_a(WATERED, (Object)true);
        this.field_70180_af.func_187214_a(MATE_UNIQUE_ID, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(RIVAL_UNIQUE_ID, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(SHEARED, (Object)false);
        this.field_70180_af.func_187214_a(SHEARED_TIMER, (Object)(AnimaniaConfig.careAndFeeding.woolRegrowthTimer + this.field_70146_Z.nextInt(500)));
        this.field_70180_af.func_187214_a(SPOOKED, (Object)false);
        this.field_70180_af.func_187214_a(SPOOKED_TIMER, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(AGE, (Object)0);
        this.field_70180_af.func_187214_a(SLEEPING, (Object)false);
        this.field_70180_af.func_187214_a(SLEEPTIMER, (Object)Float.valueOf(0.0f));
    }

    protected ResourceLocation func_184647_J() {
        return this instanceof EntityKidBase ? null : (this.goatType.isPrime ? new ResourceLocation("animania", "goat_prime") : new ResourceLocation("animania", "goat_regular"));
    }

    protected void func_175505_a(EntityPlayer player, ItemStack stack) {
        this.setFed(true);
        this.setHandFed(true);
        this.field_146087_bs.func_75249_e();
        this.eatTimer = 80;
        player.func_71064_a(this.goatType.getAchievement(), 1);
        if (!player.func_184812_l_()) {
            stack.func_190918_g(1);
        }
    }

    public void setSpooked(boolean spooked) {
        this.field_70180_af.func_187227_b(SPOOKED, (Object)spooked);
    }

    public boolean func_70877_b(@Nullable ItemStack stack) {
        return this.mateable && stack != ItemStack.field_190927_a && this.isGoatBreedingItem(stack.func_77973_b());
    }

    private boolean isGoatBreedingItem(Item itemIn) {
        return TEMPTATION_ITEMS.contains(itemIn) || itemIn == Item.func_150898_a((Block)Blocks.field_150327_N) || itemIn == Item.func_150898_a((Block)Blocks.field_150328_O);
    }

    public boolean getSpooked() {
        try {
            return this.getBoolFromDataManager(SPOOKED);
        }
        catch (Exception e) {
            return false;
        }
    }

    public Float getSpookedTimer() {
        try {
            return Float.valueOf(this.getFloatFromDataManager(SPOOKED_TIMER));
        }
        catch (Exception e) {
            return Float.valueOf(0.0f);
        }
    }

    public int getAge() {
        try {
            return this.getIntFromDataManager(AGE);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void setAge(int age) {
        this.field_70180_af.func_187227_b(AGE, (Object)age);
    }

    public void setSpookedTimer(Float timer) {
        this.field_70180_af.func_187227_b(SPOOKED_TIMER, (Object)Float.valueOf(timer.floatValue()));
    }

    @Override
    public boolean getSleeping() {
        try {
            return this.getBoolFromDataManager(SLEEPING);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void setSleeping(boolean flag) {
        if (flag) {
            this.field_70180_af.func_187227_b(SLEEPING, (Object)true);
        } else {
            this.field_70180_af.func_187227_b(SLEEPING, (Object)false);
        }
    }

    @Override
    public Float getSleepTimer() {
        try {
            return Float.valueOf(this.getFloatFromDataManager(SLEEPTIMER));
        }
        catch (Exception e) {
            return Float.valueOf(0.0f);
        }
    }

    @Override
    public void setSleepTimer(Float timer) {
        this.field_70180_af.func_187227_b(SLEEPTIMER, (Object)Float.valueOf(timer.floatValue()));
    }

    @Override
    public boolean getHandFed() {
        try {
            return this.getBoolFromDataManager(HANDFED);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void setHandFed(boolean handfed) {
        this.field_70180_af.func_187227_b(HANDFED, (Object)handfed);
    }

    @Nullable
    public UUID getMateUniqueId() {
        if (this.mateable) {
            try {
                UUID id = (UUID)((Optional)this.field_70180_af.func_187225_a(MATE_UNIQUE_ID)).orNull();
                return id;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public void setMateUniqueId(@Nullable UUID uniqueId) {
        this.field_70180_af.func_187227_b(MATE_UNIQUE_ID, (Object)Optional.fromNullable((Object)uniqueId));
    }

    @Override
    public boolean getFed() {
        try {
            return this.getBoolFromDataManager(FED);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void setFed(boolean fed) {
        if (fed) {
            this.field_70180_af.func_187227_b(FED, (Object)true);
            this.fedTimer = AnimaniaConfig.careAndFeeding.feedTimer + this.field_70146_Z.nextInt(100);
            this.func_70606_j(this.func_110143_aJ() + 1.0f);
        } else {
            this.field_70180_af.func_187227_b(FED, (Object)false);
        }
    }

    @Override
    public boolean getWatered() {
        try {
            return this.getBoolFromDataManager(WATERED);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void setWatered(boolean watered) {
        if (watered) {
            this.field_70180_af.func_187227_b(WATERED, (Object)true);
            this.wateredTimer = AnimaniaConfig.careAndFeeding.waterTimer + this.field_70146_Z.nextInt(100);
        } else {
            this.field_70180_af.func_187227_b(WATERED, (Object)false);
        }
    }

    protected void func_70619_bc() {
        this.eatTimer = this.field_146087_bs.getEatingGrassTimer();
        super.func_70619_bc();
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected Item func_146068_u() {
        return Items.field_151116_aA;
    }

    public void func_70636_d() {
        boolean sheared;
        if (!this.hasRemovedBOP && Loader.isModLoaded((String)"biomesoplenty")) {
            Iterator it = this.field_70714_bg.field_75782_a.iterator();
            while (it.hasNext()) {
                EntityAITasks.EntityAITaskEntry entry = (EntityAITasks.EntityAITaskEntry)it.next();
                EntityAIBase ai = entry.field_75733_a;
                try {
                    if (!Class.forName("biomesoplenty.common.entities.ai.EntityAIEatBOPGrass").isInstance(ai)) continue;
                    entry.field_188524_c = false;
                    ai.func_75251_c();
                    it.remove();
                }
                catch (Exception exception) {}
            }
            this.hasRemovedBOP = true;
        }
        if (this.getAge() == 0) {
            this.setAge(1);
        }
        if (this.field_70170_p.field_72995_K) {
            this.eatTimer = Math.max(0, this.eatTimer - 1);
        }
        if (this.blinkTimer > -1) {
            --this.blinkTimer;
            if (this.blinkTimer == 0) {
                this.blinkTimer = 100 + this.field_70146_Z.nextInt(100);
            }
        }
        if (this.getSpooked()) {
            if (this.getSpookedTimer().floatValue() == 1.0f) {
                this.func_70637_d(true);
            } else {
                this.func_70637_d(false);
            }
            this.func_70661_as().func_75499_g();
            this.func_94061_f(true);
            this.setSpookedTimer(Float.valueOf(this.getSpookedTimer().floatValue() - 0.01f));
            if (this.getSpookedTimer().floatValue() <= 0.2f && this.getSpookedTimer().floatValue() > 0.1f) {
                this.func_70637_d(true);
            } else if (this.getSpookedTimer().floatValue() <= 0.0f) {
                this.setSpooked(false);
                this.setSpookedTimer(Float.valueOf(0.0f));
                this.func_94061_f(false);
                this.func_70637_d(false);
            }
        }
        if (this.fedTimer > -1 && !AnimaniaConfig.gameRules.ambianceMode) {
            --this.fedTimer;
            if (this.fedTimer == 0) {
                this.setFed(false);
            }
        }
        if (this.wateredTimer > -1) {
            --this.wateredTimer;
            if (this.wateredTimer == 0 && !AnimaniaConfig.gameRules.ambianceMode) {
                this.setWatered(false);
            }
        }
        boolean fed = this.getFed();
        boolean watered = this.getWatered();
        if (!fed && !watered) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 2, 1, false, false));
            if (AnimaniaConfig.gameRules.animalsStarve) {
                if (this.damageTimer >= AnimaniaConfig.careAndFeeding.starvationTimer) {
                    this.func_70097_a(DamageSource.field_76366_f, 4.0f);
                    this.damageTimer = 0;
                }
                ++this.damageTimer;
            }
        } else if (!fed || !watered) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 2, 0, false, false));
        }
        if (this.happyTimer > -1) {
            --this.happyTimer;
            if (this.happyTimer == 0) {
                this.happyTimer = 60;
                if (!this.getFed() && !this.getWatered() && !this.getSleeping() && this.getHandFed() && AnimaniaConfig.gameRules.showUnhappyParticles) {
                    double d = this.field_70146_Z.nextGaussian() * 0.001;
                    double d1 = this.field_70146_Z.nextGaussian() * 0.001;
                    double d2 = this.field_70146_Z.nextGaussian() * 0.001;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N) - (double)this.field_70130_N, this.field_70163_u + 1.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N) - (double)this.field_70130_N, d, d1, d2, new int[0]);
                }
            }
        }
        if (sheared = this.func_70892_o()) {
            int shearedTimer = this.getWoolRegrowthTimer();
            this.setWoolRegrowthTimer(--shearedTimer);
            if (shearedTimer < 0) {
                this.func_70893_e(false);
            }
        }
        super.func_70636_d();
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        EntityPlayer entityplayer = player;
        if (stack.func_77973_b() instanceof ItemShears && !this.func_70892_o() && !this.func_70631_g_() && (this instanceof EntityBuckAngora || this instanceof EntityDoeAngora)) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_70893_e(true);
                int i = 1 + this.field_70146_Z.nextInt(2);
                for (int j = 0; j < i; ++j) {
                    EntityItem entityitem = this.func_70099_a(new ItemStack(Item.func_150898_a((Block)Blocks.field_150325_L), 1), 1.0f);
                    entityitem.field_70181_x += (double)(this.field_70146_Z.nextFloat() * 0.05f);
                    entityitem.field_70159_w += (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f);
                    entityitem.field_70179_y += (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f);
                }
            }
            player.func_184609_a(hand);
            stack.func_77972_a(1, (EntityLivingBase)player);
            this.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, 1.0f);
            if (this.getSleeping()) {
                this.setSleeping(false);
            }
            return true;
        }
        if (stack.func_77973_b() instanceof ItemDye) {
            return true;
        }
        if (stack.func_77973_b() instanceof ItemShears) {
            return true;
        }
        if (stack != ItemStack.field_190927_a && AnimaniaHelper.isWaterContainer(stack) && !this.getSleeping()) {
            if (!player.func_184812_l_()) {
                ItemStack emptied = AnimaniaHelper.emptyContainer(stack);
                stack.func_190918_g(1);
                AnimaniaHelper.addItem(player, emptied);
            }
            this.eatTimer = 40;
            this.field_146087_bs.func_75249_e();
            this.setWatered(true);
            this.func_146082_f(player);
            return true;
        }
        if (this.func_70877_b(stack)) {
            this.func_175505_a(player, stack);
            this.func_146082_f(player);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public void func_70615_aA() {
    }

    public void func_146082_f(EntityPlayer player) {
        if (!this.getSleeping()) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)18);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.eatTimer = 160;
        } else {
            super.func_70103_a(id);
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.getMateUniqueId() != null) {
            compound.func_74778_a("MateUUID", this.getMateUniqueId().toString());
        }
        compound.func_74757_a("Fed", this.getFed());
        compound.func_74757_a("Handfed", this.getHandFed());
        compound.func_74757_a("Watered", this.getWatered());
        compound.func_74757_a("Sheared", this.func_70892_o());
        compound.func_74757_a("Spooked", this.getSpooked());
        compound.func_74768_a("Age", this.getAge());
    }

    public boolean func_70892_o() {
        try {
            return this.getBoolFromDataManager(SHEARED);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void func_70893_e(boolean sheared) {
        if (sheared) {
            this.field_70180_af.func_187227_b(SHEARED, (Object)true);
            this.setWoolRegrowthTimer(AnimaniaConfig.careAndFeeding.woolRegrowthTimer + this.field_70146_Z.nextInt(500));
        } else {
            this.field_70180_af.func_187227_b(SHEARED, (Object)false);
        }
    }

    public int getWoolRegrowthTimer() {
        try {
            return this.getIntFromDataManager(SHEARED_TIMER);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void setWoolRegrowthTimer(int time) {
        this.field_70180_af.func_187227_b(SHEARED_TIMER, (Object)time);
    }

    public void func_70037_a(NBTTagCompound compound) {
        String s;
        super.func_70037_a(compound);
        if (compound.func_150297_b("MateUUID", 8)) {
            s = compound.func_74779_i("MateUUID");
        } else {
            String s1 = compound.func_74779_i("Mate");
            s = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s1);
        }
        if (!s.isEmpty()) {
            this.setMateUniqueId(UUID.fromString(s));
        }
        this.setFed(compound.func_74767_n("Fed"));
        this.setHandFed(compound.func_74767_n("Handfed"));
        this.setWatered(compound.func_74767_n("Watered"));
        this.func_70893_e(compound.func_74767_n("Sheared"));
        this.setSpooked(compound.func_74767_n("Spooked"));
        this.setAge(compound.func_74762_e("Age"));
    }

    public EntityAnimaniaGoat createChild(EntityAgeable ageable) {
        return null;
    }

    @Override
    public Item getSpawnEgg() {
        return ItemEntityEgg.ANIMAL_EGGS.get(new AnimalContainer(this.goatType, this.gender));
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(this.getSpawnEgg());
    }

    @Override
    public int getPrimaryEggColor() {
        return 0;
    }

    @Override
    public int getSecondaryEggColor() {
        return 0;
    }

    @Override
    public EntityGender getEntityGender() {
        return this.gender;
    }

    public boolean getBoolFromDataManager(DataParameter<Boolean> key) {
        try {
            return (Boolean)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return false;
        }
    }

    public byte getByteFromDataManager(DataParameter<Byte> key) {
        try {
            return (Byte)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int getIntFromDataManager(DataParameter<Integer> key) {
        try {
            return (Integer)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public float getFloatFromDataManager(DataParameter<Float> key) {
        try {
            return ((Float)this.func_184212_Q().func_187225_a(key)).floatValue();
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public String getStringFromDataManager(DataParameter<String> key) {
        try {
            return (String)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Optional<UUID> getUUIDFromDataManager(DataParameter<Optional<UUID>> key) {
        try {
            return (Optional)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public ItemStack getItemStackFromDataManager(DataParameter<ItemStack> key) {
        try {
            return (ItemStack)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return ItemStack.field_190927_a;
        }
    }

    public Optional<BlockPos> getBlockPosFromDataManager(DataParameter<Optional<BlockPos>> key) {
        try {
            return (Optional)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return Optional.absent();
        }
    }

    @Override
    public Set<Item> getFoodItems() {
        return TEMPTATION_ITEMS;
    }

    @Override
    public void setSleepingPos(BlockPos pos) {
    }

    @Override
    public BlockPos getSleepingPos() {
        return null;
    }

    @Override
    public int getBlinkTimer() {
        return this.blinkTimer;
    }
}

