/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.mekores.ore;

import com.google.common.collect.Sets;
import io.github.phantamanta44.mekores.CommonProxy;
import io.github.phantamanta44.mekores.MekOres;
import io.github.phantamanta44.mekores.client.ClientEventListener;
import io.github.phantamanta44.mekores.constant.LangConst;
import io.github.phantamanta44.mekores.util.OreDictHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;

public enum OreType {
    URANIUM("Uranium"),
    YELLORIUM("Yellorium"),
    NICKEL("Nickel"),
    PLATINUM("Platinum"),
    IRIDIUM("Iridium"),
    MITHRIL("Mithril"),
    ALUMINUM("Aluminum"),
    COBALT("Cobalt"),
    ARDITE("Ardite"),
    ASTRAL_STARMETAL("AstralStarmetal"),
    DRACONIUM("Draconium"),
    BERYLLIUM("Beryllium"),
    BORON("Boron"),
    LITHIUM("Lithium"),
    MAGNESIUM("Magnesium"),
    THORIUM("Thorium"),
    ZIRCONIUM("Zirconium"),
    TITANIUM("Titanium"),
    DESH("Desh"),
    CARBON("Carbon"),
    DARK_IRON("DarkIron"),
    TUNGSTEN("Tungsten"),
    ZINC("Zinc"),
    MERCURY("Mercury"),
    PALLADIUM("Palladium"),
    ADAMANTINE("Adamantine"),
    ALDUORITE("Alduorite"),
    ASTRAL_SILVER("AstralSilver"),
    ATLARUS("Atlarus"),
    CARMOT("Carmot"),
    CERUCLASE("Ceruclase"),
    DEEP_IRON("DeepIron"),
    EXIMITE("Eximite"),
    IGNATIUS("Ignatius"),
    INFUSCOLIUM("Infuscolium"),
    KALENDRITE("Kalendrite"),
    LEMURITE("Lemurite"),
    MANGANESE("Manganese"),
    MEUTOITE("Meutoite"),
    MIDASIUM("Midasium"),
    ORICHALCUM("Orichalcum"),
    OURECLASE("Oureclase"),
    PROMETHEUM("Prometheum"),
    RUBRACIUM("Rubracium"),
    SANGUINITE("Sanguinite"),
    SHADOW_IRON("ShadowIron"),
    VULCANITE("Vulcanite"),
    VYROXERES("Vyroxeres"),
    TIBERIUM("Tiberium"),
    AURORIUM("Aurorium"),
    DURANITE("Duranite"),
    VALYRIUM("Valyrium"),
    VIBRANIUM("Vibranium"),
    KARMESINE("Karmesine"),
    OVIUM("Ovium"),
    JAUXUM("Jauxum"),
    URU("Uru"),
    OSRAM("Osram"),
    EEZO("Eezo"),
    ABYSSUM("Abyssum"),
    VANADIUM("Vanadium"),
    BARONYTE("Baronyte"),
    BLAZIUM("Blazium"),
    ELECANIUM("Elecanium"),
    EMBERSTONE("Emberstone"),
    GHASTLY("Ghastly"),
    GHOULISH("Ghoulish"),
    LIMONITE("Limonite"),
    LYON("Lyon"),
    MYSTITE("Mystite"),
    ROSITE("Rosite"),
    SHYRESTONE("Shyrestone"),
    VARSIUM("Varsium"),
    TRITANIUM("Tritanium");

    public final String key;
    @Nullable
    private Boolean valid = null;
    private int colour = -1;
    private static final Set<String> BLACKLIST;

    private OreType(String key) {
        this.key = key;
    }

    public String getName() {
        return this.name().toLowerCase();
    }

    public String getLocalizedName() {
        return LangConst.get("mekores.ore." + this.getName(), new Object[0]);
    }

    public boolean isValid() {
        return this.valid == null ? (this.valid = Boolean.valueOf(OreType.isKeyValid(this.key))) : this.valid;
    }

    public void setValid() {
        this.valid = true;
    }

    public int getColour() {
        return this.colour;
    }

    @Nullable
    public static OreType getByKey(String key) {
        return Arrays.stream(OreType.values()).filter(v -> v.key.equals(key)).findAny().orElse(null);
    }

    public static void cacheColours() {
        MekOres.LOGGER.info("Caching ore colours...");
        long time = -System.currentTimeMillis();
        for (OreType type : OreType.values()) {
            if (!type.isValid()) continue;
            ItemStack stack = OreDictHelper.getStack("ingot" + type.key, 1);
            if (stack == null) {
                stack = OreDictHelper.getStack("dust" + type.key, 1);
            }
            if (stack == null) continue;
            try {
                IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_184393_a(stack, null, null);
                TextureAtlasSprite sprite = model.func_177554_e();
                int[] atlas = ClientEventListener.getAtlas();
                ArrayList<int[]> rgbData = new ArrayList<int[]>();
                ArrayList<float[]> hsvData = new ArrayList<float[]>();
                float hMean = 0.0f;
                float sMean = 0.0f;
                float bMean = 0.0f;
                float weightTotal = 0.0f;
                for (int y = 0; y < sprite.func_94216_b(); ++y) {
                    for (int x = 0; x < sprite.func_94211_a(); ++x) {
                        int index = (y + sprite.func_110967_i()) * ClientEventListener.getAtlasWidth() + x + sprite.func_130010_a();
                        if ((atlas[index] & 0xFF) <= 127) continue;
                        int[] rgb = new int[]{atlas[index] >> 8 & 0xFF, atlas[index] >> 16 & 0xFF, atlas[index] >> 24 & 0xFF};
                        rgbData.add(rgb);
                        float[] hsb = Color.RGBtoHSB(rgb[0], rgb[1], rgb[2], null);
                        float weight = OreType.calcWeight(hsb);
                        hsvData.add(hsb);
                        hMean += hsb[0] * weight;
                        sMean += hsb[1] * weight;
                        bMean += hsb[2] * weight;
                        weightTotal += weight;
                    }
                }
                if (hsvData.size() == 0) {
                    MekOres.LOGGER.warn("Using fallback colour; no suitably opaque pixels: " + type.name());
                    type.colour = OreType.computeFallbackColour(atlas, sprite);
                    continue;
                }
                double hStdDev = OreType.weightedStdDev(hsvData, 0, hMean /= weightTotal, weightTotal);
                double sStdDev = OreType.weightedStdDev(hsvData, 1, sMean /= weightTotal, weightTotal);
                double bStdDev = OreType.weightedStdDev(hsvData, 2, bMean /= weightTotal, weightTotal);
                int rBin = 0;
                int gBin = 0;
                int bBin = 0;
                int total = 0;
                for (int i = 0; i < hsvData.size(); ++i) {
                    float[] hsv = (float[])hsvData.get(i);
                    if (!OreType.withinStdDev(hsv[0], hMean, hStdDev) || !OreType.withinStdDev(hsv[1], sMean, sStdDev) || !OreType.withinStdDev(hsv[2], bMean, bStdDev)) continue;
                    int[] rgb = (int[])rgbData.get(i);
                    rBin += rgb[0];
                    gBin += rgb[1];
                    bBin += rgb[2];
                    ++total;
                }
                if (total == 0) {
                    MekOres.LOGGER.warn("Using fallback colour; no pixels in 1 stddev: " + type.name());
                    type.colour = OreType.computeFallbackColour(atlas, sprite);
                    continue;
                }
                type.colour = rBin / total << 16 | gBin / total << 8 | bBin / total;
            }
            catch (Exception e) {
                MekOres.LOGGER.warn("Failed to calculate colour for " + type.name(), (Throwable)e);
            }
        }
        MekOres.LOGGER.info("Computed ore colours in {} ms", (Object)(time += System.currentTimeMillis()));
    }

    private static float calcWeight(float[] hsb) {
        return hsb[2] > 0.8f ? 1.0f : (hsb[2] > 0.5f ? 0.5f : 0.1f);
    }

    private static double weightedStdDev(List<float[]> data, int index, float mean, float weightTotal) {
        float acc = 0.0f;
        for (float[] datum : data) {
            float diff = datum[index] - mean;
            acc += diff * diff * OreType.calcWeight(datum);
        }
        return Math.sqrt(acc * (float)data.size() / ((float)(data.size() - 1) * weightTotal));
    }

    private static boolean withinStdDev(float datum, float mean, double stdDev) {
        return (double)Math.abs(datum - mean) <= stdDev;
    }

    private static int computeFallbackColour(int[] atlas, TextureAtlasSprite sprite) {
        int rBin = 0;
        int gBin = 0;
        int bBin = 0;
        int total = 0;
        for (int y = 0; y < sprite.func_94216_b(); ++y) {
            for (int x = 0; x < sprite.func_94211_a(); ++x) {
                int index = (y + sprite.func_110967_i()) * ClientEventListener.getAtlasWidth() + x + sprite.func_130010_a();
                if ((atlas[index] & 0xFF) <= 0) continue;
                rBin += atlas[index] >> 8 & 0xFF;
                gBin += atlas[index] >> 16 & 0xFF;
                bBin += atlas[index] >> 24 & 0xFF;
                ++total;
            }
        }
        if (total == 0) {
            MekOres.LOGGER.warn("Using a bland shade of grey; no non-empty pixels!");
            return -12434878;
        }
        return rBin / total << 16 | gBin / total << 8 | bBin / total;
    }

    public static boolean isKeyValid(String key) {
        if (OreDictHelper.exists("gem" + key) || BLACKLIST.contains(key)) {
            return false;
        }
        return !(!OreDictHelper.exists("ore" + key) || !OreDictHelper.exists("ingot" + key) && !OreDictHelper.exists("dust" + key) || OreDictHelper.exists("crystal" + key) && OreDictHelper.exists("shard" + key) && OreDictHelper.exists("clump" + key) && OreDictHelper.exists("dustDirty" + key));
    }

    static {
        BLACKLIST = Sets.newHashSet((Object[])new String[]{"Iron", "Gold", "Copper", "Tin", "Silver", "Lead", "Osmium", "Bitumen", "Potash", "Coal", "Sulfur", "Sulphur", "Redstone", "Electrotine"});
        BLACKLIST.addAll(Arrays.asList(CommonProxy.CONFIG.blacklist));
    }
}

