/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import net.minecraft.world.World;

public class TimeHelper {
    public static long systemTime() {
        return System.currentTimeMillis();
    }

    public static long systemTicks() {
        return System.currentTimeMillis() / 50L;
    }

    public static boolean isSystemTimeElapsed(long oldTime, long millis) {
        return TimeHelper.systemTime() - oldTime >= millis;
    }

    public static long worldTicks(World world) {
        return world.func_82737_E();
    }

    public static int tickFromSecond(int second) {
        return second * 20;
    }

    public static int tickFromMinute(int minute) {
        return minute * 1200;
    }

    public static int tickFromHour(int hour) {
        return hour * 72000;
    }

    public static boolean atInterval(long ticksExisted, int tick) {
        return ticksExisted > 0L && ticksExisted % (long)tick == 0L;
    }

    public static long minuteElapsed(World world, long oldTime) {
        return TimeHelper.minuteElapsed(TimeHelper.worldTicks(world), oldTime);
    }

    public static long minuteElapsed(long nowTime, long oldTime) {
        return (nowTime - oldTime) / 1200L;
    }

    public static boolean isMinuteElapsed(World world, long oldTime, int minute) {
        return TimeHelper.isMinuteElapsed(TimeHelper.worldTicks(world), oldTime, minute);
    }

    public static boolean isMinuteElapsed(long nowTime, long oldTime, int minute) {
        return nowTime - oldTime >= (long)TimeHelper.tickFromMinute(minute);
    }
}

