/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.google.common.base.MoreObjects;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Location {
    public int x;
    public int y;
    public int z;
    public int dim;
    public static final Location ORIGIN = new Location(BlockPos.field_177992_a, Integer.MIN_VALUE);

    public Location(BlockPos pos, int dim) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), dim);
    }

    public Location(BlockPos pos, World world) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), Location.getWorldId(world));
    }

    public Location(int x, int y, int z, int dim) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.dim = dim;
    }

    public Location(double x, double y, double z, int dim) {
        this((int)x, (int)y, (int)z, dim);
    }

    public Location(Entity entity) {
        this(entity.func_180425_c(), entity.field_70170_p);
    }

    public BlockPos getPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public boolean equals(Location loc) {
        return loc.x == this.x && loc.y == this.y && loc.z == this.z && loc.dim == this.dim;
    }

    public boolean isOrigin() {
        return this.equals(ORIGIN);
    }

    public boolean isSameDimension(World world) {
        return this.dim == Location.getWorldId(world);
    }

    public double getDistanceSq(Location loc) {
        return this.getDistanceSq(loc.getPos());
    }

    public double getDistanceSq(BlockPos pos) {
        double d0 = this.x - pos.func_177958_n();
        double d1 = this.y - pos.func_177956_o();
        double d2 = this.z - pos.func_177952_p();
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public boolean isInRange(BlockPos pos, int range) {
        return this.getDistanceSq(pos) <= (double)(range * range);
    }

    public boolean isInRangeAndDimension(Location loc, int range) {
        return this.dim == loc.dim && this.isInRange(loc.getPos(), range);
    }

    private static int getWorldId(World world) {
        return world.field_73011_w.getDimension();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("x", this.x).add("y", this.y).add("z", this.z).add("dim", this.dim).toString();
    }
}

