/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.capability;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;

public class PerkBoneCollector
extends Perk {
    PerkBoneCollector() {
        super("bone_collector", new ResourceLocation("minecraft", "textures/items/bone.png"));
    }

    @Override
    public int getLevelMax() {
        return 5;
    }

    @Override
    public boolean isDisabled() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getTooltip(int level, int actualLevel, int levelWithBonus) {
        if (level == actualLevel || actualLevel == 0 && level == 1 || level == levelWithBonus) {
            return "+" + level * 10 + "% " + LangKey.makeClientTranslation("tombstone.perk.bone_collector.desc", new Object[0]);
        }
        if (level == actualLevel + 1) {
            return "+" + level * 10 + "%";
        }
        return "";
    }

    @Override
    public int getCost(int level) {
        return level > 0 ? 1 : 0;
    }

    @Override
    public int getLevelBonus(EntityPlayer player) {
        return Helper.isDateAroundHalloween() ? 2 : 0;
    }
}

