/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.gui;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import squeek.applecore.api.food.FoodValues;
import squeek.spiceoflife.ModConfig;
import squeek.spiceoflife.foodtracker.FoodHistory;
import squeek.spiceoflife.foodtracker.FoodModifier;
import squeek.spiceoflife.foodtracker.foodgroups.FoodGroup;
import squeek.spiceoflife.foodtracker.foodgroups.FoodGroupRegistry;
import squeek.spiceoflife.helpers.ColorHelper;
import squeek.spiceoflife.helpers.FoodHelper;
import squeek.spiceoflife.helpers.KeyHelper;
import squeek.spiceoflife.helpers.StringHelper;

@SideOnly(value=Side.CLIENT)
public class TooltipHandler {
    private static final DecimalFormat df = new DecimalFormat("##.##");
    private static final FoodGroupComparator foodGroupComparator = new FoodGroupComparator();

    public static Set<FoodGroup> getFoodGroupsForDisplay(Set<FoodGroup> foodGroups) {
        TreeSet<FoodGroup> visibleFoodGroups = new TreeSet<FoodGroup>(foodGroupComparator);
        for (FoodGroup foodGroup : foodGroups) {
            if (foodGroup.hidden()) continue;
            visibleFoodGroups.add(foodGroup);
        }
        return visibleFoodGroups;
    }

    public static String joinFoodGroupsForDisplay(Set<FoodGroup> foodGroups, String delimiter, String resetFormatting) {
        ArrayList<String> stringsToJoin = new ArrayList<String>(foodGroups.size());
        for (FoodGroup foodGroup : foodGroups) {
            stringsToJoin.add(foodGroup.formatString(TextFormatting.ITALIC.toString() + foodGroup) + resetFormatting);
        }
        return StringHelper.join(stringsToJoin, delimiter);
    }

    public String getNutritionalValueString(float foodModifier) {
        return ColorHelper.getRelativeColor(foodModifier, 0.0, 1.0) + df.format(foodModifier * 100.0f) + '%';
    }

    public String getEatenRecentlyTooltip(FoodHistory foodHistory, @Nonnull ItemStack itemStack, FoodGroup foodGroup, boolean shouldShowNutritionalValue) {
        String nutritionalValue;
        int count = foodHistory.getFoodCountForFoodGroup(itemStack, foodGroup);
        String prefix = (foodGroup != null ? foodGroup.formatString(TextFormatting.ITALIC.toString() + foodGroup) + ' ' : "") + TextFormatting.RESET.toString() + TextFormatting.DARK_AQUA.toString() + TextFormatting.ITALIC;
        String string = nutritionalValue = shouldShowNutritionalValue ? TextFormatting.DARK_GRAY + " [" + this.getNutritionalValueString(FoodModifier.getFoodGroupModifier(foodHistory, itemStack, foodGroup)) + TextFormatting.DARK_GRAY + ']' : "";
        String eatenRecently = count > 0 ? I18n.func_135052_a((String)("spiceoflife.tooltip.eaten.recently" + (ModConfig.USE_HUNGER_QUEUE ? ".hunger" : (ModConfig.USE_TIME_QUEUE ? ".time" : ""))), (Object[])new Object[]{StringHelper.getQuantityDescriptor(count), ModConfig.USE_HUNGER_QUEUE ? StringHelper.hungerHistoryLength(ModConfig.FOOD_HISTORY_LENGTH) : Integer.valueOf(ModConfig.FOOD_HISTORY_LENGTH)}) : I18n.func_135052_a((String)"spiceoflife.tooltip.not.eaten.recently", (Object[])new Object[0]);
        return prefix + (foodGroup != null ? StringHelper.decapitalize(eatenRecently, StringHelper.getMinecraftLocale()) : eatenRecently) + nutritionalValue;
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        if (ModConfig.FOOD_MODIFIER_ENABLED && event.getEntityPlayer() != null && !event.getItemStack().func_190926_b() && FoodHelper.isValidFood(event.getItemStack())) {
            int totalFoodEaten = FoodHistory.get((EntityPlayer)event.getEntityPlayer()).totalFoodsEatenAllTime;
            ArrayList<String> toolTipStringsToAdd = new ArrayList<String>();
            Set<FoodGroup> foodGroups = FoodGroupRegistry.getFoodGroupsForFood(event.getItemStack());
            Set<FoodGroup> visibleFoodGroups = TooltipHandler.getFoodGroupsForDisplay(foodGroups);
            boolean canDiminish = FoodHelper.canFoodDiminish(event.getItemStack());
            if (!visibleFoodGroups.isEmpty()) {
                String foodGroupString = visibleFoodGroups.size() > 1 ? I18n.func_135052_a((String)"spiceoflife.tooltip.food.groups", (Object[])new Object[0]) : I18n.func_135052_a((String)"spiceoflife.tooltip.food.group", (Object[])new Object[0]);
                String joinedFoodGroups = TooltipHandler.joinFoodGroupsForDisplay(visibleFoodGroups, ", ", TextFormatting.GRAY.toString());
                toolTipStringsToAdd.add(TextFormatting.DARK_AQUA.toString() + TextFormatting.ITALIC + foodGroupString + TextFormatting.GRAY + TextFormatting.ITALIC + joinedFoodGroups);
            }
            if (ModConfig.FOOD_EATEN_THRESHOLD > 0 && totalFoodEaten < ModConfig.FOOD_EATEN_THRESHOLD) {
                int timesUntilMeetsThreshold = ModConfig.FOOD_EATEN_THRESHOLD - totalFoodEaten;
                toolTipStringsToAdd.add(TextFormatting.DARK_AQUA.toString() + TextFormatting.ITALIC + I18n.func_135052_a((String)"spiceoflife.tooltip.food.until.enabled.1", (Object[])new Object[0]));
                toolTipStringsToAdd.add(TextFormatting.DARK_AQUA.toString() + TextFormatting.ITALIC + I18n.func_135052_a((String)"spiceoflife.tooltip.food.until.enabled.2", (Object[])new Object[]{timesUntilMeetsThreshold, timesUntilMeetsThreshold == 1 ? I18n.func_135052_a((String)"spiceoflife.tooltip.times.singular", (Object[])new Object[0]) : I18n.func_135052_a((String)"spiceoflife.tooltip.times.plural", (Object[])new Object[0])}));
            } else {
                FoodHistory foodHistory = FoodHistory.get(event.getEntityPlayer());
                float foodModifier = FoodModifier.getFoodModifier(foodHistory, event.getItemStack());
                FoodValues foodValues = FoodValues.get((ItemStack)event.getItemStack(), (EntityPlayer)event.getEntityPlayer());
                boolean foodOrItsFoodGroupsEatenRecently = foodHistory.containsFoodOrItsFoodGroups(event.getItemStack());
                if (canDiminish && (foodOrItsFoodGroupsEatenRecently || foodModifier != 1.0f)) {
                    toolTipStringsToAdd.add(0, TextFormatting.GRAY + I18n.func_135052_a((String)"spiceoflife.tooltip.nutritional.value", (Object[])new Object[0]) + this.getNutritionalValueString(foodModifier) + (foodValues.hunger == 0 && foodModifier != 0.0f ? TextFormatting.DARK_RED + " (" + foodValues.hunger + ' ' + I18n.func_135052_a((String)"spiceoflife.tooltip.hunger", (Object[])new Object[0]) + ')' : ""));
                }
                boolean shouldShowPressShift = visibleFoodGroups.size() > 1 && !KeyHelper.isShiftKeyDown();
                boolean shouldShowFoodGroupDetails = visibleFoodGroups.size() <= 1 || KeyHelper.isShiftKeyDown();
                String bulletPoint = TextFormatting.DARK_GRAY + "- " + TextFormatting.GRAY;
                if (shouldShowPressShift) {
                    toolTipStringsToAdd.add(bulletPoint + TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"spiceoflife.tooltip.hold.key.for.details", (Object[])new Object[]{TextFormatting.YELLOW.toString() + TextFormatting.ITALIC + "Shift" + TextFormatting.RESET + TextFormatting.DARK_GRAY}));
                }
                if (shouldShowFoodGroupDetails) {
                    int foodGroupsToShow = Math.max(1, visibleFoodGroups.size());
                    FoodGroup[] visibleFoodGroupsArray = visibleFoodGroups.toArray(new FoodGroup[visibleFoodGroups.size()]);
                    for (int i = 0; i < foodGroupsToShow; ++i) {
                        FoodGroup foodGroup = i < visibleFoodGroupsArray.length ? visibleFoodGroupsArray[i] : null;
                        boolean shouldShowNutritionalValue = foodGroupsToShow > 1;
                        String prefix = foodGroupsToShow > 1 ? bulletPoint : "";
                        toolTipStringsToAdd.add(prefix + this.getEatenRecentlyTooltip(foodHistory, event.getItemStack(), foodGroup, shouldShowNutritionalValue));
                    }
                }
            }
            event.getToolTip().addAll(toolTipStringsToAdd);
        }
    }

    static class FoodGroupComparator
    implements Comparator<FoodGroup>,
    Serializable {
        private static final long serialVersionUID = -4556648064321616158L;

        FoodGroupComparator() {
        }

        @Override
        public int compare(FoodGroup a, FoodGroup b) {
            return a.getLocalizedName().compareToIgnoreCase(b.getLocalizedName());
        }
    }
}

