/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.foodtracker;

import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import squeek.applecore.api.food.FoodValues;
import squeek.spiceoflife.ModConfig;
import squeek.spiceoflife.compat.IByteIO;
import squeek.spiceoflife.foodtracker.FoodHistory;
import squeek.spiceoflife.foodtracker.foodgroups.FoodGroup;
import squeek.spiceoflife.foodtracker.foodgroups.FoodGroupRegistry;
import squeek.spiceoflife.interfaces.IPackable;
import squeek.spiceoflife.interfaces.ISaveable;

public class FoodEaten
implements IPackable,
ISaveable {
    public FoodValues foodValues = dummyFoodValues;
    @Nonnull
    public ItemStack itemStack = ItemStack.field_190927_a;
    public long worldTimeEaten = 0L;
    public long playerTimeEaten = 0L;
    public static final FoodValues dummyFoodValues = new FoodValues(0, 0.0f);

    public FoodEaten() {
    }

    public FoodEaten(@Nonnull ItemStack food, EntityPlayer eater) {
        this.itemStack = food.func_77946_l();
        this.itemStack.func_190920_e(Math.max(1, this.itemStack.func_190916_E()));
        this.playerTimeEaten = FoodHistory.get((EntityPlayer)eater).ticksActive;
        this.worldTimeEaten = eater.func_130014_f_().func_82737_E();
    }

    public Set<FoodGroup> getFoodGroups() {
        return FoodGroupRegistry.getFoodGroupsForFood(this.itemStack);
    }

    public long elapsedTime(long absoluteTime, long relativeTime) {
        if (ModConfig.PROGRESS_TIME_WHILE_LOGGED_OFF) {
            return absoluteTime - this.worldTimeEaten;
        }
        return relativeTime - this.playerTimeEaten;
    }

    @Override
    public void writeToNBTData(NBTTagCompound nbtFood) {
        if (this.itemStack != ItemStack.field_190927_a) {
            this.itemStack.func_77955_b(nbtFood);
        }
        if (this.foodValues != null && this.foodValues.hunger != 0) {
            nbtFood.func_74777_a("Hunger", (short)this.foodValues.hunger);
        }
        if (this.foodValues != null && this.foodValues.saturationModifier != 0.0f) {
            nbtFood.func_74776_a("Saturation", this.foodValues.saturationModifier);
        }
        if (this.worldTimeEaten != 0L) {
            nbtFood.func_74772_a("WorldTime", this.worldTimeEaten);
        }
        if (this.playerTimeEaten != 0L) {
            nbtFood.func_74772_a("PlayerTime", this.playerTimeEaten);
        }
    }

    @Override
    public void readFromNBTData(NBTTagCompound nbtFood) {
        this.itemStack = new ItemStack(nbtFood);
        this.foodValues = new FoodValues((int)nbtFood.func_74765_d("Hunger"), nbtFood.func_74760_g("Saturation"));
        this.worldTimeEaten = nbtFood.func_74763_f("WorldTime");
        this.playerTimeEaten = nbtFood.func_74763_f("PlayerTime");
    }

    public static FoodEaten loadFromNBTData(NBTTagCompound nbtFood) {
        FoodEaten foodEaten = new FoodEaten();
        foodEaten.readFromNBTData(nbtFood);
        return foodEaten;
    }

    @Override
    public void pack(IByteIO data) {
        data.writeShort(this.foodValues != null ? this.foodValues.hunger : 0);
        data.writeFloat(this.foodValues != null ? this.foodValues.saturationModifier : 0.0f);
        data.writeItemStack(this.itemStack);
        data.writeLong(this.worldTimeEaten);
        data.writeLong(this.playerTimeEaten);
    }

    @Override
    public void unpack(IByteIO data) {
        short hunger = data.readShort();
        float saturationModifier = data.readFloat();
        this.foodValues = new FoodValues((int)hunger, saturationModifier);
        this.itemStack = data.readItemStack();
        this.worldTimeEaten = data.readLong();
        this.playerTimeEaten = data.readLong();
    }
}

