/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.venus.tile;

import java.util.Random;
import micdoodle8.mods.galacticraft.core.inventory.IInventoryDefaults;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;

public class TileEntityCrashedProbe
extends TileEntity
implements IInventoryDefaults {
    private NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)6, (Object)ItemStack.field_190927_a);
    private boolean hasCoreToDrop;
    protected ResourceLocation lootTable;
    protected long lootTableSeed;

    protected void fillWithLoot(EntityPlayer player) {
        if (this.lootTable != null) {
            LootTable loottable = this.field_145850_b.func_184146_ak().func_186521_a(this.lootTable);
            this.lootTable = null;
            Random random = this.lootTableSeed == 0L ? new Random() : new Random(this.lootTableSeed);
            LootContext.Builder lootcontext$builder = new LootContext.Builder((WorldServer)this.field_145850_b);
            if (player != null) {
                lootcontext$builder.func_186469_a(player.func_184817_da());
            }
            loottable.func_186460_a((IInventory)this, random, lootcontext$builder.func_186471_a());
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.hasCoreToDrop = nbt.func_74764_b("ctd") ? nbt.func_74767_n("ctd") : true;
        if (!this.checkLootAndRead(nbt)) {
            this.stacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((NBTTagCompound)nbt, this.stacks);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("ctd", this.hasCoreToDrop);
        if (!this.checkLootAndWrite(nbt)) {
            ItemStackHelper.func_191282_a((NBTTagCompound)nbt, this.stacks);
        }
        return nbt;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public String func_70005_c_() {
        return GCCoreUtil.translate((String)"container.crashed_probe.name");
    }

    public int func_70302_i_() {
        return this.stacks.size();
    }

    public ItemStack func_70301_a(int var1) {
        this.fillWithLoot(null);
        return (ItemStack)this.stacks.get(var1);
    }

    public ItemStack func_70298_a(int index, int count) {
        this.fillWithLoot(null);
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.stacks, (int)index, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        this.fillWithLoot(null);
        ItemStack oldstack = ItemStackHelper.func_188383_a(this.stacks, (int)index);
        if (!oldstack.func_190926_b()) {
            this.func_70296_d();
        }
        return oldstack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.stacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public boolean func_191420_l() {
        this.fillWithLoot(null);
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_174888_l() {
        this.fillWithLoot(null);
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && player.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        return true;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public void setDropCore() {
        this.hasCoreToDrop = true;
    }

    public boolean getDropCore() {
        return this.hasCoreToDrop;
    }

    protected boolean checkLootAndRead(NBTTagCompound compound) {
        if (compound.func_150297_b("LootTable", 8)) {
            this.lootTable = new ResourceLocation(compound.func_74779_i("LootTable"));
            this.lootTableSeed = compound.func_74763_f("LootTableSeed");
            return true;
        }
        return false;
    }

    protected boolean checkLootAndWrite(NBTTagCompound compound) {
        if (this.lootTable != null) {
            compound.func_74778_a("LootTable", this.lootTable.toString());
            if (this.lootTableSeed != 0L) {
                compound.func_74772_a("LootTableSeed", this.lootTableSeed);
            }
            return true;
        }
        return false;
    }

    public void setLootTable(ResourceLocation lootTable, long lootTableSeed) {
        this.lootTable = lootTable;
        this.lootTableSeed = lootTableSeed;
    }
}

