/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.venus.entities;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.entity.IEntityBreathable;
import micdoodle8.mods.galacticraft.core.entities.EntityBossBase;
import micdoodle8.mods.galacticraft.core.entities.IBoss;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.planets.venus.VenusItems;
import micdoodle8.mods.galacticraft.planets.venus.entities.EntityJuicer;
import micdoodle8.mods.galacticraft.planets.venus.entities.EntityWebShot;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;

public class EntitySpiderQueen
extends EntityBossBase
implements IEntityBreathable,
IBoss,
IRangedAttackMob {
    private static final DataParameter<Byte> BURROWED_COUNT = EntityDataManager.func_187226_a(EntitySpiderQueen.class, (DataSerializer)DataSerializers.field_187191_a);
    public boolean shouldEvade;
    private List<EntityJuicer> juicersSpawned = Lists.newArrayList();
    private List<UUID> spawnedPreload;
    private int rangedAttackTime;
    private int minRangedAttackTime;
    private int maxRangedAttackTime;

    public EntitySpiderQueen(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.4f, 0.9f);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.maxRangedAttackTime = 60;
        this.minRangedAttackTime = 20;
        this.field_70158_ak = true;
    }

    public boolean func_70104_M() {
        return false;
    }

    public double func_70042_X() {
        return this.field_70131_O * 0.5f;
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateGround((EntityLiving)this, worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BURROWED_COUNT, (Object)-1);
    }

    public byte getBurrowedCount() {
        return (Byte)this.field_70180_af.func_187225_a(BURROWED_COUNT);
    }

    public void setBurrowedCount(byte count) {
        this.field_70180_af.func_187227_b(BURROWED_COUNT, (Object)count);
    }

    public void func_70071_h_() {
        EntityLivingBase attackTarget;
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && !this.shouldEvade && this.deathTicks <= 0 && (attackTarget = this.func_70638_az()) != null) {
            double dX = attackTarget.field_70165_t - this.field_70165_t;
            double dY = attackTarget.func_174813_aQ().field_72338_b + (double)(attackTarget.field_70131_O / 3.0f) - this.field_70163_u;
            double dZ = attackTarget.field_70161_v - this.field_70161_v;
            float distance = 5.0f;
            double d0 = this.func_70092_e(attackTarget.field_70165_t, attackTarget.func_174813_aQ().field_72338_b, attackTarget.field_70161_v);
            this.func_70671_ap().func_75651_a((Entity)attackTarget, 30.0f, 30.0f);
            if (--this.rangedAttackTime == 0) {
                if (dX * dX + dY * dY + dZ * dZ > (double)(distance * distance)) {
                    float f = MathHelper.func_76133_a((double)d0) / distance;
                    this.func_82196_d(attackTarget, 0.0f);
                    this.rangedAttackTime = MathHelper.func_76141_d((float)(f * (float)(this.maxRangedAttackTime - this.minRangedAttackTime) + (float)this.minRangedAttackTime));
                }
            } else if (this.rangedAttackTime < 0) {
                float f2 = MathHelper.func_76133_a((double)d0) / distance;
                this.rangedAttackTime = MathHelper.func_76141_d((float)(f2 * (float)(this.maxRangedAttackTime - this.minRangedAttackTime) + (float)this.minRangedAttackTime));
            }
        }
        if (this.spawnedPreload != null) {
            for (UUID id : this.spawnedPreload) {
                Entity entity = null;
                for (Entity e : this.field_70170_p.func_72910_y()) {
                    if (!e.func_110124_au().equals(id)) continue;
                    entity = e;
                    break;
                }
                if (!(entity instanceof EntityJuicer)) continue;
                this.juicersSpawned.add((EntityJuicer)entity);
            }
            if (this.juicersSpawned.size() == this.spawnedPreload.size()) {
                this.spawnedPreload.clear();
                this.spawnedPreload = null;
            }
        }
        if (!this.field_70170_p.field_72995_K && this.shouldEvade) {
            if (this.spawner != null) {
                AxisAlignedBB roomBounds = this.spawner.getRangeBounds();
                double tarX = (roomBounds.field_72340_a + roomBounds.field_72336_d) / 2.0;
                double tarZ = (roomBounds.field_72339_c + roomBounds.field_72334_f) / 2.0;
                double dX = tarX - this.field_70165_t;
                double dY = roomBounds.field_72337_e - this.field_70163_u;
                double dZ = tarZ - this.field_70161_v;
                double movespeed = 1.0 * this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
                this.field_70159_w = Math.min(Math.max(dX / 2.0, -movespeed), movespeed);
                this.field_70179_y = Math.min(Math.max(dZ / 2.0, -movespeed), movespeed);
                this.field_70699_by.func_75492_a(tarX, this.field_70163_u, tarZ, movespeed);
                if (Math.abs(dX) < 0.1 && Math.abs(dZ) < 0.1) {
                    this.field_70181_x = Math.min(dY, 0.2);
                    if (Math.abs(dY) - (double)this.field_70131_O < 1.1 && Math.abs(this.field_70163_u - this.field_70137_T) < 0.05) {
                        if (this.getBurrowedCount() >= 0) {
                            if (this.field_70173_aa % 20 == 0 && this.juicersSpawned.size() < 6) {
                                EntityJuicer juicer = new EntityJuicer(this.field_70170_p);
                                double angle = Math.random() * 2.0 * Math.PI;
                                double dist = 3.0;
                                juicer.func_70107_b(this.field_70165_t + dist * Math.sin(angle), this.field_70163_u + (double)0.2f, this.field_70161_v + dist * Math.cos(angle));
                                juicer.setHanging(true);
                                this.field_70170_p.func_72838_d((Entity)juicer);
                                this.juicersSpawned.add(juicer);
                            }
                            if (this.getBurrowedCount() < 20) {
                                this.setBurrowedCount((byte)(this.getBurrowedCount() + 1));
                            }
                        } else {
                            this.setBurrowedCount((byte)0);
                        }
                    }
                }
            }
            if (!this.juicersSpawned.isEmpty()) {
                boolean allDead = true;
                for (EntityJuicer juicer : this.juicersSpawned) {
                    if (juicer.field_70128_L) continue;
                    allDead = false;
                }
                if (allDead) {
                    this.juicersSpawned.clear();
                    this.shouldEvade = false;
                    this.setBurrowedCount((byte)-1);
                }
            }
        }
    }

    public ItemStack getGuaranteedLoot(Random rand) {
        List stackList = GalacticraftRegistry.getDungeonLoot((int)3);
        return ((ItemStack)stackList.get(rand.nextInt(stackList.size()))).func_77946_l();
    }

    public void func_70653_a(Entity entityIn, float par2, double par3, double par4) {
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(150.0 * ConfigManagerCore.dungeonBossHealthMod);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25000000119209287);
    }

    protected float func_70647_i() {
        return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f + 0.4f;
    }

    protected float func_70599_aP() {
        return 5.0f;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187817_fK;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187821_fM;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187819_fL;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.5f, 0.5f);
    }

    protected Item func_146068_u() {
        return Items.field_151007_F;
    }

    protected void func_70628_a(boolean par1, int par2) {
        super.func_70628_a(par1, par2);
        if (par1 && (this.field_70146_Z.nextInt(3) == 0 || this.field_70146_Z.nextInt(1 + par2) > 0)) {
            this.func_145779_a(Items.field_151070_bp, 1);
        }
    }

    public void func_70110_aj() {
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        return potioneffectIn.func_188419_a() != MobEffects.field_76436_u && super.func_70687_e(potioneffectIn);
    }

    public float func_70047_e() {
        return 0.65f;
    }

    public boolean canBreath() {
        return true;
    }

    public boolean func_180431_b(DamageSource source) {
        if (this.getBurrowedCount() >= 0) {
            return true;
        }
        return super.func_180431_b(source);
    }

    protected void func_70665_d(DamageSource damageSrc, float damageAmount) {
        float healthLast = this.func_110143_aJ();
        super.func_70665_d(damageSrc, damageAmount);
        float health = this.func_110143_aJ();
        float thirdHealth = this.func_110138_aP() / 3.0f;
        if (health < thirdHealth && healthLast >= thirdHealth) {
            this.shouldEvade = true;
        } else if (health < 2.0f * thirdHealth && healthLast >= 2.0f * thirdHealth) {
            this.shouldEvade = true;
        }
    }

    public void func_82196_d(EntityLivingBase target, float damage) {
        EntityWebShot entityarrow = new EntityWebShot(this.field_70170_p, (EntityLivingBase)this, target, 0.8f, 14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4);
        this.func_184185_a(SoundEvents.field_187737_v, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)entityarrow);
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74757_a("should_evade", this.shouldEvade);
        NBTTagList list = new NBTTagList();
        for (EntityJuicer juicer : this.juicersSpawned) {
            list.func_74742_a((NBTBase)new NBTTagLong(juicer.getPersistentID().getMostSignificantBits()));
            list.func_74742_a((NBTBase)new NBTTagLong(juicer.getPersistentID().getLeastSignificantBits()));
        }
        tagCompound.func_74782_a("spawned_children", (NBTBase)list);
    }

    public void func_70037_a(NBTTagCompound tagCompound) {
        super.func_70037_a(tagCompound);
        this.shouldEvade = tagCompound.func_74767_n("should_evade");
        if (tagCompound.func_74764_b("spawned_children")) {
            this.spawnedPreload = Lists.newArrayList();
            NBTTagList list = tagCompound.func_150295_c("spawned_children", 4);
            for (int i = 0; i < list.func_74745_c(); i += 2) {
                NBTTagLong tagMost = (NBTTagLong)list.func_179238_g(i);
                NBTTagLong tagLeast = (NBTTagLong)list.func_179238_g(i + 1);
                this.spawnedPreload.add(new UUID(tagMost.func_150291_c(), tagLeast.func_150291_c()));
            }
        }
    }

    public int getChestTier() {
        return 3;
    }

    public EntityItem func_70099_a(ItemStack par1ItemStack, float par2) {
        EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)par2, this.field_70161_v, par1ItemStack);
        entityitem.field_70181_x = -2.0;
        entityitem.func_174869_p();
        if (this.captureDrops) {
            this.capturedDrops.add(entityitem);
        } else {
            this.field_70170_p.func_72838_d((Entity)entityitem);
        }
        return entityitem;
    }

    public void dropKey() {
        this.func_70099_a(new ItemStack(VenusItems.key, 1, 0), 0.5f);
    }

    public BossInfo.Color getHealthBarColor() {
        return BossInfo.Color.PURPLE;
    }

    public void func_184724_a(boolean swingingArms) {
    }
}

