/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworktables.modules.worktables.tile;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class MutuallyExclusiveStackHandlerWrapper
implements IItemHandler {
    private final ItemStackHandler handler;
    private BiMap<Item, Integer> indexMap;

    public MutuallyExclusiveStackHandlerWrapper(ItemStackHandler handler) {
        this.handler = handler;
        this.indexMap = HashBiMap.create((int)this.handler.getSlots());
    }

    public int getSlots() {
        return this.handler.getSlots();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.handler.getStackInSlot(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        slot = (Integer)this.indexMap.getOrDefault((Object)stack.func_77973_b(), (Object)slot);
        ItemStack existingItemStack = this.handler.getStackInSlot(slot);
        if (this.matchStacks(stack, existingItemStack)) {
            return this.handler.insertItem(slot, stack, simulate);
        }
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            existingItemStack = this.handler.getStackInSlot(i);
            if (!this.matchStacks(stack, existingItemStack)) continue;
            this.indexMap.forcePut((Object)stack.func_77973_b(), (Object)i);
            return this.handler.insertItem(i, stack, simulate);
        }
        return this.handler.insertItem(slot, stack, simulate);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.handler.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.handler.getSlotLimit(slot);
    }

    private boolean matchStacks(@Nonnull ItemStack stackToInsert, ItemStack existingItemStack) {
        return stackToInsert.func_77969_a(existingItemStack) && ItemStack.func_77970_a((ItemStack)existingItemStack, (ItemStack)stackToInsert);
    }
}

