/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworktables.modules.worktables.integration.jei;

import com.codetaylor.mc.artisanworktables.api.internal.recipe.OutputWeightPair;
import com.codetaylor.mc.artisanworktables.api.internal.reference.EnumTier;
import com.codetaylor.mc.artisanworktables.modules.worktables.integration.jei.JEIRecipeWrapper;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

public abstract class JEICategoryBase
implements IRecipeCategory {
    protected String tableName;
    protected EnumTier tier;
    protected String uid;
    protected IGuiHelper guiHelper;
    protected String titleTranslateKey;
    protected IDrawable background;

    public JEICategoryBase(String titleTranslateKey, IDrawable background, String name, EnumTier tier, String uid, IGuiHelper guiHelper) {
        this.titleTranslateKey = titleTranslateKey;
        this.background = background;
        this.tableName = name;
        this.tier = tier;
        this.uid = uid;
        this.guiHelper = guiHelper;
    }

    public String getUid() {
        return this.uid;
    }

    public String getTitle() {
        return I18n.func_135052_a((String)this.titleTranslateKey, (Object[])new Object[0]);
    }

    public String getModName() {
        return "Artisan Worktables";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    protected void setupTooltip(IGuiItemStackGroup stacks, List<OutputWeightPair> weightedOutput) {
        if (weightedOutput.size() > 1) {
            int sum = 0;
            for (OutputWeightPair pair : weightedOutput) {
                sum += pair.getWeight();
            }
            int weightSum = sum;
            stacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
                if (slotIndex == 0) {
                    for (OutputWeightPair pair : weightedOutput) {
                        if (!ItemStack.func_77989_b((ItemStack)pair.getOutput().toItemStack(), (ItemStack)ingredient)) continue;
                        int chance = Math.round((float)pair.getWeight() / (float)weightSum * 100.0f);
                        ArrayList result = new ArrayList();
                        result.add(tooltip.get(0));
                        result.add(I18n.func_135052_a((String)"jei.artisanworktables.tooltip.chance", (Object[])new Object[]{TextFormatting.GRAY, String.valueOf(chance)}));
                        for (int i = 1; i < tooltip.size(); ++i) {
                            result.add(tooltip.get(i));
                        }
                        tooltip.clear();
                        tooltip.addAll(result);
                    }
                }
            });
        }
    }

    public void drawExtras(Minecraft minecraft) {
        JEIRecipeWrapper.CATEGORY_TIER = this.tier;
    }
}

