/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworktables.modules.worktables.integration.crafttweaker;

import com.codetaylor.mc.artisanworktables.api.internal.recipe.ArtisanItemStack;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.ExtraOutputChancePair;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.IArtisanIngredient;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.IArtisanItemStack;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.ICraftingContext;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.ICraftingMatrixStackHandler;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.IRecipeMatrixMatcher;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.OutputWeightPair;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.ToolEntry;
import com.codetaylor.mc.artisanworktables.api.internal.util.Util;
import com.codetaylor.mc.artisanworktables.api.recipe.ArtisanRecipe;
import com.codetaylor.mc.artisanworktables.api.recipe.requirement.IRequirement;
import com.codetaylor.mc.artisanworktables.modules.worktables.integration.crafttweaker.CTArtisanCraftingInventory;
import com.codetaylor.mc.artisanworktables.modules.worktables.integration.crafttweaker.CTArtisanIngredient;
import com.codetaylor.mc.artisanworktables.modules.worktables.integration.crafttweaker.CTArtisanItemStack;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.recipes.CraftingInfo;
import crafttweaker.api.recipes.ICraftingInfo;
import crafttweaker.api.recipes.ICraftingInventory;
import crafttweaker.api.recipes.IRecipeAction;
import crafttweaker.api.recipes.IRecipeFunction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.fluids.FluidStack;

public class CTArtisanRecipe
extends ArtisanRecipe {
    private final IRecipeAction recipeAction;
    private final IRecipeFunction recipeFunction;

    CTArtisanRecipe(String name, Map<ResourceLocation, IRequirement> requirementMap, List<OutputWeightPair> output, ToolEntry[] tools, List<IArtisanIngredient> ingredients, List<IArtisanIngredient> secondaryIngredients, boolean consumeSecondaryIngredients, @Nullable FluidStack fluidIngredient, int experienceRequired, int levelRequired, boolean consumeExperience, ExtraOutputChancePair[] extraOutputs, IRecipeMatrixMatcher recipeMatrixMatcher, boolean mirrored, int width, int height, int minimumTier, int maximumTier, @Nullable IRecipeAction recipeAction, @Nullable IRecipeFunction recipeFunction, boolean hidden) {
        super(name, requirementMap, output, tools, ingredients, secondaryIngredients, consumeSecondaryIngredients, fluidIngredient, experienceRequired, levelRequired, consumeExperience, extraOutputs, recipeMatrixMatcher, mirrored, width, height, minimumTier, maximumTier, hidden);
        this.recipeAction = recipeAction;
        this.recipeFunction = recipeFunction;
    }

    @Override
    public IArtisanItemStack getBaseOutput(ICraftingContext context) {
        IArtisanItemStack output = super.getBaseOutput(context);
        if (this.recipeFunction != null) {
            return this.processRecipeFunction(this.recipeFunction, output, context);
        }
        return output;
    }

    @Override
    @Nonnull
    protected List<ItemStack> getRemainingItems(ICraftingContext context, NonNullList<ItemStack> itemStacks) {
        MatchInfo matchInfo = this.isShaped() ? this.getStacksShaped(context) : this.getStacksShapeless(context);
        ICraftingMatrixStackHandler matrixHandler = context.getCraftingMatrixHandler();
        List<IArtisanIngredient> ingredients = this.getIngredientList();
        IItemStack[] stacks = matchInfo.getStacks();
        int[] matrixIndices = matchInfo.getMatrixIndices();
        for (int i = 0; i < ingredients.size(); ++i) {
            IArtisanIngredient artisanIngredient = ingredients.get(i);
            if (artisanIngredient.isEmpty()) continue;
            if (artisanIngredient instanceof CTArtisanIngredient) {
                IIngredient ingredient = ((CTArtisanIngredient)artisanIngredient).getIngredient();
                if (!ingredient.hasNewTransformers()) continue;
                IItemStack remainingItem = null;
                try {
                    remainingItem = ingredient.applyNewTransform(stacks[i]);
                }
                catch (Throwable e) {
                    CraftTweakerAPI.logError((String)("Could not execute NewRecipeTransformer on " + ingredient.toCommandString()), (Throwable)e);
                }
                itemStacks.set(matrixIndices[i], (Object)CraftTweakerMC.getItemStack((IItemStack)remainingItem));
                continue;
            }
            itemStacks.set(matrixIndices[i], (Object)Util.getContainerItem(matrixHandler.getStackInSlot(matrixIndices[i])));
        }
        return itemStacks;
    }

    @Override
    protected ItemStack getRemainingSecondaryItem(ICraftingContext context, IArtisanIngredient artisanIngredient, ItemStack stack) {
        IIngredient ingredient;
        if (!artisanIngredient.isEmpty() && (ingredient = ((CTArtisanIngredient)artisanIngredient).getIngredient()).hasNewTransformers()) {
            IItemStack remainingItem = null;
            try {
                remainingItem = ingredient.applyNewTransform(CraftTweakerMC.getIItemStack((ItemStack)stack));
            }
            catch (Throwable e) {
                CraftTweakerAPI.logError((String)("Could not execute NewRecipeTransformer on " + ingredient.toCommandString()), (Throwable)e);
            }
            return CraftTweakerMC.getItemStack((IItemStack)remainingItem);
        }
        return super.getRemainingSecondaryItem(context, artisanIngredient, stack);
    }

    @Override
    protected void onCraftCompleteServer(ItemStack craftedItem, List<IArtisanItemStack> extraOutputList, ICraftingContext context) {
        super.onCraftCompleteServer(craftedItem, extraOutputList, context);
        if (this.recipeAction != null) {
            try {
                this.recipeAction.process(CraftTweakerMC.getIItemStack((ItemStack)craftedItem.func_77946_l()), (ICraftingInfo)this.getCraftingInfo(context), CraftTweakerMC.getIPlayer((EntityPlayer)context.getPlayer()));
            }
            catch (Throwable e) {
                CraftTweakerAPI.logError((String)"Error executing RecipeAction", (Throwable)e);
            }
        }
    }

    @ParametersAreNonnullByDefault
    private IArtisanItemStack processRecipeFunction(IRecipeFunction recipeFunction, IArtisanItemStack output, ICraftingContext context) {
        Map<String, IItemStack> marks = new HashMap<String, IItemStack>();
        marks = this.isShaped() ? this.getMarksShaped(context, marks) : this.getMarksShapeless(context, marks);
        try {
            IItemStack functionResult = recipeFunction.process(((CTArtisanItemStack)output).getIItemStack(), marks, (ICraftingInfo)this.getCraftingInfo(context));
            output = ArtisanItemStack.from(CraftTweakerMC.getItemStack((IItemStack)functionResult));
        }
        catch (Throwable e) {
            CraftTweakerAPI.logError((String)"Error executing RecipeFunction", (Throwable)e);
        }
        return output;
    }

    private Map<String, IItemStack> getMarksShapeless(ICraftingContext context, Map<String, IItemStack> marks) {
        List<IArtisanIngredient> ingredients = this.getIngredientList();
        IItemStack[] stacks = this.getStacksShapeless(context).getStacks();
        for (int i = 0; i < ingredients.size(); ++i) {
            CTArtisanIngredient ingredient;
            String mark;
            IArtisanIngredient artisanIngredient = ingredients.get(i);
            if (artisanIngredient.isEmpty() || (mark = (ingredient = (CTArtisanIngredient)artisanIngredient).getIngredient().getMark()) == null) continue;
            marks.put(mark, stacks[i]);
        }
        return marks;
    }

    private Map<String, IItemStack> getMarksShaped(ICraftingContext context, Map<String, IItemStack> marks) {
        List<IArtisanIngredient> ingredients = this.getIngredientList();
        IItemStack[] stacks = this.getStacksShaped(context).getStacks();
        for (int i = 0; i < ingredients.size(); ++i) {
            CTArtisanIngredient ctArtisanIngredient;
            String mark;
            IArtisanIngredient artisanIngredient = ingredients.get(i);
            if (artisanIngredient.isEmpty() || (mark = (ctArtisanIngredient = (CTArtisanIngredient)artisanIngredient).getIngredient().getMark()) == null) continue;
            marks.put(mark, stacks[i]);
        }
        return marks;
    }

    private MatchInfo getStacksShapeless(ICraftingContext context) {
        List<IArtisanIngredient> ingredients = this.getIngredientList();
        ICraftingMatrixStackHandler matrixHandler = context.getCraftingMatrixHandler();
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>(matrixHandler.getSlots());
        ArrayList<Integer> indexList = new ArrayList<Integer>(matrixHandler.getSlots());
        IItemStack[] stacks = new IItemStack[ingredients.size()];
        int[] indices = new int[ingredients.size()];
        for (int i = 0; i < matrixHandler.getSlots(); ++i) {
            ItemStack itemStack = matrixHandler.getStackInSlot(i);
            if (itemStack.func_190926_b()) continue;
            itemList.add(itemStack);
            indexList.add(i);
        }
        ArrayList<Ingredient> ingredientList = new ArrayList<Ingredient>(ingredients.size());
        for (IArtisanIngredient ingredient : ingredients) {
            ingredientList.add(ingredient.toIngredient());
        }
        int[] matches = RecipeMatcher.findMatches(itemList, ingredientList);
        for (int i = 0; i < matches.length; ++i) {
            stacks[matches[i]] = CraftTweakerMC.getIItemStack((ItemStack)((ItemStack)itemList.get(i)));
            indices[matches[i]] = (Integer)indexList.get(i);
        }
        return new MatchInfo(stacks, indices);
    }

    private MatchInfo getStacksShaped(ICraftingContext context) {
        int width = this.getWidth();
        int height = this.getHeight();
        boolean mirrored = this.isMirrored();
        List<IArtisanIngredient> ingredients = this.getIngredientList();
        ICraftingMatrixStackHandler matrixHandler = context.getCraftingMatrixHandler();
        IItemStack[] stacks = new IItemStack[ingredients.size()];
        int[] indices = new int[ingredients.size()];
        block0: for (int x = 0; x <= matrixHandler.getWidth() - width; ++x) {
            for (int y = 0; y <= matrixHandler.getHeight() - height; ++y) {
                if (this.getStacksArray(stacks, indices, ingredients, matrixHandler, x, y, width, height, false) || mirrored && this.getStacksArray(stacks, indices, ingredients, matrixHandler, x, y, width, height, true)) break block0;
            }
        }
        return new MatchInfo(stacks, indices);
    }

    private boolean getStacksArray(IItemStack[] stacks, int[] indices, List<IArtisanIngredient> ingredients, ICraftingMatrixStackHandler craftingMatrix, int startX, int startY, int width, int height, boolean mirror) {
        for (int x = 0; x < craftingMatrix.getWidth(); ++x) {
            for (int y = 0; y < craftingMatrix.getHeight(); ++y) {
                IArtisanIngredient ingredient;
                int index;
                int subX = x - startX;
                int subY = y - startY;
                if (subX < 0 || subY < 0 || subX >= width || subY >= height) continue;
                if (mirror) {
                    index = width - subX - 1 + subY * width;
                    ingredient = ingredients.get(index);
                } else {
                    index = subX + subY * width;
                    ingredient = ingredients.get(index);
                }
                int matrixIndex = x + y * craftingMatrix.getWidth();
                ItemStack candidate = craftingMatrix.getStackInSlot(matrixIndex);
                if (!ingredient.matches(candidate)) {
                    return false;
                }
                stacks[index] = CraftTweakerMC.getIItemStack((ItemStack)candidate);
                indices[index] = matrixIndex;
            }
        }
        return true;
    }

    private CraftingInfo getCraftingInfo(ICraftingContext context) {
        return new CraftingInfo((ICraftingInventory)new CTArtisanCraftingInventory(CraftTweakerMC.getIPlayer((EntityPlayer)context.getPlayer()), context.getCraftingMatrixHandler()), CraftTweakerMC.getIWorld((World)context.getWorld()));
    }

    private class MatchInfo {
        private final IItemStack[] stacks;
        private final int[] matrixIndices;

        private MatchInfo(IItemStack[] stacks, int[] matrixIndices) {
            this.stacks = stacks;
            this.matrixIndices = matrixIndices;
        }

        public IItemStack[] getStacks() {
            return this.stacks;
        }

        public int[] getMatrixIndices() {
            return this.matrixIndices;
        }
    }
}

