/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworktables.api.recipe;

import com.codetaylor.mc.artisanworktables.api.ArtisanConfig;
import com.codetaylor.mc.artisanworktables.api.ArtisanToolHandlers;
import com.codetaylor.mc.artisanworktables.api.event.ArtisanCraftEvent;
import com.codetaylor.mc.artisanworktables.api.internal.event.ArtisanInventory;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.ArtisanItemStack;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.ExtraOutputChancePair;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.IArtisanIngredient;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.IArtisanItemStack;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.ICraftingContext;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.ICraftingMatrixStackHandler;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.IRecipeMatrixMatcher;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.ISecondaryIngredientMatcher;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.OutputWeightPair;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.ToolEntry;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.WeightedPicker;
import com.codetaylor.mc.artisanworktables.api.internal.reference.EnumTier;
import com.codetaylor.mc.artisanworktables.api.internal.util.EnchantmentHelper;
import com.codetaylor.mc.artisanworktables.api.internal.util.Util;
import com.codetaylor.mc.artisanworktables.api.recipe.IArtisanRecipe;
import com.codetaylor.mc.artisanworktables.api.recipe.IToolHandler;
import com.codetaylor.mc.artisanworktables.api.recipe.requirement.IRequirement;
import com.codetaylor.mc.artisanworktables.api.recipe.requirement.IRequirementContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ArtisanRecipe
implements IArtisanRecipe {
    private String name;
    private ToolEntry[] tools;
    private Map<ResourceLocation, IRequirement> requirementMap;
    private List<OutputWeightPair> output;
    private List<IArtisanIngredient> ingredients;
    private List<IArtisanIngredient> secondaryIngredients;
    private boolean consumeSecondaryIngredients;
    private FluidStack fluidIngredient;
    private ExtraOutputChancePair[] extraOutputs;
    private IRecipeMatrixMatcher recipeMatrixMatcher;
    private boolean mirrored;
    private int width;
    private int height;
    private int minimumTier;
    private int maximumTier;
    private int experienceRequired;
    private int levelRequired;
    private boolean consumeExperience;
    private boolean hidden;

    @ParametersAreNonnullByDefault
    public ArtisanRecipe(@Nullable String name, Map<ResourceLocation, IRequirement> requirementMap, List<OutputWeightPair> output, ToolEntry[] tools, List<IArtisanIngredient> ingredients, List<IArtisanIngredient> secondaryIngredients, boolean consumeSecondaryIngredients, @Nullable FluidStack fluidIngredient, int experienceRequired, int levelRequired, boolean consumeExperience, ExtraOutputChancePair[] extraOutputs, IRecipeMatrixMatcher recipeMatrixMatcher, boolean mirrored, int width, int height, int minimumTier, int maximumTier, boolean hidden) {
        this.name = name;
        this.requirementMap = Collections.unmodifiableMap(requirementMap);
        this.output = output;
        this.tools = tools;
        this.ingredients = ingredients;
        this.secondaryIngredients = Collections.unmodifiableList(secondaryIngredients);
        this.consumeSecondaryIngredients = consumeSecondaryIngredients;
        this.fluidIngredient = fluidIngredient;
        this.experienceRequired = experienceRequired;
        this.levelRequired = levelRequired;
        this.consumeExperience = consumeExperience;
        this.extraOutputs = extraOutputs;
        this.recipeMatrixMatcher = recipeMatrixMatcher;
        this.mirrored = mirrored;
        this.width = width;
        this.height = height;
        this.minimumTier = minimumTier;
        this.maximumTier = maximumTier;
        this.hidden = hidden;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getExperienceRequired() {
        return this.experienceRequired;
    }

    @Override
    public int getLevelRequired() {
        return this.levelRequired;
    }

    @Override
    public boolean consumeExperience() {
        return this.consumeExperience;
    }

    @Override
    public IArtisanItemStack getSecondaryOutput() {
        if (this.extraOutputs[0].getOutput().isEmpty()) {
            return ArtisanItemStack.EMPTY;
        }
        return this.extraOutputs[0].getOutput();
    }

    @Override
    public float getSecondaryOutputChance() {
        return this.extraOutputs[0].getChance();
    }

    @Override
    public IArtisanItemStack getTertiaryOutput() {
        if (this.extraOutputs[1].getOutput().isEmpty()) {
            return ArtisanItemStack.EMPTY;
        }
        return this.extraOutputs[1].getOutput();
    }

    @Override
    public float getTertiaryOutputChance() {
        return this.extraOutputs[1].getChance();
    }

    @Override
    public IArtisanItemStack getQuaternaryOutput() {
        if (this.extraOutputs[2].getOutput().isEmpty()) {
            return ArtisanItemStack.EMPTY;
        }
        return this.extraOutputs[2].getOutput();
    }

    @Override
    public float getQuaternaryOutputChance() {
        return this.extraOutputs[2].getChance();
    }

    @Override
    @Nonnull
    public List<IArtisanIngredient> getSecondaryIngredients() {
        return this.secondaryIngredients;
    }

    @Override
    public boolean consumeSecondaryIngredients() {
        return this.consumeSecondaryIngredients;
    }

    @Override
    public IArtisanItemStack[] getTools(int toolIndex) {
        if (toolIndex >= this.tools.length) {
            return new IArtisanItemStack[0];
        }
        return this.tools[toolIndex].getTool();
    }

    @Override
    public List<IArtisanIngredient> getIngredientList() {
        return Collections.unmodifiableList(this.ingredients);
    }

    @Override
    @Nullable
    public FluidStack getFluidIngredient() {
        if (this.fluidIngredient != null) {
            return this.fluidIngredient.copy();
        }
        return null;
    }

    @Override
    public List<OutputWeightPair> getOutputWeightPairList() {
        return Collections.unmodifiableList(this.output);
    }

    @Override
    public IArtisanItemStack getBaseOutput(ICraftingContext context) {
        return this.output.get(0).getOutput();
    }

    @Override
    public boolean hasMultipleWeightedOutputs() {
        return this.output.size() > 1;
    }

    @Override
    public int getToolDamage(int toolIndex) {
        if (toolIndex >= this.tools.length) {
            return 0;
        }
        return this.tools[toolIndex].getDamage();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean isShaped() {
        return this.width > 0 && this.height > 0;
    }

    @Override
    public boolean isMirrored() {
        return this.mirrored;
    }

    @Override
    public int getToolCount() {
        return this.tools.length;
    }

    @Override
    @Nullable
    public IRequirement getRequirement(ResourceLocation resourceLocation) {
        return this.requirementMap.get(resourceLocation);
    }

    @Override
    public Map<ResourceLocation, IRequirement> getRequirements() {
        return this.requirementMap;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public boolean isValidTool(ItemStack tool, int toolIndex) {
        if (toolIndex >= this.tools.length) {
            return false;
        }
        for (IArtisanItemStack itemStack : this.tools[toolIndex].getTool()) {
            if (itemStack.getItem() != tool.func_77973_b()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasSufficientToolDurability(ItemStack tool, int toolIndex) {
        if (tool.func_190926_b()) {
            return false;
        }
        if (toolIndex >= this.tools.length) {
            return false;
        }
        if (ArtisanConfig.MODULE_WORKTABLES_CONFIG.restrictCraftMinimumDurability()) {
            IToolHandler handler = ArtisanToolHandlers.get(tool);
            int toolDamage = this.getToolDamage(toolIndex);
            return handler.canAcceptAllDamage(tool, toolDamage);
        }
        return true;
    }

    @Override
    public IArtisanItemStack selectOutput(ICraftingContext context, Random random) {
        if (this.hasMultipleWeightedOutputs()) {
            WeightedPicker<IArtisanItemStack> picker = new WeightedPicker<IArtisanItemStack>(random);
            for (OutputWeightPair pair : this.output) {
                picker.add(pair.getWeight(), pair.getOutput());
            }
            return (IArtisanItemStack)picker.get();
        }
        return this.getBaseOutput(context);
    }

    @Override
    public boolean matches(Map<ResourceLocation, IRequirementContext> requirementContextMap, int playerExperienceTotal, int playerLevels, boolean isPlayerCreative, ItemStack[] tools, ICraftingMatrixStackHandler craftingMatrix, FluidStack fluidStack, ISecondaryIngredientMatcher secondaryIngredientMatcher, EnumTier tier) {
        if (!this.matchTier(tier)) {
            return false;
        }
        if (!isPlayerCreative) {
            if (playerExperienceTotal < this.experienceRequired) {
                return false;
            }
            if (playerLevels < this.levelRequired) {
                return false;
            }
        }
        if (this.getToolCount() > tools.length) {
            return false;
        }
        for (int i = 0; i < this.getToolCount(); ++i) {
            if (this.isValidTool(tools[i], i) && this.hasSufficientToolDurability(tools[i], i)) continue;
            return false;
        }
        if (!this.matchesRequirements(requirementContextMap)) {
            return false;
        }
        if (!this.recipeMatrixMatcher.matches(this, craftingMatrix, fluidStack)) {
            return false;
        }
        if (!this.secondaryIngredients.isEmpty()) {
            return secondaryIngredientMatcher.matches(this.secondaryIngredients);
        }
        return true;
    }

    @Override
    public boolean matchesRequirements(Map<ResourceLocation, IRequirementContext> requirementContextMap) {
        for (IRequirement requirement : this.requirementMap.values()) {
            ResourceLocation location = requirement.getResourceLocation();
            IRequirementContext context = requirementContextMap.get(location);
            if (context == null) {
                return false;
            }
            if (requirement.match(context)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean matchTier(EnumTier tier) {
        return this.minimumTier <= tier.getId() && this.maximumTier >= tier.getId();
    }

    @Override
    public void doCraft(ICraftingContext context) {
        World world = context.getWorld();
        this.onCraftReduceExperience(context);
        this.onCraftReduceIngredients(context);
        this.onCraftReduceSecondaryIngredients(context);
        ItemStack craftedItem = ItemStack.field_190927_a;
        List<IArtisanItemStack> extraOutputList = new ArrayList<IArtisanItemStack>(3);
        if (!world.field_72995_K) {
            craftedItem = this.onCraftCheckAndSwapWeightedOutput(context);
            extraOutputList = this.onCraftProcessExtraOutput(context, extraOutputList);
        }
        for (int i = 0; i < this.getToolCount(); ++i) {
            this.onCraftDamageTool(context, i);
            this.onCraftCheckAndReplaceTool(context, i);
        }
        if (!world.field_72995_K && !craftedItem.func_190926_b()) {
            this.onCraftCompleteServer(craftedItem, extraOutputList, context);
        }
    }

    protected void onCraftCompleteServer(ItemStack craftedItem, List<IArtisanItemStack> extraOutputList, ICraftingContext context) {
        ArrayList<ItemStack> extraOutputConvertedList = new ArrayList<ItemStack>(extraOutputList.size());
        for (IArtisanItemStack artisanItemStack : extraOutputList) {
            extraOutputConvertedList.add(artisanItemStack.toItemStack());
        }
        MinecraftForge.EVENT_BUS.post((Event)new ArtisanCraftEvent.Post(context.getPlayer(), context.getType(), context.getTier(), craftedItem.func_77946_l(), extraOutputConvertedList));
        MinecraftForge.EVENT_BUS.post((Event)new PlayerEvent.ItemCraftedEvent(context.getPlayer(), craftedItem.func_77946_l(), (IInventory)new ArtisanInventory(context.getCraftingMatrixHandler(), context.getCraftingMatrixHandler().getWidth(), context.getCraftingMatrixHandler().getHeight())));
    }

    protected void onCraftReduceIngredients(ICraftingContext context) {
        ICraftingMatrixStackHandler matrixHandler = context.getCraftingMatrixHandler();
        IFluidHandler fluidHandler = context.getFluidHandler();
        List<ItemStack> remainingItems = this.getRemainingItems(context, (NonNullList<ItemStack>)NonNullList.func_191197_a((int)matrixHandler.getSlots(), (Object)ItemStack.field_190927_a));
        for (int i = 0; i < remainingItems.size(); ++i) {
            ItemStack itemStack = matrixHandler.getStackInSlot(i);
            ItemStack remainingItemStack = remainingItems.get(i);
            if (!itemStack.func_190926_b()) {
                matrixHandler.setStackInSlot(i, Util.decrease(itemStack.func_77946_l(), 1, false));
                itemStack = matrixHandler.getStackInSlot(i);
            }
            if (remainingItemStack.func_190926_b()) continue;
            if (itemStack.func_190926_b()) {
                matrixHandler.setStackInSlot(i, remainingItemStack);
                continue;
            }
            if (ItemStack.func_179545_c((ItemStack)itemStack, (ItemStack)remainingItemStack) && ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)remainingItemStack)) {
                int combinedStackSize = remainingItemStack.func_190916_E() + itemStack.func_190916_E();
                if (combinedStackSize > itemStack.func_77976_d()) {
                    ItemStack copy = remainingItemStack.func_77946_l();
                    copy.func_190920_e(itemStack.func_77976_d());
                    matrixHandler.setStackInSlot(i, copy);
                    combinedStackSize -= itemStack.func_77976_d();
                    while (combinedStackSize > itemStack.func_77976_d()) {
                        copy = remainingItemStack.func_77946_l();
                        copy.func_190920_e(itemStack.func_77976_d());
                        if (!context.getPlayer().func_191521_c(copy)) {
                            context.getPlayer().func_71019_a(copy, false);
                        }
                        combinedStackSize -= itemStack.func_77976_d();
                    }
                    remainingItemStack.func_190917_f(itemStack.func_190916_E());
                    if (context.getPlayer().func_191521_c(remainingItemStack)) continue;
                    context.getPlayer().func_71019_a(remainingItemStack, false);
                    continue;
                }
                remainingItemStack.func_190917_f(itemStack.func_190916_E());
                matrixHandler.setStackInSlot(i, remainingItemStack);
                continue;
            }
            if (context.getPlayer().func_191521_c(remainingItemStack)) continue;
            context.getPlayer().func_71019_a(remainingItemStack, false);
        }
        FluidStack fluidIngredient = this.getFluidIngredient();
        if (fluidIngredient != null) {
            fluidHandler.drain(fluidIngredient, true);
        }
    }

    @Nonnull
    protected List<ItemStack> getRemainingItems(ICraftingContext context, NonNullList<ItemStack> itemStacks) {
        ICraftingMatrixStackHandler matrixHandler = context.getCraftingMatrixHandler();
        for (int i = 0; i < matrixHandler.getSlots(); ++i) {
            itemStacks.set(i, (Object)Util.getContainerItem(matrixHandler.getStackInSlot(i)));
        }
        return itemStacks;
    }

    protected void onCraftReduceSecondaryIngredients(ICraftingContext context) {
        IItemHandlerModifiable secondaryIngredientHandler = context.getSecondaryIngredientHandler();
        if (!this.consumeSecondaryIngredients() || secondaryIngredientHandler == null) {
            return;
        }
        List<IArtisanIngredient> secondaryIngredients = this.secondaryIngredients;
        if (!secondaryIngredients.isEmpty()) {
            for (IArtisanIngredient requiredIngredient : secondaryIngredients) {
                int requiredAmount = requiredIngredient.getAmount();
                int slotCount = secondaryIngredientHandler.getSlots();
                for (int i = 0; i < slotCount; ++i) {
                    ItemStack stackInSlot = secondaryIngredientHandler.getStackInSlot(i);
                    if (stackInSlot.func_190926_b() || !requiredIngredient.matchesIgnoreAmount(stackInSlot)) continue;
                    ItemStack remainingItemStack = this.getRemainingSecondaryItem(context, requiredIngredient, stackInSlot);
                    int existingStackCount = stackInSlot.func_190916_E();
                    if (existingStackCount <= requiredAmount) {
                        if (remainingItemStack.func_190926_b()) {
                            secondaryIngredientHandler.setStackInSlot(i, ItemStack.field_190927_a);
                        } else {
                            secondaryIngredientHandler.setStackInSlot(i, ItemStack.field_190927_a);
                            remainingItemStack.func_190920_e(existingStackCount);
                            ItemStack itemStack = secondaryIngredientHandler.insertItem(i, remainingItemStack, false);
                            for (int j = 0; !itemStack.func_190926_b() && j < secondaryIngredientHandler.getSlots() && j != i; ++j) {
                                itemStack = secondaryIngredientHandler.insertItem(j, itemStack, false);
                            }
                            if (!itemStack.func_190926_b() && !context.getPlayer().func_191521_c(itemStack)) {
                                context.getPlayer().func_71019_a(itemStack, false);
                            }
                        }
                        requiredAmount -= existingStackCount;
                    } else if (existingStackCount > requiredAmount) {
                        ItemStack decreasedStack = Util.decrease(stackInSlot.func_77946_l(), requiredAmount, false);
                        secondaryIngredientHandler.setStackInSlot(i, decreasedStack);
                        if (!remainingItemStack.func_190926_b()) {
                            remainingItemStack.func_190920_e(requiredAmount);
                            ItemStack itemStack = secondaryIngredientHandler.insertItem(i, remainingItemStack, false);
                            for (int j = 0; !itemStack.func_190926_b() && j < secondaryIngredientHandler.getSlots() && j != i; ++j) {
                                itemStack = secondaryIngredientHandler.insertItem(j, itemStack, false);
                            }
                            if (!itemStack.func_190926_b() && !context.getPlayer().func_191521_c(itemStack)) {
                                context.getPlayer().func_71019_a(itemStack, false);
                            }
                        }
                        requiredAmount = 0;
                    }
                    if (requiredAmount == 0) break;
                }
                if (requiredAmount <= 0) continue;
            }
        }
    }

    protected ItemStack getRemainingSecondaryItem(ICraftingContext context, IArtisanIngredient ingredient, ItemStack stack) {
        return Util.getContainerItem(stack);
    }

    protected void onCraftReduceExperience(ICraftingContext context) {
        EntityPlayer player = context.getPlayer();
        if (player.func_184812_l_()) {
            return;
        }
        if (this.consumeExperience()) {
            if (this.getExperienceRequired() > 0) {
                EnchantmentHelper.adjustPlayerExperience(player, -this.getExperienceRequired());
            } else if (this.getLevelRequired() > 0) {
                int experience = EnchantmentHelper.getExperienceToLevel(player.field_71068_ca - this.getLevelRequired(), player.field_71068_ca);
                EnchantmentHelper.adjustPlayerExperience(player, -experience);
            }
        }
    }

    @Nonnull
    protected ItemStack onCraftCheckAndSwapWeightedOutput(ICraftingContext context) {
        ItemStack itemStack = this.selectOutput(context, Util.RANDOM).toItemStack();
        EntityPlayer player = context.getPlayer();
        if (!player.field_71071_by.func_70445_o().func_190926_b() && this.hasMultipleWeightedOutputs()) {
            player.field_71071_by.func_70437_b(itemStack);
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketSetSlot(-1, -1, itemStack));
        }
        return itemStack;
    }

    @Nonnull
    protected List<IArtisanItemStack> onCraftProcessExtraOutput(ICraftingContext context, List<IArtisanItemStack> result) {
        IArtisanItemStack extraOutput = this.getSecondaryOutput();
        if (!extraOutput.isEmpty() && Util.RANDOM.nextFloat() < this.getSecondaryOutputChance()) {
            result.add(this.generateExtraOutput(context, extraOutput));
        }
        if (!(extraOutput = this.getTertiaryOutput()).isEmpty() && Util.RANDOM.nextFloat() < this.getTertiaryOutputChance()) {
            result.add(this.generateExtraOutput(context, extraOutput));
        }
        if (!(extraOutput = this.getQuaternaryOutput()).isEmpty() && Util.RANDOM.nextFloat() < this.getQuaternaryOutputChance()) {
            result.add(this.generateExtraOutput(context, extraOutput));
        }
        return result;
    }

    protected void onCraftDamageTool(ICraftingContext context, int toolIndex) {
        int toolDamage;
        IToolHandler handler;
        boolean broken;
        World world = context.getWorld();
        EntityPlayer player = context.getPlayer();
        IItemHandlerModifiable toolHandler = context.getToolHandler();
        ItemStack itemStack = toolHandler.getStackInSlot(toolIndex);
        if (!itemStack.func_190926_b() && this.isValidTool(itemStack, toolIndex) && (broken = (handler = ArtisanToolHandlers.get(itemStack)).applyDamage(world, itemStack, toolDamage = this.getToolDamage(toolIndex), false)) && !world.field_72995_K) {
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187635_cQ, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
    }

    protected void onCraftCheckAndReplaceTool(ICraftingContext context, int toolIndex) {
        IItemHandlerModifiable toolHandler = context.getToolHandler();
        ItemStack itemStack = toolHandler.getStackInSlot(toolIndex);
        if (!this.hasSufficientToolDurability(itemStack, toolIndex)) {
            IItemHandler capability = context.getToolReplacementHandler();
            if (capability == null) {
                return;
            }
            int slotCount = capability.getSlots();
            for (int i = 0; i < slotCount; ++i) {
                ItemStack potentialTool = capability.getStackInSlot(i);
                if (potentialTool.func_190926_b() || !this.isValidTool(potentialTool, toolIndex) || !this.hasSufficientToolDurability(potentialTool, toolIndex)) continue;
                potentialTool = capability.extractItem(i, 1, false);
                capability.insertItem(i, toolHandler.getStackInSlot(toolIndex), false);
                toolHandler.setStackInSlot(toolIndex, potentialTool);
            }
        }
    }

    @Nonnull
    protected IArtisanItemStack generateExtraOutput(ICraftingContext context, IArtisanItemStack extraOutput) {
        World world = context.getWorld();
        IItemHandler secondaryOutputHandler = context.getSecondaryOutputHandler();
        ItemStack result = extraOutput.toItemStack();
        for (int i = 0; i < 3 && !(result = secondaryOutputHandler.insertItem(i, result, false)).func_190926_b(); ++i) {
        }
        if (!result.func_190926_b() && !world.field_72995_K) {
            BlockPos pos = context.getPosition();
            Util.spawnStackOnTop(world, result, pos.func_177982_a(0, 1, 0), 1.0);
        }
        return ArtisanItemStack.from(result);
    }
}

