/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen;

import greymerk.roguelike.worldgen.Cardinal;
import java.util.Objects;
import net.minecraft.util.math.BlockPos;

public class Coord {
    private int x;
    private int y;
    private int z;

    public Coord(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Coord(Coord toClone) {
        this.x = toClone.x;
        this.y = toClone.y;
        this.z = toClone.z;
    }

    public Coord(BlockPos bp) {
        this.x = bp.func_177958_n();
        this.y = bp.func_177956_o();
        this.z = bp.func_177952_p();
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public void add(Cardinal dir, int amount) {
        switch (dir) {
            case EAST: {
                this.x += amount;
                return;
            }
            case WEST: {
                this.x -= amount;
                return;
            }
            case UP: {
                this.y += amount;
                return;
            }
            case DOWN: {
                this.y -= amount;
                return;
            }
            case NORTH: {
                this.z -= amount;
                return;
            }
            case SOUTH: {
                this.z += amount;
                return;
            }
        }
    }

    public Coord add(Coord other) {
        this.x += other.x;
        this.y += other.y;
        this.z += other.z;
        return this;
    }

    public Coord sub(Coord other) {
        this.x -= other.x;
        this.y -= other.y;
        this.z -= other.z;
        return this;
    }

    public void add(Cardinal dir) {
        this.add(dir, 1);
    }

    public double distance(Coord other) {
        double side1 = Math.abs(this.getX() - other.getX());
        double side2 = Math.abs(this.getZ() - other.getZ());
        return Math.sqrt(side1 * side1 + side2 * side2);
    }

    public Cardinal dirTo(Coord other) {
        int xdiff = other.x - this.x;
        int zdiff = other.z - this.z;
        if (Math.abs(xdiff) < Math.abs(zdiff)) {
            if (zdiff < 0) {
                return Cardinal.NORTH;
            }
            return Cardinal.SOUTH;
        }
        if (xdiff < 0) {
            return Cardinal.WEST;
        }
        return Cardinal.EAST;
    }

    public static void correct(Coord one, Coord two) {
        int temp;
        if (two.x < one.x) {
            temp = two.x;
            two.x = one.x;
            one.x = temp;
        }
        if (two.y < one.y) {
            temp = two.y;
            two.y = one.y;
            one.y = temp;
        }
        if (two.z < one.z) {
            temp = two.z;
            two.z = one.z;
            one.z = temp;
        }
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z);
    }

    public String toString() {
        String toReturn = "";
        toReturn = toReturn + "x: " + this.x + " ";
        toReturn = toReturn + "y: " + this.y + " ";
        toReturn = toReturn + "z: " + this.z;
        return toReturn;
    }

    public boolean equals(Object o) {
        Coord other = (Coord)o;
        if (this.x != other.x) {
            return false;
        }
        if (this.y != other.y) {
            return false;
        }
        return this.z == other.z;
    }

    public BlockPos getBlockPos() {
        return new BlockPos(this.x, this.y, this.z);
    }
}

