/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_core.machines.tileentity;

import cofh.redstoneflux.api.IEnergyReceiver;
import cofh.redstoneflux.impl.EnergyStorage;
import com.globbypotato.rockhounding_core.handlers.ModConfig;
import com.globbypotato.rockhounding_core.machines.tileentity.IEnergyHandlingTile;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityFueledMachine;
import com.globbypotato.rockhounding_core.utils.CoreBasics;
import com.globbypotato.rockhounding_core.utils.CoreUtils;
import com.globbypotato.rockhounding_core.utils.FuelUtils;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public abstract class TileEntityPoweredMachine
extends TileEntityFueledMachine
implements IEnergyHandlingTile {
    public int redstoneCount = 0;
    public int redstoneMax = 64000;
    public int yeldCount = 0;
    public int yeldMax = 9000;
    public int chargeCount = 0;
    public int chargeMax = 1000000;
    public int redstoneFactor = 300;
    public final EnergyStorage storage = new EnergyStorage(this.rfTransfer());
    public boolean permanentInductor;

    public TileEntityPoweredMachine(int inputSlots, int outputSlots, int templateSlots, int upgradeSlots) {
        super(inputSlots, outputSlots, templateSlots, upgradeSlots);
    }

    @Override
    public boolean hasRF() {
        return false;
    }

    protected boolean isRFGatedByBlend() {
        return false;
    }

    public int getRFConsume() {
        return this.redstoneFactor;
    }

    @Override
    public boolean canInduct() {
        return this.hasPermanentInduction() || !this.hasPermanentInduction() && this.input.getSlots() > 0 && this.fuelID() > -1 && !this.input.getStackInSlot(this.fuelID()).func_190926_b() && this.input.getStackInSlot(this.fuelID()).func_77969_a(CoreBasics.heat_inductor);
    }

    public boolean hasPermanentInduction() {
        return this.allowPermanentInduction() && this.isInductionActive();
    }

    public boolean isInductionActive() {
        return this.permanentInductor;
    }

    public boolean allowPermanentInduction() {
        return ModConfig.enablePermanentInduction;
    }

    public boolean enableGatedFuel() {
        return ModConfig.enableGatedFuel;
    }

    public void powerHandler(ItemStack stack) {
        if (this.fuelID() > -1 && !stack.func_190926_b() && this.allowPermanentInduction() && !this.isInductionActive() && ItemStack.func_179545_c((ItemStack)stack, (ItemStack)CoreBasics.heat_inductor)) {
            this.permanentInductor = true;
            this.input.setStackInSlot(this.fuelID(), ItemStack.field_190927_a);
        }
    }

    @Override
    public boolean isGatedPowerSource(ItemStack insertingStack) {
        return !this.hasFuelBlend() && FuelUtils.isItemFuel(insertingStack) && !this.isFuelGated() || CoreUtils.hasInductor(insertingStack) || this.hasFuelBlend() && CoreUtils.hasBlend(insertingStack) && !this.isFuelGated();
    }

    public boolean isFuelGated() {
        return this.allowPermanentInduction() && this.isInductionActive() && this.enableGatedFuel();
    }

    public boolean hasRedstone(ItemStack insertingStack) {
        return !this.hasFuelBlend() && !insertingStack.func_190926_b() && (insertingStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150451_bX) || insertingStack.func_77973_b() == Items.field_151137_ax || insertingStack.func_77969_a(CoreBasics.gas_turbine));
    }

    protected void redstoneHandler(int slot, int cooktime) {
        ItemStack stack = this.input.getStackInSlot(slot);
        if (!stack.func_190926_b()) {
            if (stack.func_77973_b() == Items.field_151137_ax && this.getRedstone() <= this.getRedstoneMax() - cooktime) {
                this.burnRedstone(slot, stack, cooktime);
            } else if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150451_bX) && this.getRedstone() <= this.getRedstoneMax() - cooktime * 9) {
                this.burnRedstone(slot, stack, cooktime * 9);
            }
        }
    }

    private void burnRedstone(int slot, ItemStack stack, int charge) {
        this.redstoneCount += charge;
        stack.func_190918_g(1);
        if (stack.func_190916_E() <= 0) {
            this.input.setStackInSlot(slot, ItemStack.field_190927_a);
        }
    }

    public boolean isRedstoneRequired(int amount) {
        return this.hasFuelBlend() && this.isRFGatedByBlend() ? true : this.getRedstone() >= amount;
    }

    public boolean isRedstoneRefilled() {
        return this.hasFuelBlend() && this.isRFGatedByBlend() ? true : this.isFullRedstone();
    }

    public boolean redstoneIsRefillable() {
        return this.hasRF() && (!this.hasFuelBlend() || this.hasFuelBlend() && !this.isRFGatedByBlend());
    }

    public boolean canRefillOnlyPower() {
        return this.canInduct() && !this.hasRF();
    }

    public boolean isRedstoneFilled() {
        return this.canInduct() && this.hasRF();
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.redstoneCount = compound.func_74762_e("RedstoneCount");
        this.permanentInductor = compound.func_74767_n("Inductor");
        this.storage.readFromNBT(compound.func_74775_l("StorageNBT"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("RedstoneCount", this.getRedstone());
        compound.func_74757_a("Inductor", this.isInductionActive());
        NBTTagCompound storageNBT = new NBTTagCompound();
        this.storage.writeToNBT(storageNBT);
        compound.func_74782_a("StorageNBT", (NBTBase)storageNBT);
        return compound;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getRedstone() {
        return this.redstoneCount;
    }

    @Override
    public int getRedstoneMax() {
        return this.redstoneMax;
    }

    @Override
    public int getChargeMax() {
        return this.chargeMax;
    }

    @Override
    public int getYeld() {
        return this.yeldCount;
    }

    @Override
    public int getYeldMax() {
        return this.yeldMax;
    }

    public int rfTransfer() {
        return 2000;
    }

    public void injectEnergy() {
        int energyReceived = 0;
        if (this.redstoneIsRefillable()) {
            if (!this.isFullRedstone()) {
                energyReceived = Math.min(this.getRedstoneMax() - this.getRedstone(), this.storage.getEnergyStored());
                this.redstoneCount += energyReceived;
                this.storage.extractEnergy(energyReceived, false);
                this.markDirtyClient();
            } else {
                this.redstoneCount = this.getRedstoneMax();
                this.markDirtyClient();
            }
        }
    }

    public void injectFuel() {
        int energyReceived = 0;
        if (this.isRedstoneFilled() || this.canRefillOnlyPower()) {
            if (!this.isFullPower()) {
                energyReceived = Math.min(this.getPowerMax() - this.getPower(), this.storage.getEnergyStored());
                this.powerCount += energyReceived;
                this.storage.extractEnergy(energyReceived, false);
                this.markDirtyClient();
            } else {
                this.powerCount = this.getPowerMax();
                this.markDirtyClient();
            }
        }
    }

    public void sendEnergy(TileEntity checkTile, EnumFacing facing) {
        IEnergyReceiver te;
        int possibleEnergy = 0;
        if (checkTile.hasCapability(CapabilityEnergy.ENERGY, facing.func_176734_d()) && ((IEnergyStorage)checkTile.getCapability(CapabilityEnergy.ENERGY, facing.func_176734_d())).canReceive()) {
            possibleEnergy = ((IEnergyStorage)checkTile.getCapability(CapabilityEnergy.ENERGY, facing.func_176734_d())).receiveEnergy(this.getRedstone(), true);
            if (possibleEnergy > 0) {
                ((IEnergyStorage)checkTile.getCapability(CapabilityEnergy.ENERGY, facing.func_176734_d())).receiveEnergy(possibleEnergy, false);
                this.redstoneCount -= possibleEnergy;
            }
        } else if (checkTile instanceof IEnergyReceiver && (te = (IEnergyReceiver)checkTile).canConnectEnergy(facing) && (possibleEnergy = te.receiveEnergy(facing.func_176734_d(), this.getRedstone(), true)) > 0) {
            te.receiveEnergy(facing.func_176734_d(), possibleEnergy, false);
            this.redstoneCount -= possibleEnergy;
        }
    }
}

